/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SeparatorKind implements Enumerator
{
    HASH(0, "hash", "#"),
    SLASH(1, "slash", "/");

    public static final int HASH_VALUE = 0;
    public static final int SLASH_VALUE = 1;
    private static final SeparatorKind[] VALUES_ARRAY;
    public static final List<SeparatorKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SeparatorKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SeparatorKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SeparatorKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SeparatorKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SeparatorKind get(int value) {
        switch (value) {
            case 0: {
                return HASH;
            }
            case 1: {
                return SLASH;
            }
        }
        return null;
    }

    private SeparatorKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SeparatorKind[]{HASH, SLASH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

