/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.resource;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.opencaesar.oml.OmlPackage;
import io.opencaesar.oml.resource.OmlJsonURIHandler;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfcloud.jackson.handlers.URIHandler;
import org.eclipse.emfcloud.jackson.module.EMFModule;
import org.eclipse.emfcloud.jackson.resource.JsonResource;

public class OmlJsonResource
extends JsonResource {
    public OmlJsonResource(URI uri) {
        this(uri, true);
    }

    public OmlJsonResource(URI uri, boolean useCatalog) {
        super(uri);
        this.setTrackingModification(true);
        this.setObjectMapper(this.setupDefaultMapper(useCatalog));
    }

    protected void attachedHelper(EObject eObject) {
        this.setID(eObject, EcoreUtil.getID((EObject)eObject));
        super.attachedHelper(eObject);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ResourceImpl.ModificationTrackingAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getFeature() == OmlPackage.Literals.MEMBER__NAME) {
                    if (notification.getOldValue() != null) {
                        OmlJsonResource.this.getIDToEObjectMap().remove(notification.getOldValue());
                    }
                    if (notification.getNewValue() != null) {
                        OmlJsonResource.this.getIDToEObjectMap().put((String)notification.getNewValue(), (EObject)notification.getNotifier());
                    }
                }
            }
        };
    }

    private ObjectMapper setupDefaultMapper(boolean useCatalog) {
        ObjectMapper mapper = new ObjectMapper(null);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getDefault());
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.setDateFormat((DateFormat)dateFormat);
        mapper.setTimeZone(TimeZone.getDefault());
        EMFModule module = new EMFModule();
        if (useCatalog) {
            module.setUriHandler((URIHandler)new OmlJsonURIHandler((Resource)this));
        }
        mapper.registerModule((Module)module);
        return mapper;
    }
}

