/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.resource;

import io.opencaesar.oml.Import;
import io.opencaesar.oml.Member;
import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.SeparatorKind;
import io.opencaesar.oml.util.OmlRead;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emfcloud.jackson.handlers.BaseURIHandler;

public class OmlJsonURIHandler
extends BaseURIHandler {
    private Resource resource;

    public OmlJsonURIHandler(Resource resource) {
        this.resource = resource;
    }

    public URI resolve(URI baseURI, URI uri) {
        String[] qname = uri.toString().split(":");
        if (!uri.toString().contains("/") && qname.length == 2) {
            URI resolvedUri;
            Ontology ontology = OmlRead.getOntology(this.resource);
            Import _import = ontology.getOwnedImports().stream().filter(i -> qname[0].equals(i.getPrefix())).findFirst().orElse(null);
            if (_import != null && (resolvedUri = OmlRead.getResolvedUri(this.resource, _import.getIri())) != null) {
                return URI.createURI((String)(resolvedUri.toString() + SeparatorKind.HASH.toString() + qname[1]));
            }
            return URI.createHierarchicalURI((String[])new String[]{qname[0]}, null, (String)qname[1]);
        }
        return super.resolve(baseURI, uri);
    }

    public URI deresolve(URI baseURI, URI uri) {
        EObject obj = this.resource.getResourceSet().getEObject(uri, true);
        if (obj instanceof Member) {
            Ontology ontology = OmlRead.getOntology(this.resource);
            String iri = OmlRead.getAbbreviatedIriIn((Member)obj, ontology);
            if (iri != null) {
                return URI.createURI((String)iri);
            }
            throw new RuntimeException("References to <" + uri + "> do not have a corresponding import statement");
        }
        return super.deresolve(baseURI, uri);
    }
}

