/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.resource;

import io.opencaesar.oml.OmlPackage;
import io.opencaesar.oml.resource.OmlXMIURIHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public final class OmlXMIResource
extends XMIResourceImpl {
    private final Map<String, EObject> idToEObjectMap = new HashMap<String, EObject>();

    public OmlXMIResource(URI uri) {
        this(uri, true);
    }

    public OmlXMIResource(URI uri, boolean useCatalog) {
        super(uri);
        this.setIntrinsicIDToEObjectMap(this.idToEObjectMap);
        this.setTrackingModification(true);
        this.getDefaultLoadOptions().put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        this.getDefaultSaveOptions().put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        this.getDefaultSaveOptions().put("EXTENDED_META_DATA", new OmlExtendedMetaData());
        this.getDefaultSaveOptions().put("USE_CACHED_LOOKUP_TABLE", new ArrayList());
        if (useCatalog) {
            OmlXMIURIHandler handler = new OmlXMIURIHandler((Resource)this);
            this.getDefaultLoadOptions().put("URI_HANDLER", handler);
            this.getDefaultSaveOptions().put("URI_HANDLER", handler);
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        HashMap mergedOptions = new HashMap(options);
        mergedOptions.put("URI_HANDLER", this.getDefaultLoadOptions().get("URI_HANDLER"));
        super.load(mergedOptions);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ResourceImpl.ModificationTrackingAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getFeature() == OmlPackage.Literals.MEMBER__NAME) {
                    if (notification.getOldValue() != null) {
                        OmlXMIResource.this.idToEObjectMap.remove(notification.getOldValue());
                    }
                    if (notification.getNewValue() != null) {
                        OmlXMIResource.this.idToEObjectMap.put((String)notification.getNewValue(), (EObject)notification.getNotifier());
                    }
                }
            }
        };
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        HashMap mergedOptions = new HashMap(options);
        mergedOptions.remove("LINE_WIDTH");
        mergedOptions.put("URI_HANDLER", this.getDefaultSaveOptions().get("URI_HANDLER"));
        super.doSave(outputStream, mergedOptions);
    }

    private class OmlExtendedMetaData
    extends BasicExtendedMetaData {
        private String ownedImportsName = OmlPackage.Literals.ONTOLOGY__OWNED_IMPORTS.getName();

        private OmlExtendedMetaData() {
        }

        public List<EStructuralFeature> getAllElements(EClass eClass) {
            EStructuralFeature ownedImports;
            ArrayList<EStructuralFeature> features = super.getAllElements(eClass);
            if (!eClass.isAbstract() && OmlPackage.Literals.ONTOLOGY.isSuperTypeOf(eClass) && (ownedImports = (EStructuralFeature)(features = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)eClass.getEAllReferences())).stream().filter(f -> f.getName().equals(this.ownedImportsName)).findFirst().orElse(null)) != null) {
                features.remove(ownedImports);
                features.add(0, ownedImports);
            }
            return features;
        }
    }
}

