/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.util;

import com.google.common.collect.HashBasedTable;
import io.opencaesar.oml.Annotation;
import io.opencaesar.oml.AnnotationProperty;
import io.opencaesar.oml.Argument;
import io.opencaesar.oml.Aspect;
import io.opencaesar.oml.BooleanLiteral;
import io.opencaesar.oml.BuiltIn;
import io.opencaesar.oml.BuiltInPredicate;
import io.opencaesar.oml.CardinalityRestrictionKind;
import io.opencaesar.oml.ClassifierEquivalenceAxiom;
import io.opencaesar.oml.Concept;
import io.opencaesar.oml.ConceptInstance;
import io.opencaesar.oml.DecimalLiteral;
import io.opencaesar.oml.Description;
import io.opencaesar.oml.DescriptionBundle;
import io.opencaesar.oml.DifferentFromPredicate;
import io.opencaesar.oml.DoubleLiteral;
import io.opencaesar.oml.Element;
import io.opencaesar.oml.ForwardRelation;
import io.opencaesar.oml.IdentifiedElement;
import io.opencaesar.oml.Import;
import io.opencaesar.oml.ImportKind;
import io.opencaesar.oml.InstanceEnumerationAxiom;
import io.opencaesar.oml.IntegerLiteral;
import io.opencaesar.oml.KeyAxiom;
import io.opencaesar.oml.Literal;
import io.opencaesar.oml.LiteralEnumerationAxiom;
import io.opencaesar.oml.Member;
import io.opencaesar.oml.NamedInstance;
import io.opencaesar.oml.OmlPackage;
import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.Predicate;
import io.opencaesar.oml.PropertyCardinalityRestrictionAxiom;
import io.opencaesar.oml.PropertyEquivalenceAxiom;
import io.opencaesar.oml.PropertyPredicate;
import io.opencaesar.oml.PropertyRangeRestrictionAxiom;
import io.opencaesar.oml.PropertySelfRestrictionAxiom;
import io.opencaesar.oml.PropertyValueAssertion;
import io.opencaesar.oml.PropertyValueRestrictionAxiom;
import io.opencaesar.oml.QuotedLiteral;
import io.opencaesar.oml.RangeRestrictionKind;
import io.opencaesar.oml.RelationBase;
import io.opencaesar.oml.RelationEntity;
import io.opencaesar.oml.RelationEntityPredicate;
import io.opencaesar.oml.RelationInstance;
import io.opencaesar.oml.ReverseRelation;
import io.opencaesar.oml.Rule;
import io.opencaesar.oml.SameAsPredicate;
import io.opencaesar.oml.Scalar;
import io.opencaesar.oml.ScalarEquivalenceAxiom;
import io.opencaesar.oml.ScalarProperty;
import io.opencaesar.oml.SpecializationAxiom;
import io.opencaesar.oml.Structure;
import io.opencaesar.oml.StructureInstance;
import io.opencaesar.oml.StructuredProperty;
import io.opencaesar.oml.TypeAssertion;
import io.opencaesar.oml.TypePredicate;
import io.opencaesar.oml.UnreifiedRelation;
import io.opencaesar.oml.Vocabulary;
import io.opencaesar.oml.VocabularyBundle;
import io.opencaesar.oml.util.OmlRead;
import io.opencaesar.oml.util.OmlWrite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class OmlBuilder {
    private final HashBasedTable<Ontology, String, Element> cache = HashBasedTable.create();
    private final ResourceSet resourceSet;
    private final Set<Resource> newResources = new LinkedHashSet<Resource>();
    private final List<Runnable> defer = new ArrayList<Runnable>();

    public OmlBuilder(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void addToNewResources(Ontology ontology, URI resourceURI) {
        Resource resource = this.resourceSet.createResource(resourceURI);
        resource.getContents().add((Object)ontology);
        this.newResources.add(resource);
    }

    public Collection<Resource> getNewResources() {
        return this.newResources;
    }

    public void start() {
        EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
    }

    public void finish() {
        this.defer.forEach(p -> p.run());
        this.defer.clear();
    }

    protected void setCrossReference(Ontology ontology, Element subject, EReference eRef, String objectIri) {
        Class objectClass = eRef.getEType().getInstanceClass();
        assert (!eRef.isContainment()) : eRef.getName() + " is a containment reference";
        assert (!eRef.isMany()) : eRef.getName() + " is a List reference";
        assert (IdentifiedElement.class.isAssignableFrom(objectClass)) : eRef.getName() + " is not typed by an identified element";
        if (objectIri != null) {
            if (eRef.isMany()) {
                this.defer.add(() -> ((List)subject.eGet((EStructuralFeature)eRef)).add(this.resolve(objectClass, ontology, objectIri)));
            } else {
                this.defer.add(() -> subject.eSet((EStructuralFeature)eRef, this.resolve(objectClass, ontology, objectIri)));
            }
        }
    }

    protected void setCrossReferences(Ontology ontology, Element subject, EReference eRef, List<String> objectIris) {
        Class objectClass = eRef.getEType().getInstanceClass();
        assert (!eRef.isContainment()) : eRef.getName() + " is a containment reference";
        assert (eRef.isMany()) : eRef.getName() + " is a singular reference";
        assert (IdentifiedElement.class.isAssignableFrom(objectClass)) : eRef.getName() + " is not typed by an identified element";
        if (objectIris.iterator().hasNext()) {
            this.defer.add(() -> subject.eSet((EStructuralFeature)eRef, objectIris.stream().map(objectIri -> this.resolve(objectClass, ontology, (String)objectIri)).collect(Collectors.toList())));
        }
    }

    protected void setContainmentReference(Ontology ontology, String subjectIri, EReference elementERef, Element object) {
        Class objectClass = elementERef.getEType().getInstanceClass();
        assert (elementERef.isContainment()) : elementERef.getName() + " is not a containment reference";
        assert (objectClass.isInstance(object)) : object + " is not an instance of " + objectClass.getName();
        assert (elementERef.getEType() == elementERef.getEType()) : elementERef.getName() + " does not have the same type as " + elementERef.getName();
        if (subjectIri != null) {
            this.defer.add(() -> {
                Member member = this.resolve(Member.class, ontology, subjectIri);
                if (member.getOntology() == ontology) {
                    if (elementERef.isMany()) {
                        ((List)member.eGet((EStructuralFeature)elementERef)).add(object);
                    } else {
                        member.eSet((EStructuralFeature)elementERef, object);
                    }
                } else if (elementERef.isMany()) {
                    ((List)OmlWrite.getOrAddRef(ontology, member).eGet((EStructuralFeature)elementERef)).add(object);
                } else {
                    OmlWrite.getOrAddRef(ontology, member).eSet((EStructuralFeature)elementERef, object);
                }
            });
        }
    }

    protected <T extends IdentifiedElement> T resolve(Class<T> type, Ontology context, String iri) {
        Element element = (Element)this.cache.get((Object)context, (Object)iri);
        if (element == null) {
            EObject obj;
            String fragment;
            String baseIri;
            int i = iri.lastIndexOf(35);
            if (i > 0) {
                baseIri = iri.substring(0, i);
            } else {
                i = iri.lastIndexOf(47);
                baseIri = iri.substring(0, i);
            }
            if (i > 0) {
                fragment = iri.substring(i + 1);
            } else {
                i = iri.lastIndexOf(47);
                fragment = iri.substring(i + 1);
            }
            Resource resource = null;
            if (context.getIri().equals(baseIri)) {
                resource = context.eResource();
            } else {
                Ontology ontology = OmlRead.getImportedOntologyByIri(context, baseIri);
                if (ontology != null) {
                    resource = ontology.eResource();
                } else {
                    throw new RuntimeException("could not resolve " + baseIri + " in context of " + context.getIri());
                }
            }
            if (resource != null && (obj = resource.getEObject(fragment)) instanceof Element) {
                element = (Element)obj;
            }
            if (element == null) {
                throw new RuntimeException("could not resolve " + iri + " in context of " + context.getIri());
            }
            this.cache.put((Object)context, (Object)iri, (Object)element);
        }
        return (T)((IdentifiedElement)type.cast(element));
    }

    public Annotation addAnnotation(Ontology ontology, String propertyIri, Literal literalValue, String referencedValueIri) {
        Annotation annotation = OmlWrite.addAnnotation(ontology, null, literalValue, null);
        if (referencedValueIri != null) {
            this.setCrossReference(ontology, annotation, OmlPackage.Literals.ANNOTATION__REFERENCED_VALUE, referencedValueIri);
        }
        this.setCrossReference(ontology, annotation, OmlPackage.Literals.ANNOTATION__PROPERTY, propertyIri);
        return annotation;
    }

    public Annotation addAnnotation(Ontology ontology, IdentifiedElement element, String propertyIri, Literal literalValue, String referencedValueIri) {
        Annotation annotation = OmlWrite.addAnnotation(ontology, element, null, literalValue, null);
        if (referencedValueIri != null) {
            this.setCrossReference(ontology, annotation, OmlPackage.Literals.ANNOTATION__REFERENCED_VALUE, referencedValueIri);
        }
        this.setCrossReference(ontology, annotation, OmlPackage.Literals.ANNOTATION__PROPERTY, propertyIri);
        return annotation;
    }

    public Annotation addAnnotation(Ontology ontology, String memberIri, String propertyIri, Literal literalValue, String referencedValueIri) {
        Annotation annotation = OmlWrite.addAnnotation(ontology, null, null, literalValue, null);
        if (referencedValueIri != null) {
            this.setCrossReference(ontology, annotation, OmlPackage.Literals.ANNOTATION__REFERENCED_VALUE, referencedValueIri);
        }
        this.setCrossReference(ontology, annotation, OmlPackage.Literals.ANNOTATION__PROPERTY, propertyIri);
        this.setContainmentReference(ontology, memberIri, OmlPackage.Literals.IDENTIFIED_ELEMENT__OWNED_ANNOTATIONS, annotation);
        return annotation;
    }

    public Vocabulary createVocabulary(URI resourceURI, String namespace, String prefix) {
        Vocabulary vocabulary = OmlWrite.createVocabulary(namespace, prefix);
        this.addToNewResources(vocabulary, resourceURI);
        return vocabulary;
    }

    public VocabularyBundle createVocabularyBundle(URI resourceURI, String namespace, String prefix) {
        VocabularyBundle bundle = OmlWrite.createVocabularyBundle(namespace, prefix);
        this.addToNewResources(bundle, resourceURI);
        return bundle;
    }

    public Description createDescription(URI resourceURI, String namespace, String prefix) {
        Description description = OmlWrite.createDescription(namespace, prefix);
        this.addToNewResources(description, resourceURI);
        return description;
    }

    public DescriptionBundle createDescriptionBundle(URI resourceURI, String namespace, String prefix) {
        DescriptionBundle bundle = OmlWrite.createDescriptionBundle(namespace, prefix);
        this.addToNewResources(bundle, resourceURI);
        return bundle;
    }

    public Aspect addAspect(Vocabulary vocabulary, String name) {
        Aspect aspect = OmlWrite.addAspect(vocabulary, name);
        return aspect;
    }

    public Concept addConcept(Vocabulary vocabulary, String name) {
        Concept concept = OmlWrite.addConcept(vocabulary, name);
        return concept;
    }

    public RelationEntity addRelationEntity(Vocabulary vocabulary, String name, List<String> sourceIris, List<String> targetIris, boolean functional, boolean inverseFunctional, boolean symmetric, boolean asymmetric, boolean reflexive, boolean irreflexive, boolean transitive) {
        RelationEntity relation = OmlWrite.addRelationEntity(vocabulary, name, Collections.emptyList(), Collections.emptyList(), functional, inverseFunctional, symmetric, asymmetric, reflexive, irreflexive, transitive);
        this.setCrossReferences(vocabulary, relation, OmlPackage.Literals.RELATION_BASE__SOURCES, sourceIris);
        this.setCrossReferences(vocabulary, relation, OmlPackage.Literals.RELATION_BASE__TARGETS, targetIris);
        return relation;
    }

    public Structure addStructure(Vocabulary vocabulary, String name) {
        Structure structure = OmlWrite.addStructure(vocabulary, name);
        return structure;
    }

    public AnnotationProperty addAnnotationProperty(Vocabulary vocabulary, String name) {
        AnnotationProperty property = OmlWrite.addAnnotationProperty(vocabulary, name);
        return property;
    }

    public ScalarProperty addScalarProperty(Vocabulary vocabulary, String name, List<String> domainIris, List<String> rangeIris, boolean functional) {
        ScalarProperty property = OmlWrite.addScalarProperty(vocabulary, name, Collections.emptyList(), Collections.emptyList(), functional);
        this.setCrossReferences(vocabulary, property, OmlPackage.Literals.SCALAR_PROPERTY__DOMAINS, domainIris);
        this.setCrossReferences(vocabulary, property, OmlPackage.Literals.SCALAR_PROPERTY__RANGES, rangeIris);
        return property;
    }

    public StructuredProperty addStructuredProperty(Vocabulary vocabulary, String name, List<String> domainIris, List<String> rangeIris, boolean functional) {
        StructuredProperty property = OmlWrite.addStructuredProperty(vocabulary, name, Collections.emptyList(), Collections.emptyList(), functional);
        this.setCrossReferences(vocabulary, property, OmlPackage.Literals.STRUCTURED_PROPERTY__DOMAINS, domainIris);
        this.setCrossReferences(vocabulary, property, OmlPackage.Literals.STRUCTURED_PROPERTY__RANGES, rangeIris);
        return property;
    }

    public Scalar addScalar(Vocabulary vocabulary, String name) {
        Scalar scalar = OmlWrite.addScalar(vocabulary, name);
        return scalar;
    }

    public ForwardRelation addForwardRelation(RelationEntity entity, String name) {
        ForwardRelation forward = OmlWrite.addForwardRelation(entity, name);
        return forward;
    }

    public ReverseRelation addReverseRelation(RelationBase base, String name) {
        ReverseRelation reverse = OmlWrite.addReverseRelation(base, name);
        return reverse;
    }

    public UnreifiedRelation addUnreifiedRelation(Vocabulary vocabulary, String name, List<String> sourceIris, List<String> targetIris, boolean functional, boolean inverseFunctional, boolean symmetric, boolean asymmetric, boolean reflexive, boolean irreflexive, boolean transitive) {
        UnreifiedRelation relation = OmlWrite.addUnreifiedRelation(vocabulary, name, Collections.emptyList(), Collections.emptyList(), functional, inverseFunctional, symmetric, asymmetric, reflexive, irreflexive, transitive);
        this.setCrossReferences(vocabulary, relation, OmlPackage.Literals.RELATION_BASE__SOURCES, sourceIris);
        this.setCrossReferences(vocabulary, relation, OmlPackage.Literals.RELATION_BASE__TARGETS, targetIris);
        return relation;
    }

    public Rule addRule(Vocabulary vocabulary, String name, Predicate[] consequent, Predicate[] antecedent) {
        Rule rule = OmlWrite.addRule(vocabulary, name, consequent, antecedent);
        return rule;
    }

    public BuiltIn addBuiltIn(Vocabulary vocabulary, String name) {
        BuiltIn builtIn = OmlWrite.addBuiltIn(vocabulary, name);
        return builtIn;
    }

    public StructureInstance createStructureInstance(Ontology ontology, String structureIri) {
        StructureInstance instance = OmlWrite.createStructureInstance(ontology, null);
        this.setCrossReference(ontology, instance, OmlPackage.Literals.STRUCTURE_INSTANCE__TYPE, structureIri);
        return instance;
    }

    public ConceptInstance addConceptInstance(Description description, String name) {
        ConceptInstance instance = OmlWrite.addConceptInstance(description, name);
        return instance;
    }

    public RelationInstance addRelationInstance(Description description, String name, List<String> sourceIris, List<String> targetIris) {
        RelationInstance instance = OmlWrite.addRelationInstance(description, name, Collections.emptyList(), Collections.emptyList());
        this.setCrossReferences(description, instance, OmlPackage.Literals.RELATION_INSTANCE__SOURCES, sourceIris);
        this.setCrossReferences(description, instance, OmlPackage.Literals.RELATION_INSTANCE__TARGETS, targetIris);
        return instance;
    }

    public Import addImport(Ontology ontology, ImportKind kind, String namespace, String prefix) {
        Import import_ = OmlWrite.addImport(ontology, kind, namespace, prefix);
        return import_;
    }

    public SpecializationAxiom addSpecializationAxiom(Vocabulary vocabulary, String subTermIri, String superTermIri) {
        SpecializationAxiom axiom = OmlWrite.addSpecializationAxiom(vocabulary, null, null);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.SPECIALIZATION_AXIOM__SUPER_TERM, superTermIri);
        this.setContainmentReference(vocabulary, subTermIri, OmlPackage.Literals.SPECIALIZABLE_TERM__OWNED_SPECIALIZATIONS, axiom);
        return axiom;
    }

    public ClassifierEquivalenceAxiom addClassifierEquivalenceAxiom(Vocabulary vocabulary, String subClassifierIri, List<String> superClassifierIris) {
        ClassifierEquivalenceAxiom axiom = OmlWrite.addClassifierEquivalenceAxiom(vocabulary, null, Collections.emptyList());
        this.setCrossReferences(vocabulary, axiom, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__SUPER_CLASSIFIERS, superClassifierIris);
        this.setContainmentReference(vocabulary, subClassifierIri, OmlPackage.Literals.CLASSIFIER__OWNED_EQUIVALENCES, axiom);
        return axiom;
    }

    public ScalarEquivalenceAxiom addScalarEquivalenceAxiom(Vocabulary vocabulary, String subScalarIri, String superScalarIri, Long length, Long minLength, Long maxLength, String pattern, String language, Literal minInclusive, Literal minExclusive, Literal maxInclusive, Literal maxExclusive) {
        ScalarEquivalenceAxiom axiom = OmlWrite.addScalarEquivalenceAxiom(vocabulary, null, null, length, minLength, maxLength, pattern, language, minInclusive, minExclusive, maxInclusive, maxExclusive);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.SCALAR_EQUIVALENCE_AXIOM__SUPER_SCALAR, superScalarIri);
        this.setContainmentReference(vocabulary, subScalarIri, OmlPackage.Literals.SCALAR__OWNED_EQUIVALENCES, axiom);
        return axiom;
    }

    public PropertyEquivalenceAxiom addPropertyEquivalenceAxiom(Vocabulary vocabulary, String subPropertyIri, String superPropertyIri) {
        PropertyEquivalenceAxiom axiom = OmlWrite.addPropertyEquivalenceAxiom(vocabulary, null, null);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_EQUIVALENCE_AXIOM__SUPER_PROPERTY, superPropertyIri);
        this.setContainmentReference(vocabulary, subPropertyIri, OmlPackage.Literals.SPECIALIZABLE_PROPERTY__OWNED_EQUIVALENCES, axiom);
        return axiom;
    }

    public PropertyRangeRestrictionAxiom addPropertyRangeRestrictionAxiom(Vocabulary vocabulary, Object owner, String propertyIri, String rangeIri, RangeRestrictionKind restrictionKind) {
        PropertyRangeRestrictionAxiom axiom = OmlWrite.addPropertyRangeRestrictionAxiom(vocabulary, null, null, null, restrictionKind);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, propertyIri);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RANGE_RESTRICTION_AXIOM__RANGE, rangeIri);
        if (owner instanceof String) {
            this.setContainmentReference(vocabulary, (String)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            ((ClassifierEquivalenceAxiom)owner).getOwnedPropertyRestrictions().add((Object)axiom);
        }
        return axiom;
    }

    public PropertyCardinalityRestrictionAxiom addPropertyCardinalityRestrictionAxiom(Vocabulary vocabulary, Object owner, String propertyIri, CardinalityRestrictionKind restrictionKind, long cardinality, String rangeIri) {
        PropertyCardinalityRestrictionAxiom axiom = OmlWrite.addPropertyCardinalityRestrictionAxiom(vocabulary, null, null, restrictionKind, cardinality, null);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, propertyIri);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_CARDINALITY_RESTRICTION_AXIOM__RANGE, rangeIri);
        if (owner instanceof String) {
            this.setContainmentReference(vocabulary, (String)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            ((ClassifierEquivalenceAxiom)owner).getOwnedPropertyRestrictions().add((Object)axiom);
        }
        return axiom;
    }

    public PropertyValueRestrictionAxiom addPropertyValueRestrictionAxiom(Vocabulary vocabulary, Object owner, String propertyIri, Literal literal) {
        PropertyValueRestrictionAxiom axiom = OmlWrite.addPropertyValueRestrictionAxiom(vocabulary, null, null, literal);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, propertyIri);
        if (owner instanceof String) {
            this.setContainmentReference(vocabulary, (String)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            ((ClassifierEquivalenceAxiom)owner).getOwnedPropertyRestrictions().add((Object)axiom);
        }
        return axiom;
    }

    public PropertyValueRestrictionAxiom addPropertyValueRestrictionAxiom(Vocabulary vocabulary, Object owner, String propertyIri, StructureInstance containedValue) {
        PropertyValueRestrictionAxiom axiom = OmlWrite.addPropertyValueRestrictionAxiom(vocabulary, null, null, containedValue);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, propertyIri);
        if (owner instanceof String) {
            this.setContainmentReference(vocabulary, (String)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            ((ClassifierEquivalenceAxiom)owner).getOwnedPropertyRestrictions().add((Object)axiom);
        }
        return axiom;
    }

    public PropertyValueRestrictionAxiom addPropertyValueRestrictionAxiom(Vocabulary vocabulary, Object owner, String relationIri, String referencedValueIri) {
        PropertyValueRestrictionAxiom axiom = OmlWrite.addPropertyValueRestrictionAxiom(vocabulary, null, null, (NamedInstance)null);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_VALUE_RESTRICTION_AXIOM__REFERENCED_VALUE, referencedValueIri);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, relationIri);
        if (owner instanceof String) {
            this.setContainmentReference(vocabulary, (String)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            ((ClassifierEquivalenceAxiom)owner).getOwnedPropertyRestrictions().add((Object)axiom);
        }
        return axiom;
    }

    public PropertySelfRestrictionAxiom addPropertySelfRestrictionAxiom(Vocabulary vocabulary, Object owner, String relationIri) {
        PropertySelfRestrictionAxiom axiom = OmlWrite.addPropertySelfRestrictionAxiom(vocabulary, null, null);
        this.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, relationIri);
        if (owner instanceof String) {
            this.setContainmentReference(vocabulary, (String)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            ((ClassifierEquivalenceAxiom)owner).getOwnedPropertyRestrictions().add((Object)axiom);
        }
        return axiom;
    }

    public KeyAxiom addKeyAxiom(Vocabulary vocabulary, String domainIri, List<String> keyPropertyIris) {
        KeyAxiom axiom = OmlWrite.addKeyAxiom(vocabulary, null, Collections.emptyList());
        this.setCrossReferences(vocabulary, axiom, OmlPackage.Literals.KEY_AXIOM__PROPERTIES, keyPropertyIris);
        this.setContainmentReference(vocabulary, domainIri, OmlPackage.Literals.ENTITY__OWNED_KEYS, axiom);
        return axiom;
    }

    public InstanceEnumerationAxiom addInstanceEnumerationAxiom(Vocabulary vocabulary, String domainIri, List<String> instanceIris) {
        InstanceEnumerationAxiom axiom = OmlWrite.addInstanceEnumerationAxiom(vocabulary, null, Collections.emptyList());
        this.setCrossReferences(vocabulary, axiom, OmlPackage.Literals.INSTANCE_ENUMERATION_AXIOM__INSTANCES, instanceIris);
        this.setContainmentReference(vocabulary, domainIri, OmlPackage.Literals.CONCEPT__OWNED_ENUMERATION, axiom);
        return axiom;
    }

    public LiteralEnumerationAxiom addLiteralEnumerationAxiom(Vocabulary vocabulary, String domainIri, Literal ... literals) {
        LiteralEnumerationAxiom axiom = OmlWrite.addLiteralEnumerationAxiom(vocabulary, null, literals);
        this.setContainmentReference(vocabulary, domainIri, OmlPackage.Literals.SCALAR__OWNED_ENUMERATION, axiom);
        return axiom;
    }

    public TypeAssertion addConceptTypeAssertion(Description description, String instanceIri, String typeIri) {
        TypeAssertion assertion = OmlWrite.addTypeAssertion(description, null, null);
        this.setCrossReference(description, assertion, OmlPackage.Literals.TYPE_ASSERTION__TYPE, typeIri);
        this.setContainmentReference(description, instanceIri, OmlPackage.Literals.NAMED_INSTANCE__OWNED_TYPES, assertion);
        return assertion;
    }

    public PropertyValueAssertion addPropertyValueAssertion(Ontology ontology, String instanceIri, String propertyIri, Literal literalValue) {
        PropertyValueAssertion assertion = OmlWrite.addPropertyValueAssertion(ontology, null, null, literalValue);
        this.setCrossReference(ontology, assertion, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY, propertyIri);
        this.setContainmentReference(ontology, instanceIri, OmlPackage.Literals.INSTANCE__OWNED_PROPERTY_VALUES, assertion);
        return assertion;
    }

    public PropertyValueAssertion addPropertyValueAssertion(Ontology ontology, String instanceIri, String propertyIri, StructureInstance containedValue) {
        PropertyValueAssertion assertion = OmlWrite.addPropertyValueAssertion(ontology, null, null, containedValue);
        this.setCrossReference(ontology, assertion, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY, propertyIri);
        this.setContainmentReference(ontology, instanceIri, OmlPackage.Literals.INSTANCE__OWNED_PROPERTY_VALUES, assertion);
        return assertion;
    }

    public PropertyValueAssertion addPropertyValueAssertion(Ontology ontology, String instanceIri, String propertyIri, String referencedValueIri) {
        PropertyValueAssertion assertion = OmlWrite.addPropertyValueAssertion(ontology, null, null, (NamedInstance)null);
        this.setCrossReference(ontology, assertion, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__REFERENCED_VALUE, referencedValueIri);
        this.setCrossReference(ontology, assertion, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY, propertyIri);
        this.setContainmentReference(ontology, instanceIri, OmlPackage.Literals.INSTANCE__OWNED_PROPERTY_VALUES, assertion);
        return assertion;
    }

    public Argument createArgument(Vocabulary vocabulary, String variable, Literal literal, String instanceIri) {
        Argument argument = OmlWrite.createArgument(vocabulary, variable, literal, null);
        this.setCrossReference(vocabulary, argument, OmlPackage.Literals.ARGUMENT__INSTANCE, instanceIri);
        return argument;
    }

    public TypePredicate createTypePredicate(Vocabulary vocabulary, String typeIri, Argument argument) {
        TypePredicate predicate = OmlWrite.createTypePredicate(vocabulary, null, argument);
        this.setCrossReference(vocabulary, predicate, OmlPackage.Literals.TYPE_PREDICATE__TYPE, typeIri);
        return predicate;
    }

    public RelationEntityPredicate createRelationEntityPredicate(Vocabulary vocabulary, String typeIri, Argument argument1, Argument argument, Argument argument2) {
        RelationEntityPredicate predicate = OmlWrite.createRelationEntityPredicate(vocabulary, null, argument1, argument, argument2);
        this.setCrossReference(vocabulary, predicate, OmlPackage.Literals.RELATION_ENTITY_PREDICATE__TYPE, typeIri);
        return predicate;
    }

    public PropertyPredicate createPropertyPredicate(Vocabulary vocabulary, String propertyIri, Argument argument1, Argument argument2) {
        PropertyPredicate predicate = OmlWrite.createPropertyPredicate(vocabulary, null, argument1, argument2);
        this.setCrossReference(vocabulary, predicate, OmlPackage.Literals.PROPERTY_PREDICATE__PROPERTY, propertyIri);
        return predicate;
    }

    public SameAsPredicate createSameAsPredicate(Vocabulary vocabulary, Argument argument1, Argument argument2) {
        SameAsPredicate predicate = OmlWrite.createSameAsPredicate(vocabulary, argument1, argument2);
        return predicate;
    }

    public DifferentFromPredicate createDifferentFromPredicate(Vocabulary vocabulary, Argument argument1, Argument argument2) {
        DifferentFromPredicate predicate = OmlWrite.createDifferentFromPredicate(vocabulary, argument1, argument2);
        return predicate;
    }

    public BuiltInPredicate createBuiltInPredicate(Vocabulary vocabulary, String builtInIri, Argument ... arguments) {
        BuiltInPredicate predicate = OmlWrite.createBuiltInPredicate(vocabulary, null, arguments);
        this.setCrossReference(vocabulary, predicate, OmlPackage.Literals.BUILT_IN_PREDICATE__BUILT_IN, builtInIri);
        return predicate;
    }

    public QuotedLiteral createQuotedLiteral(Ontology ontology, String value, String typeIri, String langTag) {
        QuotedLiteral literal = OmlWrite.createQuotedLiteral(ontology, value, null, langTag);
        if (typeIri != null) {
            this.setCrossReference(ontology, literal, OmlPackage.Literals.QUOTED_LITERAL__TYPE, typeIri);
        }
        return literal;
    }

    public IntegerLiteral createIntegerLiteral(int value) {
        IntegerLiteral literal = OmlWrite.createIntegerLiteral(value);
        return literal;
    }

    public DecimalLiteral createDecimalLiteral(BigDecimal value) {
        DecimalLiteral literal = OmlWrite.createDecimalLiteral(value);
        return literal;
    }

    public DoubleLiteral createDoubleLiteral(double value) {
        DoubleLiteral literal = OmlWrite.createDoubleLiteral(value);
        return literal;
    }

    public BooleanLiteral createBooleanLiteral(boolean value) {
        BooleanLiteral literal = OmlWrite.createBooleanLiteral(value);
        return literal;
    }
}

