/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.util;

import com.google.common.io.Files;
import io.opencaesar.oml.util.OmlConstants;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogManager;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;

public final class OmlCatalog {
    private static CatalogManager manager = new CatalogManager();
    private CatalogEx catalog;
    private List<String> extensions;
    private List<OmlCatalog> nestedCatalogs;

    private OmlCatalog(CatalogEx catalog, List<String> extensions) {
        this.catalog = catalog;
        this.extensions = extensions;
        this.nestedCatalogs = new ArrayList<OmlCatalog>();
    }

    public static OmlCatalog create(URI catalogUri, List<String> extensions) throws IOException {
        CatalogEx catalog = new CatalogEx(catalogUri.trimSegments(1).toString());
        catalog.setCatalogManager(manager);
        catalog.setupReaders();
        catalog.loadSystemCatalogs();
        catalog.parseCatalog(new URL(catalogUri.toString()));
        OmlCatalog omlCatalog = new OmlCatalog(catalog, extensions);
        for (String path : catalog.getNestedCatalogs()) {
            omlCatalog.nestedCatalogs.add(OmlCatalog.create(URI.createURI((String)path)));
        }
        return omlCatalog;
    }

    public static OmlCatalog create(URI catalogUri) throws IOException {
        return OmlCatalog.create(catalogUri, OmlConstants.OML_EXTENSION_LIST);
    }

    public URI resolveUri(URI uri) throws IOException {
        return URI.createURI((String)this.catalog.resolveUri(uri.toString()));
    }

    public URI deresolveUri(URI path) throws IOException {
        for (CatalogEntry e : this.catalog.getCatalogEntries()) {
            if (e.getEntryType() != Catalog.REWRITE_URI) continue;
            String uriStartString = e.getEntryArg(0);
            String rewriteUri = e.getEntryArg(1);
            int i = path.toString().indexOf(rewriteUri);
            if (i == -1) continue;
            String pathWithNoExt = path.trimFileExtension().toString();
            String deresolved = pathWithNoExt.replace(rewriteUri, uriStartString);
            return URI.createURI((String)deresolved);
        }
        return null;
    }

    public List<URI> getResolvedUris() throws IOException {
        ArrayList<URI> uris = new ArrayList<URI>();
        block0: for (String rewriteUri : this.catalog.getRewriteUris()) {
            File path = new File(CommonPlugin.asLocalURI((URI)URI.createURI((String)rewriteUri)).toFileString());
            if (path.isDirectory()) {
                for (File file : this.getFiles(path, this.extensions)) {
                    String relative = path.toURI().relativize(file.toURI()).getPath();
                    uris.add(URI.createURI((String)(rewriteUri + "/" + relative)));
                }
                continue;
            }
            for (String ext : this.extensions) {
                File file = new File(path.toString() + "." + ext);
                if (!file.exists()) continue;
                uris.add(URI.createURI((String)(rewriteUri + "." + ext)));
                continue block0;
            }
        }
        for (OmlCatalog nestedCatalog : this.nestedCatalogs) {
            uris.addAll(nestedCatalog.getResolvedUris());
        }
        return uris;
    }

    public boolean isResolvedUri(URI uri) {
        for (String rewriteURI : this.catalog.getRewriteUris()) {
            if (!uri.toString().startsWith(rewriteURI.toString())) continue;
            return true;
        }
        return false;
    }

    private Set<File> getFiles(File folder, List<String> fileExtensions) {
        HashSet<File> files = new HashSet<File>();
        for (File file : folder.listFiles()) {
            if (file.isFile()) {
                String ext = Files.getFileExtension((String)file.toString());
                if (!fileExtensions.contains(ext)) continue;
                files.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            files.addAll(this.getFiles(file, fileExtensions));
        }
        return files;
    }

    static {
        manager.setUseStaticCatalog(false);
        manager.setIgnoreMissingProperties(true);
    }

    private static class CatalogEx
    extends Catalog {
        private String baseUri;

        public CatalogEx(String baseUri) {
            this.baseUri = baseUri;
        }

        public String resolveUri(String uri) throws IOException {
            String resolved = this.resolveURI(uri);
            return resolved != null ? CatalogEx.normalize(resolved) : null;
        }

        public List<String> getRewriteUris() {
            ArrayList<String> rewriteUris = new ArrayList<String>();
            for (CatalogEntry e : this.getCatalogEntries()) {
                if (e.getEntryType() != Catalog.REWRITE_URI) continue;
                String uri = CatalogEx.normalize(e.getEntryArg(1));
                if (uri.endsWith("/")) {
                    uri = uri.substring(0, uri.length() - 1);
                }
                rewriteUris.add(uri);
            }
            return rewriteUris;
        }

        public List<CatalogEntry> getCatalogEntries() {
            ArrayList<CatalogEntry> entries = new ArrayList<CatalogEntry>();
            Enumeration en = this.catalogEntries.elements();
            while (en.hasMoreElements()) {
                entries.add((CatalogEntry)en.nextElement());
            }
            return entries;
        }

        public List<String> getNestedCatalogs() {
            ArrayList<String> entries = new ArrayList<String>();
            Enumeration en = this.catalogs.elements();
            while (en.hasMoreElements()) {
                entries.add((String)en.nextElement());
            }
            return entries;
        }

        protected String makeAbsolute(String sysid) {
            sysid = this.fixSlashes(sysid);
            return this.baseUri.toString() + "/" + sysid;
        }

        private static String normalize(String path) {
            java.net.URI uri = java.net.URI.create(path);
            java.net.URI normalized = uri.normalize();
            return path.replaceFirst(uri.getRawPath(), normalized.getRawPath());
        }
    }
}

