/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.util;

import io.opencaesar.oml.Annotation;
import io.opencaesar.oml.AnnotationProperty;
import io.opencaesar.oml.Argument;
import io.opencaesar.oml.Aspect;
import io.opencaesar.oml.BuiltIn;
import io.opencaesar.oml.BuiltInPredicate;
import io.opencaesar.oml.Classifier;
import io.opencaesar.oml.ClassifierEquivalenceAxiom;
import io.opencaesar.oml.Concept;
import io.opencaesar.oml.ConceptInstance;
import io.opencaesar.oml.Entity;
import io.opencaesar.oml.InstanceEnumerationAxiom;
import io.opencaesar.oml.KeyAxiom;
import io.opencaesar.oml.Member;
import io.opencaesar.oml.NamedInstance;
import io.opencaesar.oml.OmlPackage;
import io.opencaesar.oml.Property;
import io.opencaesar.oml.PropertyCardinalityRestrictionAxiom;
import io.opencaesar.oml.PropertyEquivalenceAxiom;
import io.opencaesar.oml.PropertyPredicate;
import io.opencaesar.oml.PropertyRangeRestrictionAxiom;
import io.opencaesar.oml.PropertyRestrictionAxiom;
import io.opencaesar.oml.PropertyValueAssertion;
import io.opencaesar.oml.PropertyValueRestrictionAxiom;
import io.opencaesar.oml.QuotedLiteral;
import io.opencaesar.oml.Relation;
import io.opencaesar.oml.RelationBase;
import io.opencaesar.oml.RelationEntity;
import io.opencaesar.oml.RelationEntityPredicate;
import io.opencaesar.oml.RelationInstance;
import io.opencaesar.oml.Rule;
import io.opencaesar.oml.Scalar;
import io.opencaesar.oml.ScalarEquivalenceAxiom;
import io.opencaesar.oml.ScalarProperty;
import io.opencaesar.oml.SemanticProperty;
import io.opencaesar.oml.SpecializationAxiom;
import io.opencaesar.oml.Structure;
import io.opencaesar.oml.StructureInstance;
import io.opencaesar.oml.StructuredProperty;
import io.opencaesar.oml.Term;
import io.opencaesar.oml.Type;
import io.opencaesar.oml.TypeAssertion;
import io.opencaesar.oml.TypePredicate;
import io.opencaesar.oml.UnreifiedRelation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class OmlIndex {
    static Collection<EStructuralFeature.Setting> findInverseReferencers(EObject object) {
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)object);
        Collection settings = adapter != null ? adapter.getNonNavigableInverseReferences(object) : OmlIndex.searchForNonNavigableInverseReferences(object);
        return settings;
    }

    private static Collection<EStructuralFeature.Setting> searchForNonNavigableInverseReferences(EObject object) {
        Resource resource = object.eResource();
        if (resource != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null) {
                return EcoreUtil.UsageCrossReferencer.find((EObject)object, (ResourceSet)resourceSet);
            }
            return EcoreUtil.UsageCrossReferencer.find((EObject)object, (Resource)resource);
        }
        EObject rootEObject = EcoreUtil.getRootContainer((EObject)object);
        return EcoreUtil.UsageCrossReferencer.find((EObject)object, (EObject)rootEObject);
    }

    private static <T extends EObject> Set<T> findInverseReferencers(EObject object, EReference eReference, Class<T> type) {
        LinkedHashSet<EObject> referencers = new LinkedHashSet<EObject>();
        Collection<EStructuralFeature.Setting> settings = OmlIndex.findInverseReferencers(object);
        for (EStructuralFeature.Setting setting : settings) {
            EObject referencer;
            if (setting.getEStructuralFeature() != eReference || !type.isInstance(referencer = setting.getEObject())) continue;
            referencers.add((EObject)type.cast(referencer));
        }
        return referencers;
    }

    public static Set<Annotation> findAnnotationsWithProperty(AnnotationProperty property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.ANNOTATION__PROPERTY, Annotation.class);
    }

    public static Set<Annotation> findAnnotationsWithReferencedValue(Member value) {
        return OmlIndex.findInverseReferencers(value, OmlPackage.Literals.ANNOTATION__REFERENCED_VALUE, Annotation.class);
    }

    public static Set<InstanceEnumerationAxiom> findInstanceEnumerationAxiomsWithInstance(ConceptInstance instance) {
        return OmlIndex.findInverseReferencers(instance, OmlPackage.Literals.INSTANCE_ENUMERATION_AXIOM__INSTANCES, InstanceEnumerationAxiom.class);
    }

    public static Set<RelationBase> findRelationBasesWithSource(Entity source) {
        return OmlIndex.findInverseReferencers(source, OmlPackage.Literals.RELATION_BASE__SOURCES, RelationBase.class);
    }

    public static Set<RelationBase> findRelationBasesWithTarget(Entity target) {
        return OmlIndex.findInverseReferencers(target, OmlPackage.Literals.RELATION_BASE__TARGETS, RelationBase.class);
    }

    public static Set<ScalarProperty> findScalarPropertiesWithDomain(Classifier domain) {
        return OmlIndex.findInverseReferencers(domain, OmlPackage.Literals.SCALAR_PROPERTY__DOMAINS, ScalarProperty.class);
    }

    public static Set<ScalarProperty> findScalarPropertiesWithRange(Scalar range) {
        return OmlIndex.findInverseReferencers(range, OmlPackage.Literals.SCALAR_PROPERTY__RANGES, ScalarProperty.class);
    }

    public static Set<StructuredProperty> findStructuredPropertiesWithDomain(Classifier domain) {
        return OmlIndex.findInverseReferencers(domain, OmlPackage.Literals.STRUCTURED_PROPERTY__DOMAINS, StructuredProperty.class);
    }

    public static Set<StructuredProperty> findStructuredPropertiesWithRange(Structure range) {
        return OmlIndex.findInverseReferencers(range, OmlPackage.Literals.STRUCTURED_PROPERTY__RANGES, StructuredProperty.class);
    }

    public static Set<StructureInstance> findStructureInstancesWithType(Structure type) {
        return OmlIndex.findInverseReferencers(type, OmlPackage.Literals.STRUCTURE_INSTANCE__TYPE, StructureInstance.class);
    }

    public static Set<RelationInstance> findRelationInstancesWithSource(NamedInstance source) {
        return OmlIndex.findInverseReferencers(source, OmlPackage.Literals.RELATION_INSTANCE__SOURCES, RelationInstance.class);
    }

    public static Set<RelationInstance> findRelationInstancesWithTarget(NamedInstance target) {
        return OmlIndex.findInverseReferencers(target, OmlPackage.Literals.RELATION_INSTANCE__TARGETS, RelationInstance.class);
    }

    public static Set<Aspect> findAspectsWithRef(Aspect aspect) {
        return OmlIndex.findInverseReferencers(aspect, OmlPackage.Literals.ASPECT__REF, Aspect.class);
    }

    public static Set<Concept> findConceptsWithRef(Concept concept) {
        return OmlIndex.findInverseReferencers(concept, OmlPackage.Literals.CONCEPT__REF, Concept.class);
    }

    public static Set<RelationEntity> findRelationEntitiesWithRef(RelationEntity entity) {
        return OmlIndex.findInverseReferencers(entity, OmlPackage.Literals.RELATION_ENTITY__REF, RelationEntity.class);
    }

    public static Set<Structure> findStructuresWithRef(Structure structure) {
        return OmlIndex.findInverseReferencers(structure, OmlPackage.Literals.STRUCTURE__REF, Structure.class);
    }

    public static Set<AnnotationProperty> findAnnotationPropertiesWithRef(AnnotationProperty property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.ANNOTATION_PROPERTY__REF, AnnotationProperty.class);
    }

    public static Set<ScalarProperty> findScalarPropertiesWithRef(ScalarProperty property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.SCALAR_PROPERTY__REF, ScalarProperty.class);
    }

    public static Set<StructuredProperty> findStructuredPropertiesWithRef(StructuredProperty property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.STRUCTURED_PROPERTY__REF, StructuredProperty.class);
    }

    public static Set<Scalar> findScalarsWithRef(Scalar scalar) {
        return OmlIndex.findInverseReferencers(scalar, OmlPackage.Literals.SCALAR__REF, Scalar.class);
    }

    public static Set<UnreifiedRelation> findUnreifiedRelationsWithRef(Relation relation) {
        return OmlIndex.findInverseReferencers(relation, OmlPackage.Literals.UNREIFIED_RELATION__REF, UnreifiedRelation.class);
    }

    public static Set<Rule> findRulesWithRef(Rule rule) {
        return OmlIndex.findInverseReferencers(rule, OmlPackage.Literals.RULE__REF, Rule.class);
    }

    public static Set<BuiltIn> findBuiltInsWithRef(BuiltIn builtIn) {
        return OmlIndex.findInverseReferencers(builtIn, OmlPackage.Literals.BUILT_IN__REF, BuiltIn.class);
    }

    public static Set<ConceptInstance> findConceptInstancesWithRef(ConceptInstance instance) {
        return OmlIndex.findInverseReferencers(instance, OmlPackage.Literals.CONCEPT_INSTANCE__REF, ConceptInstance.class);
    }

    public static Set<RelationInstance> findRelationInstancesWithRef(RelationInstance instance) {
        return OmlIndex.findInverseReferencers(instance, OmlPackage.Literals.RELATION_INSTANCE__REF, RelationInstance.class);
    }

    public static Set<SpecializationAxiom> findSpecializationAxiomsWithSuperTerm(Term term) {
        return OmlIndex.findInverseReferencers(term, OmlPackage.Literals.SPECIALIZATION_AXIOM__SUPER_TERM, SpecializationAxiom.class);
    }

    public static Set<ClassifierEquivalenceAxiom> findClassifierEquivalenceAxiomsWithSuperClassifier(Classifier classifier) {
        return OmlIndex.findInverseReferencers(classifier, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__SUPER_CLASSIFIERS, ClassifierEquivalenceAxiom.class);
    }

    public static Set<ScalarEquivalenceAxiom> findScalarEquivalenceAxiomsWithSuperScalar(Scalar scalar) {
        return OmlIndex.findInverseReferencers(scalar, OmlPackage.Literals.SCALAR_EQUIVALENCE_AXIOM__SUPER_SCALAR, ScalarEquivalenceAxiom.class);
    }

    public static Set<PropertyEquivalenceAxiom> findPropertyEquivalenceAxiomsWithSuperProperty(Property property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.PROPERTY_EQUIVALENCE_AXIOM__SUPER_PROPERTY, PropertyEquivalenceAxiom.class);
    }

    public static Set<PropertyRestrictionAxiom> findPropertyRestrictionAxiomsWithProperty(Property property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, PropertyRestrictionAxiom.class);
    }

    public static Set<PropertyRangeRestrictionAxiom> findPropertyRangeRestrictionAxiomsWithRange(Type range) {
        return OmlIndex.findInverseReferencers(range, OmlPackage.Literals.PROPERTY_RANGE_RESTRICTION_AXIOM__RANGE, PropertyRangeRestrictionAxiom.class);
    }

    public static Set<PropertyCardinalityRestrictionAxiom> findPropertyCardinalityRestrictionAxiomsWithRange(Type range) {
        return OmlIndex.findInverseReferencers(range, OmlPackage.Literals.PROPERTY_CARDINALITY_RESTRICTION_AXIOM__RANGE, PropertyCardinalityRestrictionAxiom.class);
    }

    public static Set<PropertyValueRestrictionAxiom> findPropertyValueRestrictionAxiomsWithReferencedValue(NamedInstance value) {
        return OmlIndex.findInverseReferencers(value, OmlPackage.Literals.PROPERTY_VALUE_RESTRICTION_AXIOM__REFERENCED_VALUE, PropertyValueRestrictionAxiom.class);
    }

    public static Set<KeyAxiom> findKeyAxiomsWithProperty(Property property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.KEY_AXIOM__PROPERTIES, KeyAxiom.class);
    }

    public static Set<TypeAssertion> findTypeAssertionsWithType(Entity type) {
        return OmlIndex.findInverseReferencers(type, OmlPackage.Literals.TYPE_ASSERTION__TYPE, TypeAssertion.class);
    }

    public static Set<PropertyValueAssertion> findPropertyValueAssertionsWithProperty(SemanticProperty property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY, PropertyValueAssertion.class);
    }

    public static Set<PropertyValueAssertion> findPropertyValueAssertionsWithReferencedValue(NamedInstance value) {
        return OmlIndex.findInverseReferencers(value, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__REFERENCED_VALUE, PropertyValueAssertion.class);
    }

    public static Set<TypePredicate> findTypePredicatesWithType(Type type) {
        return OmlIndex.findInverseReferencers(type, OmlPackage.Literals.TYPE_PREDICATE__TYPE, TypePredicate.class);
    }

    public static Set<RelationEntityPredicate> findRelationEntityPredicatesWithType(RelationEntity type) {
        return OmlIndex.findInverseReferencers(type, OmlPackage.Literals.RELATION_ENTITY_PREDICATE__TYPE, RelationEntityPredicate.class);
    }

    public static Set<PropertyPredicate> findPropertyPredicatesWithProperty(Property property) {
        return OmlIndex.findInverseReferencers(property, OmlPackage.Literals.PROPERTY_PREDICATE__PROPERTY, PropertyPredicate.class);
    }

    public static Set<BuiltInPredicate> findBuiltInPredicatesWithBuiltIn(BuiltIn builtIn) {
        return OmlIndex.findInverseReferencers(builtIn, OmlPackage.Literals.BUILT_IN_PREDICATE__BUILT_IN, BuiltInPredicate.class);
    }

    public static Set<QuotedLiteral> findQuotedLiteralsWithType(Scalar type) {
        return OmlIndex.findInverseReferencers(type, OmlPackage.Literals.QUOTED_LITERAL__TYPE, QuotedLiteral.class);
    }

    public static Set<Argument> findArgumentsWithInstance(NamedInstance instance) {
        return OmlIndex.findInverseReferencers(instance, OmlPackage.Literals.ARGUMENT__INSTANCE, Argument.class);
    }
}

