/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.util;

import io.opencaesar.oml.Annotation;
import io.opencaesar.oml.AnnotationProperty;
import io.opencaesar.oml.Assertion;
import io.opencaesar.oml.Axiom;
import io.opencaesar.oml.Classifier;
import io.opencaesar.oml.Description;
import io.opencaesar.oml.Element;
import io.opencaesar.oml.ForwardRelation;
import io.opencaesar.oml.IdentifiedElement;
import io.opencaesar.oml.Import;
import io.opencaesar.oml.Instance;
import io.opencaesar.oml.Literal;
import io.opencaesar.oml.Member;
import io.opencaesar.oml.NamedInstance;
import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.Predicate;
import io.opencaesar.oml.Property;
import io.opencaesar.oml.PropertyPredicate;
import io.opencaesar.oml.QuotedLiteral;
import io.opencaesar.oml.Relation;
import io.opencaesar.oml.RelationBase;
import io.opencaesar.oml.RelationEntity;
import io.opencaesar.oml.RelationEntityPredicate;
import io.opencaesar.oml.ReverseRelation;
import io.opencaesar.oml.Scalar;
import io.opencaesar.oml.ScalarEquivalenceAxiom;
import io.opencaesar.oml.ScalarProperty;
import io.opencaesar.oml.SemanticProperty;
import io.opencaesar.oml.SpecializableProperty;
import io.opencaesar.oml.SpecializableTerm;
import io.opencaesar.oml.Statement;
import io.opencaesar.oml.StructureInstance;
import io.opencaesar.oml.StructuredProperty;
import io.opencaesar.oml.Term;
import io.opencaesar.oml.TypePredicate;
import io.opencaesar.oml.UnreifiedRelation;
import io.opencaesar.oml.Vocabulary;
import io.opencaesar.oml.util.OmlConstants;
import io.opencaesar.oml.util.OmlUriResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class OmlRead {
    public static <T, V extends T> Collection<T> closure(V root, boolean includeRoot, Function<T, Collection<T>> recursive) {
        LinkedHashSet<V> results = new LinkedHashSet<V>();
        if (includeRoot) {
            results.add(root);
        }
        OmlRead.closure(root, results, recursive);
        return results;
    }

    private static <T, V extends T> void closure(V root, Set<T> cache, Function<T, Collection<T>> recursive) {
        Collection<Object> results = recursive.apply(root);
        results = results == null ? Collections.emptyList() : (Collection<Object>)results.stream().filter(r -> r != null).filter(r -> !cache.contains(r)).collect(Collectors.toList());
        cache.addAll(results);
        results.forEach(r -> OmlRead.closure(r, cache, recursive));
    }

    public static <T, V extends T> boolean isInClosure(T item, V root, boolean includeRoot, Function<T, Collection<T>> recursive) {
        LinkedHashSet<V> results = new LinkedHashSet<V>();
        if (includeRoot) {
            results.add(root);
        }
        if (results.contains(item)) {
            return true;
        }
        return OmlRead.isInClosure(item, root, results, recursive);
    }

    private static <T, V extends T> boolean isInClosure(T item, V root, Set<T> cache, Function<T, Collection<T>> recursive) {
        Collection<Object> results = recursive.apply(root);
        results = results == null ? Collections.emptyList() : (Collection<Object>)results.stream().filter(r -> r != null).filter(r -> !cache.contains(r)).collect(Collectors.toList());
        if (results.contains(item)) {
            return true;
        }
        cache.addAll(results);
        for (Object e : results) {
            if (!OmlRead.isInClosure(item, e, cache, recursive)) continue;
            return true;
        }
        return false;
    }

    private static String[] parseIri(String iri) {
        String fragment;
        String baseIri;
        int i = iri.lastIndexOf(35);
        if (i > 0) {
            baseIri = iri.substring(0, i);
        } else {
            i = iri.lastIndexOf(47);
            baseIri = iri.substring(0, i);
        }
        if (i > 0) {
            fragment = iri.substring(i + 1);
        } else {
            i = iri.lastIndexOf(47);
            fragment = iri.substring(i + 1);
        }
        return new String[]{baseIri, fragment};
    }

    private static String[] parseAbbreviatedIri(String iri) {
        String[] parts = iri.split(":");
        String prefix = parts.length > 1 ? parts[0] : "";
        String fragment = parts.length > 1 ? parts[1] : parts[0];
        return new String[]{prefix, fragment};
    }

    public static boolean isResolvedUri(URI uri) {
        if (Arrays.asList(OmlConstants.OML_EXTENSIONS).contains(uri.fileExtension())) {
            return OmlUriResolver.getInstance().isResolvedUri(uri);
        }
        return false;
    }

    public static URI getResolvedUri(Resource context, String iri) {
        if (context == null || iri == null || iri.isEmpty()) {
            return null;
        }
        return OmlUriResolver.getInstance().resolveUri(context, iri);
    }

    public static Set<URI> getResolvedUris(Resource context) {
        if (context == null) {
            return Collections.emptySet();
        }
        return OmlUriResolver.getInstance().getResolvedUris(context);
    }

    public static Ontology getOntology(Resource resource) {
        return resource.getContents().stream().filter(o -> o instanceof Ontology).map(o -> (Ontology)o).findFirst().orElse(null);
    }

    private static Stream<Ontology> getOntologyStream(ResourceSet resourceSet) {
        return resourceSet.getResources().stream().map(r -> OmlRead.getOntology(r)).filter(Objects::nonNull);
    }

    public static List<Ontology> getOntologies(ResourceSet resourceSet) {
        return OmlRead.getOntologyStream(resourceSet).collect(Collectors.toList());
    }

    public static Ontology getOntologyByIri(ResourceSet resourceSet, String iri) {
        return OmlRead.getOntologyStream(resourceSet).filter(o -> iri.equals(o.getIri())).findFirst().orElse(null);
    }

    public static Ontology getOntologyByPrefix(ResourceSet resourceSet, String prefix) {
        return OmlRead.getOntologyStream(resourceSet).filter(o -> prefix.equals(o.getPrefix())).findFirst().orElse(null);
    }

    public static Ontology getOntologyByResolvingIri(Resource context, String iri) {
        URI uri = OmlRead.getResolvedUri(context, iri);
        if (uri == null) {
            return null;
        }
        Resource resource = context.getResourceSet().getResource(uri, true);
        return OmlRead.getOntology(resource);
    }

    public static List<Ontology> getImportedOntologies(Ontology ontology) {
        return ontology.getOwnedImports().stream().map(i -> OmlRead.getImportedOntology(i)).collect(Collectors.toList());
    }

    public static Ontology getImportedOntologyByIri(Ontology ontology, String iri) {
        return ontology.getOwnedImports().stream().filter(i -> iri.equals(i.getIri())).map(i -> OmlRead.getImportedOntology(i)).findFirst().orElse(null);
    }

    public static Ontology getImportedOntologyByPrefix(Ontology ontology, String prefix) {
        return ontology.getOwnedImports().stream().filter(i -> prefix.equals(i.getPrefix())).map(i -> OmlRead.getImportedOntology(i)).findFirst().orElse(null);
    }

    public static Collection<Ontology> getImportedOntologyClosure(Ontology ontology, boolean inclusive) {
        return OmlRead.closure(ontology, inclusive, (T i) -> OmlRead.getImportedOntologies(i));
    }

    public static Collection<Ontology> getImportingOntologies(Ontology ontology) {
        ResourceSet resourceSet = ontology.eResource().getResourceSet();
        return OmlRead.getOntologies(resourceSet).stream().filter(i -> OmlRead.getImportNamespaceToPrefixMap(i).containsKey(ontology.getIri())).collect(Collectors.toSet());
    }

    public static Ontology getImportedOntology(Import _import) {
        if (_import.getIri() == null || _import.getIri().isEmpty()) {
            return null;
        }
        Resource context = _import.eResource();
        URI uri = OmlRead.getResolvedUri(context, _import.getIri());
        if (uri != null) {
            ResourceSet rs = context.getResourceSet();
            Resource r = rs.getResource(uri, false);
            if ((r == null || !r.isLoaded()) && rs.getURIConverter().exists(uri, rs.getLoadOptions())) {
                try {
                    r = rs.getResource(uri, true);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            if (r != null) {
                return OmlRead.getOntology(r);
            }
        }
        return null;
    }

    public static Ontology getImportingOntology(Import _import) {
        return _import.getOwningOntology();
    }

    public static Map<String, String> getImportNamespaceToPrefixMap(Ontology ontology) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ontology.getOwnedImports().stream().filter(i -> i.getPrefix() != null).forEach(i -> map.put(i.getNamespace(), i.getPrefix()));
        return map;
    }

    public static Map<String, String> getImportPrefixToNamespaceMap(Ontology ontology) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ontology.getOwnedImports().stream().filter(i -> i.getPrefix() != null).forEach(i -> map.put(i.getPrefix(), i.getNamespace()));
        return map;
    }

    public static List<Member> getMembers(Ontology ontology) {
        Function<Member, Stream> allMembers = i -> {
            RelationBase base;
            RelationEntity entity;
            Stream<Member> stream = Stream.of(i);
            if (i instanceof RelationEntity && (entity = (RelationEntity)i).getForwardRelation() != null) {
                stream = Stream.concat(stream, Stream.of(entity.getForwardRelation()));
            }
            if (i instanceof RelationBase && (base = (RelationBase)i).getReverseRelation() != null) {
                stream = Stream.concat(stream, Stream.of(base.getReverseRelation()));
            }
            return stream;
        };
        return OmlRead.getStatements(ontology).stream().filter(i -> !i.isRef()).flatMap(i -> (Stream)allMembers.apply((Member)i)).collect(Collectors.toList());
    }

    public static Member getMemberByName(Ontology ontology, String name) {
        EObject obj = ontology.eResource().getEObject(name);
        return obj instanceof Member ? (Member)obj : null;
    }

    public static Member getMemberByIri(Ontology ontology, String iri) {
        String[] iriParts = OmlRead.parseIri(iri);
        String baseIri = iriParts[0];
        String fragment = iriParts[1];
        Ontology baseOntology = ontology.getIri().equals(baseIri) ? ontology : OmlRead.getImportedOntologyByIri(ontology, baseIri);
        return baseOntology != null ? OmlRead.getMemberByName(baseOntology, fragment) : null;
    }

    public static Member getMemberByIri(ResourceSet resourceSet, String iri) {
        String[] iriParts = OmlRead.parseIri(iri);
        String baseIri = iriParts[0];
        String fragment = iriParts[1];
        Ontology baseOntology = OmlRead.getOntologyByIri(resourceSet, baseIri);
        return baseOntology != null ? OmlRead.getMemberByName(baseOntology, fragment) : null;
    }

    public static Member getMemberByAbbreviatedIri(Ontology ontology, String iri) {
        String[] iriParts = OmlRead.parseAbbreviatedIri(iri);
        String prefix = iriParts[0];
        String fragment = iriParts[1];
        Ontology baseOntology = ontology.getPrefix().equals(prefix) ? ontology : OmlRead.getImportedOntologyByPrefix(ontology, prefix);
        return baseOntology != null ? OmlRead.getMemberByName(baseOntology, fragment) : null;
    }

    public static Member getMemberByAbbreviatedIri(ResourceSet resourceSet, String iri) {
        String[] iriParts = OmlRead.parseAbbreviatedIri(iri);
        String prefix = iriParts[0];
        String fragment = iriParts[1];
        Ontology baseOntology = OmlRead.getOntologyByPrefix(resourceSet, prefix);
        return baseOntology != null ? OmlRead.getMemberByName(baseOntology, fragment) : null;
    }

    public static Member getMemberByResolvingIri(Resource context, String iri) {
        String[] iriParts = OmlRead.parseIri(iri);
        String baseIri = iriParts[0];
        String fragment = iriParts[1];
        Ontology baseOntology = OmlRead.getOntologyByResolvingIri(context, baseIri);
        return baseOntology != null ? OmlRead.getMemberByName(baseOntology, fragment) : null;
    }

    public static String getPrefixIn(Ontology ontology, Ontology context) {
        if (ontology == context) {
            return context.getPrefix();
        }
        return OmlRead.getImportNamespaceToPrefixMap(context).get(ontology.getNamespace());
    }

    public static String getAbbreviatedIriIn(Member member, Ontology context) {
        Ontology ontology = member.getOntology();
        if (ontology == context) {
            return member.getName();
        }
        String prefix = OmlRead.getPrefixIn(ontology, context);
        return prefix != null ? prefix + ":" + member.getName() : null;
    }

    public static List<Statement> getStatements(Ontology ontology) {
        if (ontology instanceof Vocabulary) {
            return ((Vocabulary)ontology).getOwnedStatements().stream().map(i -> i).collect(Collectors.toList());
        }
        if (ontology instanceof Description) {
            return ((Description)ontology).getOwnedStatements().stream().map(i -> i).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<Member> getRefs(Ontology ontology) {
        return OmlRead.getStatements(ontology).stream().filter(s -> s.isRef()).collect(Collectors.toList());
    }

    private static Stream<Annotation> getAnnotations(IdentifiedElement element, AnnotationProperty property) {
        return element.getOwnedAnnotations().stream().filter(a -> a.getProperty() == property);
    }

    public static List<Element> getAnnotationValues(IdentifiedElement element, AnnotationProperty property) {
        return OmlRead.getAnnotations(element, property).map(a -> a.getValue()).collect(Collectors.toList());
    }

    public static Literal getAnnotationLiteralValue(IdentifiedElement element, AnnotationProperty property) {
        return OmlRead.getAnnotations(element, property).filter(a -> a.getLiteralValue() != null).map(a -> a.getLiteralValue()).findFirst().orElse(null);
    }

    public static Member getAnnotationReferencedValue(IdentifiedElement element, AnnotationProperty property) {
        return OmlRead.getAnnotations(element, property).filter(a -> a.getReferencedValue() != null).map(a -> a.getReferencedValue()).findFirst().orElse(null);
    }

    public static List<Term> getSuperTerms(Term term) {
        ArrayList<Term> supers = new ArrayList<Term>();
        supers.addAll(OmlRead.getSpecializationSuperTerms(term));
        if (term instanceof Classifier) {
            supers.addAll(OmlRead.getEquivalenceSuperClassifiers((Classifier)term));
        } else if (term instanceof Scalar) {
            supers.addAll(OmlRead.getEquivalenceSuperScalars((Scalar)term));
        } else if (term instanceof Property) {
            supers.addAll(OmlRead.getEquivalenceSuperProperties((Property)term));
        }
        return supers;
    }

    public static List<Term> getSpecializationSuperTerms(Term term) {
        ArrayList<Term> supers = new ArrayList<Term>();
        if (term instanceof SpecializableTerm) {
            supers.addAll(((SpecializableTerm)term).getOwnedSpecializations().stream().filter(i -> i.getSuperTerm() != null).map(i -> i.getSuperTerm()).collect(Collectors.toList()));
        } else if (term instanceof ForwardRelation) {
            RelationEntity entity = ((ForwardRelation)term).getRelationEntity();
            supers.addAll(OmlRead.getSpecializationSuperTerms(entity).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getForwardRelation() != null).map(i -> i.getForwardRelation()).collect(Collectors.toList()));
        } else if (term instanceof ReverseRelation) {
            RelationBase base = ((ReverseRelation)term).getRelationBase();
            supers.addAll(OmlRead.getSpecializationSuperTerms(base).stream().filter(i -> i instanceof RelationBase).map(i -> (RelationBase)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toList()));
        }
        return supers;
    }

    public static List<Classifier> getEquivalenceSuperClassifiers(Classifier classifier) {
        return classifier.getOwnedEquivalences().stream().flatMap(i -> i.getSuperClassifiers().stream()).collect(Collectors.toList());
    }

    public static List<Scalar> getEquivalenceSuperScalars(Scalar scalar) {
        return scalar.getOwnedEquivalences().stream().map(i -> i.getSuperScalar()).collect(Collectors.toList());
    }

    public static List<Property> getEquivalenceSuperProperties(Property property) {
        ArrayList<Property> supers = new ArrayList<Property>();
        if (property instanceof SpecializableProperty) {
            supers.addAll(((SpecializableProperty)property).getOwnedEquivalences().stream().map(i -> i.getSuperProperty()).collect(Collectors.toList()));
        } else if (property instanceof ForwardRelation) {
            RelationEntity entity = ((ForwardRelation)property).getRelationEntity();
            supers.addAll(OmlRead.getEquivalenceSuperClassifiers(entity).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getForwardRelation() != null).map(i -> i.getForwardRelation()).collect(Collectors.toList()));
        } else if (property instanceof ReverseRelation) {
            RelationBase base = ((ReverseRelation)property).getRelationBase();
            if (base instanceof RelationEntity) {
                supers.addAll(OmlRead.getEquivalenceSuperClassifiers((RelationEntity)base).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toList()));
            } else if (base instanceof UnreifiedRelation) {
                supers.addAll(OmlRead.getEquivalenceSuperProperties((UnreifiedRelation)base).stream().filter(i -> i instanceof UnreifiedRelation).map(i -> (UnreifiedRelation)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toList()));
            }
        }
        return supers;
    }

    public static List<Axiom> getAxioms(SpecializableTerm term) {
        ArrayList<Axiom> axioms = new ArrayList<Axiom>();
        for (EObject object : term.eContents()) {
            if (!(object instanceof Axiom)) continue;
            axioms.add((Axiom)object);
        }
        return axioms;
    }

    public static int getNumberOfFacets(ScalarEquivalenceAxiom axiom) {
        int number = 0;
        if (axiom.getLanguage() != null) {
            ++number;
        }
        if (axiom.getPattern() != null) {
            ++number;
        }
        if (axiom.getLength() != null) {
            ++number;
        }
        if (axiom.getMaxLength() != null) {
            ++number;
        }
        if (axiom.getMinLength() != null) {
            ++number;
        }
        if (axiom.getMaxExclusive() != null) {
            ++number;
        }
        if (axiom.getMaxInclusive() != null) {
            ++number;
        }
        if (axiom.getMinExclusive() != null) {
            ++number;
        }
        if (axiom.getMinInclusive() != null) {
            ++number;
        }
        return number;
    }

    public static Term getTerm(Predicate predicate) {
        if (predicate instanceof TypePredicate) {
            return ((TypePredicate)predicate).getType();
        }
        if (predicate instanceof RelationEntityPredicate) {
            return ((RelationEntityPredicate)predicate).getType();
        }
        if (predicate instanceof PropertyPredicate) {
            return ((PropertyPredicate)predicate).getProperty();
        }
        return null;
    }

    public static boolean isStandardScalar(Scalar scalar) {
        Ontology ontology = scalar.getOntology();
        if (ontology != null) {
            String ontologyNs = ontology.getNamespace();
            return ontologyNs.equals("http://www.w3.org/2001/XMLSchema#") || ontologyNs.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") || ontologyNs.equals("http://www.w3.org/2000/01/rdf-schema#") || ontologyNs.equals("http://www.w3.org/2002/07/owl#");
        }
        return false;
    }

    public static List<Assertion> getAssertions(Instance instance) {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (instance instanceof NamedInstance) {
            assertions.addAll((Collection<Assertion>)((NamedInstance)instance).getOwnedTypes());
        }
        assertions.addAll((Collection<Assertion>)instance.getOwnedPropertyValues());
        return assertions;
    }

    public static List<Element> getPropertyValues(Instance instance, SemanticProperty property) {
        return instance.getOwnedPropertyValues().stream().filter(a -> a.getProperty() == property).map(a -> a.getValue()).collect(Collectors.toList());
    }

    public static Literal getPropertyLiteralValue(Instance instance, ScalarProperty property) {
        return OmlRead.getPropertyValues(instance, property).stream().filter(i -> i instanceof Literal).map(i -> (Literal)i).findFirst().orElse(null);
    }

    public static StructureInstance getPropertyContainedValue(Instance instance, StructuredProperty property) {
        return OmlRead.getPropertyValues(instance, property).stream().filter(i -> i instanceof StructureInstance).map(i -> (StructureInstance)i).findFirst().orElse(null);
    }

    public static NamedInstance getPropertyReferencedValue(Instance instance, Relation relation) {
        return OmlRead.getPropertyValues(instance, relation).stream().filter(i -> i instanceof NamedInstance).map(i -> (NamedInstance)i).findFirst().orElse(null);
    }

    public static List<Classifier> getTypes(Instance instance) {
        ArrayList<Classifier> types = new ArrayList<Classifier>();
        if (instance instanceof StructureInstance) {
            types.add(((StructureInstance)instance).getType());
        } else if (instance instanceof NamedInstance) {
            types.addAll(((NamedInstance)instance).getOwnedTypes().stream().map(i -> i.getType()).collect(Collectors.toList()));
        }
        return types;
    }

    public static Scalar getType(Literal literal) {
        String iri = literal.getTypeIri();
        return (Scalar)OmlRead.getMemberByIri(literal.eResource().getResourceSet(), iri);
    }

    public static boolean isEqual(Literal literal1, Literal literal2) {
        if (literal1 == literal2) {
            return true;
        }
        if (literal1 == null || literal2 == null) {
            return false;
        }
        String s1 = literal1.getStringValue() + "_" + literal1.getTypeIri() + "_" + (literal1 instanceof QuotedLiteral ? ((QuotedLiteral)literal1).getLangTag() : "");
        String s2 = literal2.getStringValue() + "_" + literal2.getTypeIri() + "_" + (literal2 instanceof QuotedLiteral ? ((QuotedLiteral)literal2).getLangTag() : "");
        return s1.equals(s2);
    }
}

