/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.util;

import io.opencaesar.oml.Annotation;
import io.opencaesar.oml.AnnotationProperty;
import io.opencaesar.oml.Aspect;
import io.opencaesar.oml.Assertion;
import io.opencaesar.oml.Axiom;
import io.opencaesar.oml.Classifier;
import io.opencaesar.oml.ClassifierEquivalenceAxiom;
import io.opencaesar.oml.Concept;
import io.opencaesar.oml.ConceptInstance;
import io.opencaesar.oml.Element;
import io.opencaesar.oml.Entity;
import io.opencaesar.oml.ForwardRelation;
import io.opencaesar.oml.IdentifiedElement;
import io.opencaesar.oml.Instance;
import io.opencaesar.oml.InstanceEnumerationAxiom;
import io.opencaesar.oml.KeyAxiom;
import io.opencaesar.oml.Literal;
import io.opencaesar.oml.LiteralEnumerationAxiom;
import io.opencaesar.oml.Member;
import io.opencaesar.oml.NamedInstance;
import io.opencaesar.oml.Property;
import io.opencaesar.oml.PropertyEquivalenceAxiom;
import io.opencaesar.oml.PropertyRestrictionAxiom;
import io.opencaesar.oml.PropertyValueAssertion;
import io.opencaesar.oml.QuotedLiteral;
import io.opencaesar.oml.Relation;
import io.opencaesar.oml.RelationBase;
import io.opencaesar.oml.RelationEntity;
import io.opencaesar.oml.RelationInstance;
import io.opencaesar.oml.ReverseRelation;
import io.opencaesar.oml.Rule;
import io.opencaesar.oml.Scalar;
import io.opencaesar.oml.ScalarEquivalenceAxiom;
import io.opencaesar.oml.ScalarProperty;
import io.opencaesar.oml.SemanticProperty;
import io.opencaesar.oml.SpecializableProperty;
import io.opencaesar.oml.SpecializableTerm;
import io.opencaesar.oml.SpecializationAxiom;
import io.opencaesar.oml.Structure;
import io.opencaesar.oml.StructureInstance;
import io.opencaesar.oml.StructuredProperty;
import io.opencaesar.oml.Term;
import io.opencaesar.oml.Type;
import io.opencaesar.oml.TypeAssertion;
import io.opencaesar.oml.UnreifiedRelation;
import io.opencaesar.oml.util.OmlIndex;
import io.opencaesar.oml.util.OmlRead;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class OmlSearch
extends OmlIndex {
    public static Set<Member> findRefs(Member member) {
        LinkedHashSet<Member> refs = new LinkedHashSet<Member>();
        if (member instanceof AnnotationProperty) {
            refs.addAll(OmlSearch.findAnnotationPropertiesWithRef((AnnotationProperty)member));
        } else if (member instanceof Aspect) {
            refs.addAll(OmlSearch.findAspectsWithRef((Aspect)member));
        } else if (member instanceof Concept) {
            refs.addAll(OmlSearch.findConceptsWithRef((Concept)member));
        } else if (member instanceof RelationEntity) {
            refs.addAll(OmlSearch.findRelationEntitiesWithRef((RelationEntity)member));
        } else if (member instanceof Structure) {
            refs.addAll(OmlSearch.findStructuresWithRef((Structure)member));
        } else if (member instanceof Scalar) {
            refs.addAll(OmlSearch.findScalarsWithRef((Scalar)member));
        } else if (member instanceof Relation) {
            refs.addAll(OmlSearch.findUnreifiedRelationsWithRef((Relation)member));
        } else if (member instanceof StructuredProperty) {
            refs.addAll(OmlSearch.findStructuredPropertiesWithRef((StructuredProperty)member));
        } else if (member instanceof ScalarProperty) {
            refs.addAll(OmlSearch.findScalarPropertiesWithRef((ScalarProperty)member));
        } else if (member instanceof Rule) {
            refs.addAll(OmlSearch.findRulesWithRef((Rule)member));
        } else if (member instanceof ConceptInstance) {
            refs.addAll(OmlSearch.findConceptInstancesWithRef((ConceptInstance)member));
        } else if (member instanceof RelationInstance) {
            refs.addAll(OmlSearch.findRelationInstancesWithRef((RelationInstance)member));
        }
        return refs;
    }

    private static Stream<Annotation> findAnnotations(IdentifiedElement element, AnnotationProperty property) {
        LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>((Collection<Annotation>)element.getOwnedAnnotations());
        if (element instanceof Member) {
            Member member = (Member)element;
            annotations.addAll(OmlSearch.findRefs(member).stream().flatMap(r -> r.getOwnedAnnotations().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return annotations.stream().filter(a -> a.getProperty() == property);
    }

    public static Set<Element> findAnnotationValues(IdentifiedElement element, AnnotationProperty property) {
        return OmlSearch.findAnnotations(element, property).map(a -> a.getValue()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Literal findAnnotationLiteralValue(IdentifiedElement element, AnnotationProperty property) {
        return OmlSearch.findAnnotations(element, property).filter(a -> a.getLiteralValue() != null).map(a -> a.getLiteralValue()).findFirst().orElse(null);
    }

    public static Member findAnnotationReferencedValue(IdentifiedElement element, AnnotationProperty property) {
        return OmlSearch.findAnnotations(element, property).filter(a -> a.getReferencedValue() != null).map(a -> a.getReferencedValue()).findFirst().orElse(null);
    }

    public static Set<Axiom> findAxioms(Term term) {
        LinkedHashSet<Axiom> axioms = new LinkedHashSet<Axiom>();
        if (term instanceof SpecializableTerm) {
            axioms.addAll(OmlSearch.findSpecializationAxiomsWithSubTerm((SpecializableTerm)term));
        }
        if (term instanceof Classifier) {
            axioms.addAll(OmlSearch.findClassifierEquivalenceAxiomsWithSubClassifier((Classifier)term));
            axioms.addAll(OmlSearch.findPropertyRestrictionAxioms((Classifier)term));
        }
        if (term instanceof Entity) {
            axioms.addAll(OmlSearch.findKeyAxioms((Entity)term));
        }
        if (term instanceof Concept) {
            axioms.addAll(OmlSearch.findInstanceEnumerationAxioms((Concept)term));
        }
        if (term instanceof Scalar) {
            axioms.addAll(OmlSearch.findScalarEquivalenceAxiomsWithSubScalar((Scalar)term));
            axioms.addAll(OmlSearch.findLiteralEnumerationAxioms((Scalar)term));
        }
        if (term instanceof Property) {
            axioms.addAll(OmlSearch.findPropertyEquivalenceAxiomsWithSubProperty((Property)term));
        }
        return axioms;
    }

    public static Set<KeyAxiom> findKeyAxioms(Entity entity) {
        LinkedHashSet<KeyAxiom> axioms = new LinkedHashSet<KeyAxiom>();
        axioms.addAll((Collection<KeyAxiom>)entity.getOwnedKeys());
        axioms.addAll(OmlSearch.findRefs(entity).stream().filter(i -> i instanceof Entity).map(i -> (Entity)i).flatMap(r -> r.getOwnedKeys().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return axioms;
    }

    public static Set<InstanceEnumerationAxiom> findInstanceEnumerationAxioms(Concept concept) {
        LinkedHashSet<InstanceEnumerationAxiom> axioms = new LinkedHashSet<InstanceEnumerationAxiom>();
        if (concept.getOwnedEnumeration() != null) {
            axioms.add(concept.getOwnedEnumeration());
        }
        axioms.addAll(OmlSearch.findRefs(concept).stream().filter(i -> i instanceof Concept).map(i -> (Concept)i).filter(i -> i.getOwnedEnumeration() != null).map(i -> i.getOwnedEnumeration()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return axioms;
    }

    public static Set<LiteralEnumerationAxiom> findLiteralEnumerationAxioms(Scalar scalar) {
        LinkedHashSet<LiteralEnumerationAxiom> axioms = new LinkedHashSet<LiteralEnumerationAxiom>();
        if (scalar.getOwnedEnumeration() != null) {
            axioms.add(scalar.getOwnedEnumeration());
        }
        axioms.addAll(OmlSearch.findRefs(scalar).stream().filter(i -> i instanceof Scalar).map(i -> (Scalar)i).filter(i -> i.getOwnedEnumeration() != null).map(i -> i.getOwnedEnumeration()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return axioms;
    }

    public static Set<PropertyRestrictionAxiom> findPropertyRestrictionAxioms(Classifier classifier) {
        LinkedHashSet<PropertyRestrictionAxiom> axioms = new LinkedHashSet<PropertyRestrictionAxiom>();
        axioms.addAll((Collection<PropertyRestrictionAxiom>)classifier.getOwnedPropertyRestrictions());
        axioms.addAll(OmlSearch.findRefs(classifier).stream().filter(i -> i instanceof Classifier).map(i -> (Classifier)i).flatMap(r -> r.getOwnedPropertyRestrictions().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return axioms;
    }

    public static Set<SpecializationAxiom> findSpecializationAxiomsWithSubTerm(Term term) {
        LinkedHashSet<SpecializationAxiom> axioms = new LinkedHashSet<SpecializationAxiom>();
        if (term instanceof SpecializableTerm) {
            axioms.addAll((Collection<SpecializationAxiom>)((SpecializableTerm)term).getOwnedSpecializations());
        }
        axioms.addAll(OmlSearch.findRefs(term).stream().filter(i -> i instanceof SpecializableTerm).map(i -> (SpecializableTerm)i).flatMap(r -> r.getOwnedSpecializations().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return axioms;
    }

    public static Set<ClassifierEquivalenceAxiom> findClassifierEquivalenceAxiomsWithSubClassifier(Classifier classifier) {
        LinkedHashSet<ClassifierEquivalenceAxiom> axioms = new LinkedHashSet<ClassifierEquivalenceAxiom>();
        axioms.addAll((Collection<ClassifierEquivalenceAxiom>)classifier.getOwnedEquivalences());
        axioms.addAll(OmlSearch.findRefs(classifier).stream().filter(i -> i instanceof Classifier).map(i -> (Classifier)i).flatMap(r -> r.getOwnedEquivalences().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return axioms;
    }

    public static Set<ScalarEquivalenceAxiom> findScalarEquivalenceAxiomsWithSubScalar(Scalar scalar) {
        LinkedHashSet<ScalarEquivalenceAxiom> axioms = new LinkedHashSet<ScalarEquivalenceAxiom>();
        axioms.addAll((Collection<ScalarEquivalenceAxiom>)scalar.getOwnedEquivalences());
        axioms.addAll(OmlSearch.findRefs(scalar).stream().filter(i -> i instanceof Scalar).map(i -> (Scalar)i).flatMap(r -> r.getOwnedEquivalences().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return axioms;
    }

    public static Set<PropertyEquivalenceAxiom> findPropertyEquivalenceAxiomsWithSubProperty(Property property) {
        LinkedHashSet<PropertyEquivalenceAxiom> axioms = new LinkedHashSet<PropertyEquivalenceAxiom>();
        if (property instanceof SpecializableProperty) {
            axioms.addAll((Collection<PropertyEquivalenceAxiom>)((SpecializableProperty)property).getOwnedEquivalences());
        }
        axioms.addAll(OmlSearch.findRefs(property).stream().filter(i -> i instanceof SpecializableProperty).map(i -> (SpecializableProperty)i).flatMap(r -> r.getOwnedEquivalences().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return axioms;
    }

    public static Set<Term> findSuperTerms(Term term) {
        LinkedHashSet<Term> supers = new LinkedHashSet<Term>();
        supers.addAll(OmlSearch.findSpecializationSuperTerms(term));
        if (term instanceof Classifier) {
            supers.addAll(OmlSearch.findEquivalenceSuperClassifiers((Classifier)term));
            supers.addAll(OmlSearch.findEquivalentClassifiers((Classifier)term));
        } else if (term instanceof Scalar) {
            supers.addAll(OmlSearch.findEquivalenceSuperScalars((Scalar)term));
            supers.addAll(OmlSearch.findEquivalentScalars((Scalar)term));
        } else if (term instanceof Property) {
            supers.addAll(OmlSearch.findEquivalentProperties((Property)term));
        }
        return supers;
    }

    public static Set<Term> findSubTerms(Term term) {
        LinkedHashSet<Term> subs = new LinkedHashSet<Term>();
        subs.addAll(OmlSearch.findSpecializationSubTerms(term));
        if (term instanceof Classifier) {
            subs.addAll(OmlSearch.findEquivalenceSubClassifiers((Classifier)term));
            subs.addAll(OmlSearch.findEquivalentClassifiers((Classifier)term));
        } else if (term instanceof Scalar) {
            subs.addAll(OmlSearch.findEquivalenceSubScalars((Scalar)term));
            subs.addAll(OmlSearch.findEquivalentScalars((Scalar)term));
        } else if (term instanceof Property) {
            subs.addAll(OmlSearch.findEquivalentProperties((Property)term));
        }
        return subs;
    }

    public static Set<Term> findAllSuperTerms(Term term, boolean inclusive) {
        return OmlRead.closure(term, inclusive, t -> OmlSearch.findSuperTerms(t)).stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Term> findAllSubTerms(Term term, boolean inclusive) {
        return OmlRead.closure(term, inclusive, t -> OmlSearch.findSubTerms(t)).stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static boolean findIsSubTermOf(Term term, Term superTerm) {
        return OmlRead.isInClosure(superTerm, term, true, t -> OmlSearch.findSuperTerms(t));
    }

    public static Set<Term> findSpecializationSuperTerms(Term term) {
        LinkedHashSet<Term> supers = new LinkedHashSet<Term>();
        supers.addAll(OmlSearch.findSpecializationAxiomsWithSubTerm(term).stream().map(i -> i.getSuperTerm()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (term instanceof ForwardRelation) {
            RelationEntity entity = ((ForwardRelation)term).getRelationEntity();
            supers.addAll(OmlSearch.findSpecializationSuperTerms(entity).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getForwardRelation() != null).map(i -> i.getForwardRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        } else if (term instanceof ReverseRelation) {
            RelationBase base = ((ReverseRelation)term).getRelationBase();
            supers.addAll(OmlSearch.findSpecializationSuperTerms(base).stream().filter(i -> i instanceof RelationBase).map(i -> (RelationBase)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return supers;
    }

    public static Set<Term> findSpecializationSubTerms(Term term) {
        LinkedHashSet<Term> subs = new LinkedHashSet<Term>();
        subs.addAll(OmlSearch.findSpecializationAxiomsWithSuperTerm(term).stream().map(i -> i.getSubTerm()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (term instanceof ForwardRelation) {
            RelationEntity entity = ((ForwardRelation)term).getRelationEntity();
            subs.addAll(OmlSearch.findSpecializationSubTerms(entity).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getForwardRelation() != null).map(i -> i.getForwardRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        } else if (term instanceof ReverseRelation) {
            RelationBase base = ((ReverseRelation)term).getRelationBase();
            subs.addAll(OmlSearch.findSpecializationSubTerms(base).stream().filter(i -> i instanceof RelationBase).map(i -> (RelationBase)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return subs;
    }

    public static Set<Classifier> findEquivalenceSuperClassifiers(Classifier classifier) {
        return OmlSearch.findClassifierEquivalenceAxiomsWithSubClassifier(classifier).stream().flatMap(i -> i.getSuperClassifiers().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Classifier> findEquivalenceSubClassifiers(Classifier classifier) {
        return OmlSearch.findClassifierEquivalenceAxiomsWithSuperClassifier(classifier).stream().map(i -> i.getSubClassifier()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Scalar> findEquivalenceSuperScalars(Scalar scalar) {
        return OmlSearch.findScalarEquivalenceAxiomsWithSubScalar(scalar).stream().map(i -> i.getSuperScalar()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Scalar> findEquivalenceSubScalars(Scalar scalar) {
        return OmlSearch.findScalarEquivalenceAxiomsWithSuperScalar(scalar).stream().map(i -> i.getSubScalar()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Property> findEquivalenceSuperProperties(Property property) {
        LinkedHashSet<Property> supers = new LinkedHashSet<Property>();
        supers.addAll(OmlSearch.findPropertyEquivalenceAxiomsWithSubProperty(property).stream().map(i -> i.getSuperProperty()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (property instanceof ForwardRelation) {
            RelationEntity entity = ((ForwardRelation)property).getRelationEntity();
            supers.addAll(OmlSearch.findEquivalenceSuperClassifiers(entity).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getForwardRelation() != null).map(i -> i.getForwardRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        } else if (property instanceof ReverseRelation) {
            RelationBase base = ((ReverseRelation)property).getRelationBase();
            if (base instanceof RelationEntity) {
                supers.addAll(OmlSearch.findEquivalenceSuperClassifiers((RelationEntity)base).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
            } else if (base instanceof UnreifiedRelation) {
                supers.addAll(OmlSearch.findEquivalenceSuperProperties((UnreifiedRelation)base).stream().filter(i -> i instanceof UnreifiedRelation).map(i -> (UnreifiedRelation)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
        }
        return supers;
    }

    public static Set<Property> findEquivalenceSubProperties(Property property) {
        LinkedHashSet<Property> subs = new LinkedHashSet<Property>();
        subs.addAll(OmlSearch.findPropertyEquivalenceAxiomsWithSuperProperty(property).stream().map(i -> i.getSubProperty()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (property instanceof ForwardRelation) {
            RelationEntity entity = ((ForwardRelation)property).getRelationEntity();
            subs.addAll(OmlSearch.findEquivalenceSubClassifiers(entity).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getForwardRelation() != null).map(i -> i.getForwardRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        } else if (property instanceof ReverseRelation) {
            RelationBase base = ((ReverseRelation)property).getRelationBase();
            if (base instanceof RelationEntity) {
                subs.addAll(OmlSearch.findEquivalenceSubClassifiers((RelationEntity)base).stream().filter(i -> i instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
            } else if (base instanceof UnreifiedRelation) {
                subs.addAll(OmlSearch.findEquivalenceSubProperties((UnreifiedRelation)base).stream().filter(i -> i instanceof UnreifiedRelation).map(i -> (UnreifiedRelation)i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
        }
        return subs;
    }

    public static Set<Classifier> findEquivalentClassifiers(Classifier classifier) {
        LinkedHashSet<Classifier> equivalents = new LinkedHashSet<Classifier>();
        equivalents.addAll(OmlSearch.findClassifierEquivalenceAxiomsWithSubClassifier(classifier).stream().filter(i -> i.getOwnedPropertyRestrictions().size() == 0).filter(i -> i.getSuperClassifiers().size() == 1).map(i -> (Classifier)i.getSuperClassifiers().get(0)).collect(Collectors.toCollection(LinkedHashSet::new)));
        equivalents.addAll(OmlSearch.findClassifierEquivalenceAxiomsWithSuperClassifier(classifier).stream().filter(i -> i.getOwnedPropertyRestrictions().size() == 0).filter(i -> i.getSuperClassifiers().size() == 1).map(i -> i.getSubClassifier()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return equivalents;
    }

    public static Set<Scalar> findEquivalentScalars(Scalar scalar) {
        LinkedHashSet<Scalar> equivalents = new LinkedHashSet<Scalar>();
        equivalents.addAll(OmlSearch.findScalarEquivalenceAxiomsWithSubScalar(scalar).stream().filter(i -> OmlRead.getNumberOfFacets(i) == 0).map(i -> i.getSuperScalar()).collect(Collectors.toCollection(LinkedHashSet::new)));
        equivalents.addAll(OmlSearch.findScalarEquivalenceAxiomsWithSuperScalar(scalar).stream().filter(i -> OmlRead.getNumberOfFacets(i) == 0).map(i -> i.getSubScalar()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return equivalents;
    }

    public static Set<Property> findEquivalentProperties(Property property) {
        LinkedHashSet<Property> equivalents = new LinkedHashSet<Property>();
        equivalents.addAll(OmlSearch.findEquivalenceSuperProperties(property));
        equivalents.addAll(OmlSearch.findEquivalenceSubProperties(property));
        return equivalents;
    }

    public static Set<Relation> findSourceRelations(Entity entity) {
        LinkedHashSet<Relation> relations = new LinkedHashSet<Relation>();
        relations.addAll(OmlSearch.findRelationBasesWithSource(entity).stream().filter(r -> r instanceof UnreifiedRelation).map(r -> (UnreifiedRelation)r).filter(r -> r != null).collect(Collectors.toCollection(LinkedHashSet::new)));
        relations.addAll(OmlSearch.findRelationBasesWithSource(entity).stream().filter(r -> r instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getForwardRelation() != null).map(i -> i.getForwardRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        relations.addAll(OmlSearch.findRelationBasesWithTarget(entity).stream().map(i -> i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return relations;
    }

    public static Set<Relation> findTargetRelations(Entity entity) {
        LinkedHashSet<Relation> relations = new LinkedHashSet<Relation>();
        relations.addAll(OmlSearch.findRelationBasesWithTarget(entity).stream().filter(r -> r instanceof UnreifiedRelation).map(r -> (UnreifiedRelation)r).filter(r -> r != null).collect(Collectors.toCollection(LinkedHashSet::new)));
        relations.addAll(OmlSearch.findRelationBasesWithTarget(entity).stream().filter(r -> r instanceof RelationEntity).map(i -> (RelationEntity)i).filter(i -> i.getForwardRelation() != null).map(i -> i.getForwardRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        relations.addAll(OmlSearch.findRelationBasesWithSource(entity).stream().map(i -> i).filter(i -> i.getReverseRelation() != null).map(i -> i.getReverseRelation()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return relations;
    }

    public static Set<SemanticProperty> findSemanticPropertiesWithDomain(Classifier domain) {
        LinkedHashSet<SemanticProperty> properties = new LinkedHashSet<SemanticProperty>();
        properties.addAll(OmlSearch.findScalarPropertiesWithDomain(domain));
        properties.addAll(OmlSearch.findStructuredPropertiesWithDomain(domain));
        if (domain instanceof Entity) {
            properties.addAll(OmlSearch.findSourceRelations((Entity)domain));
        }
        return properties;
    }

    public static Set<SemanticProperty> findSemanticPropertiesWithRange(Type range) {
        LinkedHashSet<SemanticProperty> properties = new LinkedHashSet<SemanticProperty>();
        if (range instanceof Scalar) {
            properties.addAll(OmlSearch.findScalarPropertiesWithRange((Scalar)range));
        } else if (range instanceof Structure) {
            properties.addAll(OmlSearch.findStructuredPropertiesWithRange((Structure)range));
        } else if (range instanceof Entity) {
            properties.addAll(OmlSearch.findTargetRelations((Entity)range));
        }
        return properties;
    }

    public static Set<Classifier> findDomains(SemanticProperty property) {
        LinkedHashSet<Classifier> domains = new LinkedHashSet<Classifier>();
        domains.addAll((Collection<Classifier>)property.getDomainList());
        domains.addAll(OmlSearch.findRefs(property).stream().map(i -> (SemanticProperty)i).flatMap(r -> r.getDomainList().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return domains;
    }

    public static Set<Type> findRanges(SemanticProperty property) {
        LinkedHashSet<Type> ranges = new LinkedHashSet<Type>();
        ranges.addAll((Collection<Type>)property.getRangeList());
        ranges.addAll(OmlSearch.findRefs(property).stream().map(i -> (SemanticProperty)i).flatMap(r -> r.getRangeList().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return ranges;
    }

    public static Set<Entity> findEntitiesKeyedWith(SemanticProperty property) {
        return OmlSearch.findKeyAxiomsWithProperty(property).stream().map(i -> i.getKeyedEntity()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Entity> findSources(RelationBase base) {
        LinkedHashSet<Entity> sources = new LinkedHashSet<Entity>();
        sources.addAll((Collection<Entity>)base.getSources());
        sources.addAll(OmlSearch.findRefs(base).stream().map(i -> (RelationEntity)i).flatMap(r -> r.getSources().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return sources;
    }

    public static Set<Entity> findTargets(RelationBase base) {
        LinkedHashSet<Entity> sources = new LinkedHashSet<Entity>();
        sources.addAll((Collection<Entity>)base.getTargets());
        sources.addAll(OmlSearch.findRefs(base).stream().map(i -> (RelationEntity)i).flatMap(r -> r.getTargets().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return sources;
    }

    public static Set<Assertion> findAssertions(Instance instance) {
        LinkedHashSet<Assertion> assertions = new LinkedHashSet<Assertion>();
        assertions.addAll(OmlSearch.findPropertyValueAssertionsWithSubject(instance));
        if (instance instanceof NamedInstance) {
            assertions.addAll(OmlSearch.findTypeAssertions((NamedInstance)instance));
        }
        return assertions;
    }

    public static Set<TypeAssertion> findTypeAssertions(NamedInstance instance) {
        LinkedHashSet<TypeAssertion> assertions = new LinkedHashSet<TypeAssertion>((Collection<TypeAssertion>)instance.getOwnedTypes());
        assertions.addAll(OmlSearch.findRefs(instance).stream().filter(i -> i instanceof NamedInstance).map(i -> (NamedInstance)i).flatMap(r -> r.getOwnedTypes().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return assertions;
    }

    public static Set<PropertyValueAssertion> findPropertyValueAssertionsWithSubject(Instance subject) {
        LinkedHashSet<PropertyValueAssertion> assertions = new LinkedHashSet<PropertyValueAssertion>((Collection<PropertyValueAssertion>)subject.getOwnedPropertyValues());
        if (subject instanceof NamedInstance) {
            assertions.addAll(OmlSearch.findRefs((NamedInstance)subject).stream().filter(i -> i instanceof NamedInstance).map(i -> (NamedInstance)i).flatMap(r -> r.getOwnedPropertyValues().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return assertions;
    }

    public static Set<PropertyValueAssertion> findPropertyValueAssertionsWithObject(NamedInstance object) {
        return OmlSearch.findPropertyValueAssertionsWithReferencedValue(object);
    }

    public static Set<NamedInstance> findInstancesRelatedTo(NamedInstance instance) {
        LinkedHashSet<NamedInstance> related = new LinkedHashSet<NamedInstance>();
        related.addAll(OmlSearch.findInstancesRelatedAsTargetTo(instance));
        related.addAll(OmlSearch.findInstancesRelatedAsSourceTo(instance));
        return related;
    }

    public static Set<NamedInstance> findInstancesRelatedTo(NamedInstance instance, Relation relation) {
        LinkedHashSet<NamedInstance> related = new LinkedHashSet<NamedInstance>();
        related.addAll(OmlSearch.findInstancesRelatedAsTargetTo(instance, relation));
        related.addAll(OmlSearch.findInstancesRelatedAsSourceTo(instance, relation));
        return related;
    }

    public static Set<NamedInstance> findInstancesRelatedAsTargetTo(NamedInstance source) {
        LinkedHashSet<NamedInstance> targets = new LinkedHashSet<NamedInstance>();
        targets.addAll(OmlSearch.findPropertyValueAssertionsWithSubject(source).stream().filter(a -> a.getProperty() instanceof Relation).map(a -> a.getReferencedValue()).collect(Collectors.toCollection(LinkedHashSet::new)));
        targets.addAll(OmlSearch.findRelationInstancesWithSource(source).stream().flatMap(a -> a.getTargets().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return targets;
    }

    public static Set<NamedInstance> findInstancesRelatedAsTargetTo(NamedInstance source, Relation relation) {
        LinkedHashSet<NamedInstance> targets = new LinkedHashSet<NamedInstance>();
        targets.addAll(OmlSearch.findPropertyValueAssertionsWithSubject(source).stream().filter(a -> a.getProperty() == relation).map(a -> a.getReferencedValue()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (relation instanceof ForwardRelation) {
            targets.addAll(OmlSearch.findRelationInstancesWithSource(source).stream().filter(i -> OmlSearch.findIsTypeOf(i, ((ForwardRelation)relation).getRelationEntity())).flatMap(a -> a.getTargets().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return targets;
    }

    public static Set<NamedInstance> findInstancesRelatedAsSourceTo(NamedInstance target) {
        LinkedHashSet<NamedInstance> sources = new LinkedHashSet<NamedInstance>();
        sources.addAll(OmlSearch.findPropertyValueAssertionsWithObject(target).stream().map(a -> (NamedInstance)a.getSubject()).collect(Collectors.toCollection(LinkedHashSet::new)));
        sources.addAll(OmlSearch.findRelationInstancesWithTarget(target).stream().flatMap(a -> a.getSources().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        return sources;
    }

    public static Set<NamedInstance> findInstancesRelatedAsSourceTo(NamedInstance target, Relation relation) {
        LinkedHashSet<NamedInstance> sources = new LinkedHashSet<NamedInstance>();
        sources.addAll(OmlSearch.findPropertyValueAssertionsWithObject(target).stream().filter(a -> a.getProperty() == relation).map(a -> (NamedInstance)a.getSubject()).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (relation instanceof ForwardRelation) {
            sources.addAll(OmlSearch.findRelationInstancesWithTarget(target).stream().filter(i -> OmlSearch.findIsTypeOf(i, ((ForwardRelation)relation).getRelationEntity())).flatMap(i -> i.getSources().stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return sources;
    }

    public static Set<Element> findPropertyValues(Instance instance, SemanticProperty property) {
        return OmlSearch.findPropertyValueAssertionsWithSubject(instance).stream().filter(a -> a.getProperty() == property).map(a -> a.getValue()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Literal findPropertyLiteralValue(Instance instance, ScalarProperty property) {
        return OmlSearch.findPropertyValues(instance, property).stream().filter(i -> i instanceof Literal).map(i -> (Literal)i).findFirst().orElse(null);
    }

    public static StructureInstance findPropertyContainedValue(Instance instance, StructuredProperty property) {
        return OmlSearch.findPropertyValues(instance, property).stream().filter(i -> i instanceof StructureInstance).map(i -> (StructureInstance)i).findFirst().orElse(null);
    }

    public static NamedInstance findPropertyReferencedValue(Instance instance, Relation relation) {
        return OmlSearch.findPropertyValues(instance, relation).stream().filter(i -> i instanceof NamedInstance).map(i -> (NamedInstance)i).findFirst().orElse(null);
    }

    public static Set<Classifier> findTypes(Instance instance) {
        LinkedHashSet<Classifier> types = new LinkedHashSet<Classifier>();
        if (instance instanceof StructureInstance) {
            types.add(((StructureInstance)instance).getType());
        } else if (instance instanceof NamedInstance) {
            types.addAll(OmlSearch.findTypeAssertions((NamedInstance)instance).stream().map(i -> i.getType()).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
        return types;
    }

    public static Set<Classifier> findAllTypes(Instance instance) {
        Set types = OmlSearch.findTypes(instance).stream().flatMap(t -> OmlSearch.findAllSuperTerms(t, true).stream()).filter(t -> t instanceof Classifier).map(t -> (Classifier)t).distinct().collect(Collectors.toCollection(LinkedHashSet::new));
        return types;
    }

    public static boolean findIsTypeOf(Instance instance, Classifier type) {
        if (instance instanceof StructureInstance) {
            return ((StructureInstance)instance).getType() == type;
        }
        if (instance instanceof NamedInstance) {
            return OmlSearch.findTypeAssertions((NamedInstance)instance).stream().filter(i -> i.getType() == type).findFirst().isPresent();
        }
        return false;
    }

    public static boolean findIsKindOf(Instance instance, Classifier type) {
        if (instance instanceof StructureInstance) {
            return OmlSearch.findIsSubTermOf(((StructureInstance)instance).getType(), type);
        }
        if (instance instanceof NamedInstance) {
            return OmlSearch.findTypeAssertions((NamedInstance)instance).stream().map(i -> i.getType()).filter(t -> OmlSearch.findIsSubTermOf(t, type)).findFirst().isPresent();
        }
        return false;
    }

    public static Set<Instance> findInstancesOfType(Classifier type) {
        if (type instanceof Entity) {
            return OmlSearch.findTypeAssertionsWithType((Entity)type).stream().map(i -> i.getSubject()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        if (type instanceof Structure) {
            return new LinkedHashSet<Instance>(OmlSearch.findStructureInstancesWithType((Structure)type));
        }
        return Collections.emptySet();
    }

    public static Set<Instance> findInstancesOfKind(Classifier type) {
        return OmlSearch.findAllSubTerms(type, true).stream().map(t -> (Classifier)t).flatMap(t -> OmlSearch.findInstancesOfType(t).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Class<?> findJavaType(Scalar scalar) {
        while (scalar != null) {
            switch (scalar.getIri()) {
                case "http://www.w3.org/2001/XMLSchema#integer": {
                    return Integer.class;
                }
                case "http://www.w3.org/2001/XMLSchema#decimal": {
                    return BigDecimal.class;
                }
                case "http://www.w3.org/2001/XMLSchema#double": {
                    return Double.class;
                }
                case "http://www.w3.org/2001/XMLSchema#float": {
                    return Float.class;
                }
                case "http://www.w3.org/2001/XMLSchema#boolean": {
                    return Boolean.class;
                }
                case "http://www.w3.org/2001/XMLSchema#dateTime": {
                    return Date.class;
                }
                case "http://www.w3.org/2002/07/owl#real": {
                    return Double.class;
                }
            }
            scalar = (Scalar)OmlSearch.findSuperTerms(scalar).stream().findFirst().get();
        }
        return String.class;
    }

    public static Object findJavaValue(Literal literal) {
        if (literal instanceof QuotedLiteral) {
            QuotedLiteral qLiteral = (QuotedLiteral)literal;
            String value = qLiteral.getValue();
            Class<?> type = OmlSearch.findJavaType(qLiteral.getType());
            if (type == Integer.class) {
                return Integer.valueOf(value);
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(value);
            }
            if (type == Double.class) {
                return Double.valueOf(value);
            }
            if (type == Float.class) {
                return Float.valueOf(value);
            }
            if (type == Boolean.class) {
                return Boolean.valueOf(value);
            }
            if (type == Date.class) {
                try {
                    return new SimpleDateFormat().parse(value);
                }
                catch (ParseException e) {
                    throw new DateTimeParseException("Error parsing xsd:dateTime", value, 0);
                }
            }
            return value;
        }
        return literal.getValue();
    }

    public static Scalar findType(Literal literal) {
        return OmlRead.getType(literal);
    }

    public static Set<Scalar> findAllTypes(Literal literal) {
        Set types = OmlSearch.findAllSuperTerms(OmlRead.getType(literal), true).stream().filter(t -> t instanceof Scalar).map(t -> (Scalar)t).distinct().collect(Collectors.toCollection(LinkedHashSet::new));
        return types;
    }

    public static boolean findIsKindOf(Literal literal, Scalar type) {
        if (type.getOwnedEnumeration() != null) {
            return type.getOwnedEnumeration().getLiterals().stream().anyMatch(i -> OmlRead.isEqual(i, literal));
        }
        if (OmlRead.isStandardScalar(type)) {
            return OmlSearch.findAllTypes(literal).contains(type);
        }
        for (Term t : OmlSearch.findAllSuperTerms(type, false)) {
            Scalar supertype = (Scalar)t;
            if (OmlSearch.findIsKindOf(literal, supertype)) continue;
            return false;
        }
        return true;
    }
}

