/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.util;

import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.util.OmlCatalog;
import io.opencaesar.oml.util.OmlConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

final class OmlUriResolver {
    private static OmlUriResolver instance;
    private Thread thread;
    private boolean doStop = false;
    private WatchService watcher;
    private Map<WatchKey, File> watched;
    private Map<URI, Map<String, URI>> importCache;
    private Map<URI, OmlCatalog> catalogCache;
    private URIConverter uriConverter = new ExtensibleURIConverterImpl();

    private OmlUriResolver() {
        this.activate();
    }

    public static OmlUriResolver getInstance() {
        if (instance == null) {
            instance = new OmlUriResolver();
        }
        return instance;
    }

    protected void activate() {
        if (this.thread == null) {
            try {
                this.catalogCache = new HashMap<URI, OmlCatalog>();
                this.importCache = new HashMap<URI, Map<String, URI>>();
                this.watcher = FileSystems.getDefault().newWatchService();
                this.watched = new HashMap<WatchKey, File>();
                this.thread = new Thread((Runnable)new Monitor(), "Oml Uri Resolver");
                this.thread.setDaemon(true);
                this.thread.start();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    protected void deactivate() {
        if (this.thread != null) {
            try {
                this.doStop = true;
                this.thread.interrupt();
                this.thread = null;
                this.watched = null;
                this.watcher.close();
                this.clearCache();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    protected void clearCache() {
        if (this.importCache != null) {
            this.importCache.clear();
        }
        if (this.catalogCache != null) {
            this.catalogCache.clear();
        }
    }

    private File toFile(URI uri) {
        URI localUri = CommonPlugin.asLocalURI((URI)uri);
        return localUri != null && localUri.isFile() ? new File(localUri.toFileString()) : null;
    }

    private boolean exists(URI uri) {
        return this.uriConverter.exists(uri, null);
    }

    public synchronized URI resolveUri(Resource contextResource, String iri) {
        URI folderUri = contextResource.getURI().trimSegments(1);
        Map<String, URI> importMap = this.importCache.get(folderUri);
        if (importMap == null) {
            importMap = new HashMap<String, URI>();
            this.importCache.put(folderUri, importMap);
        }
        if (importMap.containsKey(iri)) {
            return importMap.get(iri);
        }
        URI resolvedUri = this.resolveFromCatalog(folderUri, iri);
        if (resolvedUri != null) {
            importMap.put(iri, resolvedUri);
        } else {
            ResourceSet rs = contextResource.getResourceSet();
            if (rs.getLoadOptions().get("ResolveIRIsUsingLoadedResources") == Boolean.TRUE) {
                resolvedUri = this.resolveFromResourceSet(rs, iri);
            }
        }
        return resolvedUri;
    }

    private URI resolveFromResourceSet(ResourceSet rs, String iri) {
        Ontology ontology = rs.getResources().stream().flatMap(i -> i.getContents().stream()).filter(i -> i instanceof Ontology).map(i -> (Ontology)i).filter(i -> i.getIri().equals(iri)).findFirst().orElse(null);
        return ontology != null ? ontology.eResource().getURI() : null;
    }

    private URI resolveFromCatalog(URI folderUri, String iri) {
        URI resolved;
        OmlCatalog catalog = this.findCatalog(folderUri);
        if (catalog == null) {
            return null;
        }
        try {
            resolved = catalog.resolveUri(URI.createURI((String)iri));
            if (resolved == null) {
                return null;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
        for (String extension : OmlConstants.OML_EXTENSIONS) {
            URI resolvedUri = resolved.appendFileExtension(extension);
            if (!this.exists(resolvedUri)) continue;
            return resolvedUri;
        }
        return this.exists(resolved) ? resolved : null;
    }

    public synchronized Set<URI> getResolvedUris(Resource contextResource) {
        if (contextResource == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        contextResource.getResourceSet().getResources().forEach(r -> uris.add(r.getURI()));
        uris.removeIf(uri -> !OmlConstants.OML_EXTENSION_LIST.contains(uri.fileExtension()));
        uris.remove(contextResource.getURI());
        URI folderUri = contextResource.getURI().trimSegments(1);
        OmlCatalog catalog = this.findCatalog(folderUri);
        if (catalog != null) {
            try {
                catalog.getResolvedUris().forEach(u -> uris.add((URI)u));
            }
            catch (IOException e) {
                System.err.println(e);
                return Collections.emptySet();
            }
        }
        return uris;
    }

    public boolean isResolvedUri(URI uri) {
        URI folderUri = uri.trimSegments(1);
        OmlCatalog catalog = this.findCatalog(folderUri);
        if (catalog == null) {
            return false;
        }
        return catalog.isResolvedUri(uri);
    }

    private OmlCatalog findCatalog(URI folderUri) {
        OmlCatalog catalog = null;
        ArrayList<URI> folderUris = new ArrayList<URI>();
        while (catalog == null && folderUri.segmentCount() > 0) {
            catalog = this.catalogCache.get(folderUri);
            if (catalog == null) {
                folderUris.add(folderUri);
                catalog = this.getCatalog(folderUri);
            }
            folderUri = folderUri.trimSegments(1);
        }
        for (URI uri : folderUris) {
            this.catalogCache.put(uri, catalog);
            File folder = this.toFile(uri);
            if (folder == null) continue;
            try {
                WatchKey key = folder.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.watched.put(key, folder);
            }
            catch (IOException e) {
                break;
            }
        }
        return catalog;
    }

    private OmlCatalog getCatalog(URI folderUri) {
        try {
            URI catalogUri = folderUri.appendSegment("catalog.xml");
            if (this.uriConverter.exists(catalogUri, null)) {
                return OmlCatalog.create(catalogUri);
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return null;
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            while (!OmlUriResolver.this.doStop) {
                WatchKey key;
                try {
                    key = OmlUriResolver.this.watcher.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                File folder = OmlUriResolver.this.watched.get(key);
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<?> ev = event;
                    Path fileName = (Path)ev.context();
                    File file = folder.toPath().resolve(fileName).toFile();
                    if (file.getName().equals("catalog.xml")) {
                        OmlUriResolver.this.importCache.clear();
                        OmlUriResolver.this.catalogCache.clear();
                        continue;
                    }
                    if (!file.exists()) continue;
                    OmlUriResolver.this.importCache.clear();
                }
                boolean valid = key.reset();
                if (valid) continue;
                OmlUriResolver.this.watched.remove(key);
            }
        }
    }
}

