/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.util;

import io.opencaesar.oml.Argument;
import io.opencaesar.oml.Aspect;
import io.opencaesar.oml.Classifier;
import io.opencaesar.oml.ClassifierEquivalenceAxiom;
import io.opencaesar.oml.Concept;
import io.opencaesar.oml.ConceptInstance;
import io.opencaesar.oml.Description;
import io.opencaesar.oml.DescriptionBundle;
import io.opencaesar.oml.Element;
import io.opencaesar.oml.Entity;
import io.opencaesar.oml.ForwardRelation;
import io.opencaesar.oml.Import;
import io.opencaesar.oml.ImportKind;
import io.opencaesar.oml.Instance;
import io.opencaesar.oml.Literal;
import io.opencaesar.oml.Member;
import io.opencaesar.oml.NamedInstance;
import io.opencaesar.oml.OmlPackage;
import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.Property;
import io.opencaesar.oml.PropertyCardinalityRestrictionAxiom;
import io.opencaesar.oml.PropertyEquivalenceAxiom;
import io.opencaesar.oml.PropertyPredicate;
import io.opencaesar.oml.PropertyRangeRestrictionAxiom;
import io.opencaesar.oml.PropertyRestrictionAxiom;
import io.opencaesar.oml.PropertySelfRestrictionAxiom;
import io.opencaesar.oml.PropertyValueAssertion;
import io.opencaesar.oml.PropertyValueRestrictionAxiom;
import io.opencaesar.oml.QuotedLiteral;
import io.opencaesar.oml.Relation;
import io.opencaesar.oml.RelationEntity;
import io.opencaesar.oml.RelationEntityPredicate;
import io.opencaesar.oml.RelationInstance;
import io.opencaesar.oml.ReverseRelation;
import io.opencaesar.oml.Rule;
import io.opencaesar.oml.Scalar;
import io.opencaesar.oml.ScalarEquivalenceAxiom;
import io.opencaesar.oml.ScalarProperty;
import io.opencaesar.oml.SemanticProperty;
import io.opencaesar.oml.SpecializationAxiom;
import io.opencaesar.oml.Structure;
import io.opencaesar.oml.StructuredProperty;
import io.opencaesar.oml.Term;
import io.opencaesar.oml.Type;
import io.opencaesar.oml.TypeAssertion;
import io.opencaesar.oml.TypePredicate;
import io.opencaesar.oml.Vocabulary;
import io.opencaesar.oml.VocabularyBox;
import io.opencaesar.oml.VocabularyBundle;
import io.opencaesar.oml.util.OmlRead;
import io.opencaesar.oml.util.OmlSearch;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class OmlValidator2 {
    private static final String OWL_NOTHING = "owl:Nothing";
    public static final OmlValidator2 INSTANCE = new OmlValidator2();
    private Map<EClass, List<Method>> methodMap;

    private OmlValidator2() {
    }

    public boolean run(Element element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List<Method> methods;
        if (this.methodMap == null) {
            this.collectValidates();
        }
        if ((methods = this.methodMap.get(element.eClass())) != null) {
            for (Method method : methods) {
                try {
                    method.invoke((Object)this, element, diagnostics, context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    private void collectValidates() {
        this.methodMap = new HashMap<EClass, List<Method>>();
        List methods = Arrays.stream(OmlValidator2.class.getDeclaredMethods()).filter(m -> m.getName().startsWith("validate") && m.getParameterTypes().length == 3).collect(Collectors.toList());
        OmlPackage.eINSTANCE.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(c -> !c.isAbstract()).forEach(eClass -> methods.forEach(method -> {
            Class<?> paramType = method.getParameterTypes()[0];
            if (paramType.isAssignableFrom(eClass.getInstanceClass())) {
                List<Method> list = this.methodMap.get(eClass);
                if (list == null) {
                    list = new ArrayList<Method>();
                    this.methodMap.put((EClass)eClass, list);
                }
                list.add((Method)method);
            }
        }));
    }

    private boolean report(int kind, DiagnosticChain diagnostics, EObject object, String message, EStructuralFeature feature) {
        diagnostics.add((Diagnostic)new BasicDiagnostic(kind, "io.opencaesar.oml", 1, message, new Object[]{object, feature}));
        return false;
    }

    protected boolean validateOntologyHasUnusedImports(Ontology object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        HashSet<String> referencedNSs = new HashSet<String>();
        TreeIterator i = object.eAllContents();
        while (i.hasNext()) {
            EObject element = (EObject)i.next();
            EClass eClass = element.eClass();
            for (EReference eReference : eClass.getEAllReferences()) {
                Ontology ontology;
                if (eReference.isContainment()) continue;
                Object refs = element.eGet((EStructuralFeature)eReference);
                if (eReference.isMany()) {
                    ((List)refs).forEach(ref -> {
                        Ontology ontology = ref.getOntology();
                        if (ontology != null) {
                            referencedNSs.add(ontology.getNamespace());
                        }
                    });
                    continue;
                }
                if (refs == null || (ontology = ((Element)refs).getOntology()) == null) continue;
                referencedNSs.add(ontology.getNamespace());
            }
        }
        boolean returnValue = true;
        for (Import import_ : object.getOwnedImports()) {
            if (import_.getPrefix() == null || referencedNSs.contains(import_.getNamespace())) continue;
            this.report(2, diagnostics, import_, "Import <" + import_.getNamespace() + "> with prefix is not used", null);
            returnValue = false;
        }
        return returnValue;
    }

    protected boolean validateOntologyHasDuplicateImports(Ontology object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean returnValue = true;
        EList<Import> imports = object.getOwnedImports();
        for (Import import_ : imports) {
            if (!imports.stream().anyMatch(i -> i != import_ && i.getNamespace() != null && i.getNamespace().equals(import_.getNamespace()))) continue;
            this.report(2, diagnostics, import_, "Import <" + import_.getNamespace() + "> is a duplicate", null);
            returnValue = false;
        }
        return returnValue;
    }

    protected boolean validateOntologyHasSelfImports(Ontology object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean returnValue = true;
        EList<Import> imports = object.getOwnedImports();
        for (Import import_ : imports) {
            if (!imports.stream().anyMatch(i -> i.getNamespace() != null && i.getNamespace().equals(object.getNamespace()))) continue;
            this.report(2, diagnostics, import_, "Import <" + import_.getNamespace() + "> is to self", null);
            returnValue = false;
        }
        return returnValue;
    }

    protected boolean validateOntologyIri(Ontology object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean returnValue = true;
        String iri = object.getIri();
        URI uri = object.eResource().getURI();
        if (!OmlRead.isResolvedUri(uri) || !uri.equals(OmlRead.getResolvedUri(object.eResource(), iri))) {
            this.report(4, diagnostics, object, object.eClass().getName() + " iri '" + iri + "' does not resolve to '" + uri + "' using the catalog", (EStructuralFeature)OmlPackage.Literals.ONTOLOGY__NAMESPACE);
            returnValue = false;
        }
        return returnValue;
    }

    protected boolean validateImportURI(Import object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getKind() == ImportKind.EXTENSION) {
            if (object.eContainer() instanceof Vocabulary) {
                if (!(OmlRead.getImportedOntology(object) instanceof Vocabulary)) {
                    return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to a vocabulary", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
                }
            } else if (object.eContainer() instanceof VocabularyBundle) {
                if (!(OmlRead.getImportedOntology(object) instanceof VocabularyBundle)) {
                    return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to a vocabulary bundle", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
                }
            } else if (object.eContainer() instanceof Description) {
                if (!(OmlRead.getImportedOntology(object) instanceof Description)) {
                    return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to an description", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
                }
            } else if (object.eContainer() instanceof DescriptionBundle && !(OmlRead.getImportedOntology(object) instanceof DescriptionBundle)) {
                return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to an description bundle", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
            }
        } else if (object.getKind() == ImportKind.USAGE) {
            if (object.eContainer() instanceof Vocabulary) {
                if (!(OmlRead.getImportedOntology(object) instanceof Description)) {
                    return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to a description", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
                }
            } else if (object.eContainer() instanceof Description) {
                if (!(OmlRead.getImportedOntology(object) instanceof Vocabulary)) {
                    return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to a vocabulary", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
                }
            } else if (object.eContainer() instanceof DescriptionBundle && !(OmlRead.getImportedOntology(object) instanceof VocabularyBox)) {
                return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to a vocabulary or a vocabulary bundle", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
            }
        } else if (object.getKind() == ImportKind.INCLUSION) {
            if (object.eContainer() instanceof VocabularyBundle) {
                if (!(OmlRead.getImportedOntology(object) instanceof Vocabulary)) {
                    return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to a vocabulary", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
                }
            } else if (object.eContainer() instanceof DescriptionBundle && !(OmlRead.getImportedOntology(object) instanceof Description)) {
                return this.report(4, diagnostics, object, "Namespace <" + object.getNamespace() + "> could not be resolved to a description", (EStructuralFeature)OmlPackage.Literals.IMPORT__NAMESPACE);
            }
        }
        return true;
    }

    protected boolean validatePropertyRestrictionAxiomDomain(PropertyRestrictionAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List domainTypes;
        Classifier restrictingDomain = object.getRestrictingDomain();
        SemanticProperty property = object.getProperty();
        List<Object> list = domainTypes = property != null ? property.getDomainList() : Collections.emptyList();
        if (restrictingDomain != null && !domainTypes.isEmpty()) {
            Set<Term> allSuperTerms = OmlSearch.findAllSuperTerms(restrictingDomain, true);
            allSuperTerms.retainAll(domainTypes);
            if (allSuperTerms.isEmpty()) {
                return this.report(2, diagnostics, object, "Property " + object.getProperty().getAbbreviatedIri() + " has a domain that is not the same as or a super type of " + restrictingDomain.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY);
            }
        }
        return true;
    }

    protected boolean validatePropertyRangeRestrictionAxiomRange(PropertyRangeRestrictionAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List rangeTypes;
        Type restrictedRange = object.getRange();
        SemanticProperty property = object.getProperty();
        List<Object> list = rangeTypes = property != null ? property.getRangeList() : Collections.emptyList();
        if (!rangeTypes.isEmpty() && restrictedRange != null && !restrictedRange.getAbbreviatedIri().equals(OWL_NOTHING)) {
            Set<Term> allSuperTerms = OmlSearch.findAllSuperTerms(restrictedRange, true);
            allSuperTerms.retainAll(rangeTypes);
            if (allSuperTerms.isEmpty()) {
                return this.report(2, diagnostics, object, "Type " + restrictedRange.getAbbreviatedIri() + " is not the same as or a sub type of property " + property.getAbbreviatedIri() + "'s range", (EStructuralFeature)OmlPackage.Literals.PROPERTY_RANGE_RESTRICTION_AXIOM__RANGE);
            }
        }
        return true;
    }

    protected boolean validatePropertyCardinalityRestrictionAxiomRange(PropertyCardinalityRestrictionAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List rangeTypes;
        Type restrictedRange = object.getRange();
        SemanticProperty property = object.getProperty();
        List<Object> list = rangeTypes = property != null ? property.getRangeList() : Collections.emptyList();
        if (!rangeTypes.isEmpty() && restrictedRange != null && !restrictedRange.getAbbreviatedIri().equals(OWL_NOTHING)) {
            Set<Term> allSuperTerms = OmlSearch.findAllSuperTerms(restrictedRange, true);
            allSuperTerms.retainAll(rangeTypes);
            if (allSuperTerms.isEmpty()) {
                return this.report(2, diagnostics, object, "Type " + restrictedRange.getAbbreviatedIri() + " is not the same as or a sub type of property " + property.getAbbreviatedIri() + "'s range", (EStructuralFeature)OmlPackage.Literals.PROPERTY_CARDINALITY_RESTRICTION_AXIOM__RANGE);
            }
        }
        return true;
    }

    protected boolean validatePropertyValueRestrictionAxiomValue(PropertyValueRestrictionAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        SemanticProperty property = object.getProperty();
        if (property instanceof ScalarProperty) {
            if (object.getLiteralValue() == null) {
                return this.report(2, diagnostics, object, "A literal is expected as the restricted value of property " + property.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY);
            }
            if (property.getRangeList().stream().noneMatch(t -> OmlSearch.findIsKindOf(object.getLiteralValue(), (Scalar)t))) {
                return this.report(2, diagnostics, object, "The literal is not in the range of scalar property " + property.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.PROPERTY_VALUE_RESTRICTION_AXIOM__LITERAL_VALUE);
            }
        } else if (property instanceof StructuredProperty) {
            if (object.getContainedValue() == null) {
                return this.report(2, diagnostics, object, "A structure instance is expected as the restricted value of property " + property.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY);
            }
            if (property.getRangeList().stream().noneMatch(t -> OmlSearch.findIsKindOf(object.getContainedValue(), (Structure)t))) {
                return this.report(2, diagnostics, object, "The instance is not in the range of structured property " + property.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.PROPERTY_VALUE_RESTRICTION_AXIOM__CONTAINED_VALUE);
            }
        } else if (property instanceof Relation) {
            if (object.getReferencedValue() == null) {
                return this.report(2, diagnostics, object, "A named instance IRI is expected as the restricted value of relation " + property.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY);
            }
            if (property.getRangeList().stream().noneMatch(t -> OmlSearch.findIsKindOf(object.getReferencedValue(), (Entity)t))) {
                return this.report(2, diagnostics, object, "The instance is not in the range of relation " + property.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.PROPERTY_VALUE_RESTRICTION_AXIOM__REFERENCED_VALUE);
            }
        }
        return true;
    }

    protected boolean validatePropertySelfRestrictionAxiomProperty(PropertySelfRestrictionAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        SemanticProperty property = object.getProperty();
        if (!(property instanceof Relation)) {
            return this.report(2, diagnostics, object, "Property " + property.getAbbreviatedIri() + " cannot be used in a self restriction (only relations are allowed)", (EStructuralFeature)OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY);
        }
        return true;
    }

    protected boolean validateSpecializationAxiomSpecializedTermKind(SpecializationAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Term subTerm;
        Term superTerm = object.getSuperTerm();
        if (superTerm == (subTerm = object.getSubTerm())) {
            return this.report(2, diagnostics, object, "Term " + subTerm.getAbbreviatedIri() + " specializes itself", (EStructuralFeature)OmlPackage.Literals.SPECIALIZATION_AXIOM__SUPER_TERM);
        }
        if (superTerm != null && !superTerm.eIsProxy()) {
            EClass superEClass = superTerm.eClass();
            EClass subEClass = subTerm.eClass();
            if (!(OmlPackage.Literals.ASPECT == superEClass && OmlPackage.Literals.ENTITY.isSuperTypeOf(subEClass) || superTerm instanceof Relation && subTerm instanceof Relation || superEClass == subEClass)) {
                return this.report(4, diagnostics, object, "Term " + superTerm.getAbbreviatedIri() + " cannot be specialized by " + subTerm.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.SPECIALIZATION_AXIOM__SUPER_TERM);
            }
        }
        return true;
    }

    protected boolean validateClassifierEquivalenceAxiom(ClassifierEquivalenceAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Classifier subClassifier;
        EList<Classifier> superClassifiers = object.getSuperClassifiers();
        if (superClassifiers.contains(subClassifier = object.getSubClassifier())) {
            return this.report(2, diagnostics, object, "Classifier " + subClassifier.getAbbreviatedIri() + " specializes itself", (EStructuralFeature)OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__SUPER_CLASSIFIERS);
        }
        if (superClassifiers.size() == 1) {
            if (!((Classifier)superClassifiers.get(0)).eIsProxy() && ((Classifier)superClassifiers.get(0)).eClass() != subClassifier.eClass()) {
                return this.report(4, diagnostics, object, "Classifier " + ((Classifier)superClassifiers.get(0)).getAbbreviatedIri() + " cannot be specialized by " + subClassifier.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__SUPER_CLASSIFIERS);
            }
        } else {
            for (Classifier superClassifier : superClassifiers) {
                if (superClassifier.eIsProxy() || superClassifier.eClass() == subClassifier.eClass() || subClassifier instanceof Entity && superClassifier instanceof Aspect) continue;
                return this.report(4, diagnostics, object, "Classifier " + superClassifier.getAbbreviatedIri() + " cannot be specialized by " + subClassifier.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__SUPER_CLASSIFIERS);
            }
        }
        return true;
    }

    protected boolean validatePropertyEquivalenceAxiom(PropertyEquivalenceAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Property subProperty;
        Property superProperty = object.getSuperProperty();
        if (superProperty == (subProperty = object.getSubProperty())) {
            return this.report(2, diagnostics, object, "Property " + subProperty.getAbbreviatedIri() + " specializes itself", (EStructuralFeature)OmlPackage.Literals.PROPERTY_EQUIVALENCE_AXIOM__SUPER_PROPERTY);
        }
        if (superProperty != null && !superProperty.eIsProxy()) {
            EClass superEClass = superProperty.eClass();
            EClass subEClass = subProperty.eClass();
            if (!(subProperty instanceof Relation && superProperty instanceof Relation || superEClass == subEClass)) {
                return this.report(4, diagnostics, object, "Property " + superProperty.getAbbreviatedIri() + " cannot be specialized by " + subProperty.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.PROPERTY_EQUIVALENCE_AXIOM__SUPER_PROPERTY);
            }
        }
        return true;
    }

    protected boolean validateScalarSupertypes(Scalar object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean hasSpecializations;
        boolean isStandardType = OmlRead.isStandardScalar(object);
        boolean bl = hasSpecializations = !object.getOwnedSpecializations().isEmpty();
        if (!isStandardType && hasSpecializations) {
            return this.report(4, diagnostics, object, "Non-standard Scalar " + object.getAbbreviatedIri() + " cannot have specializations", (EStructuralFeature)OmlPackage.Literals.SPECIALIZABLE_TERM__OWNED_SPECIALIZATIONS);
        }
        boolean hasAllStandardSupers = OmlRead.getSpecializationSuperTerms(object).stream().filter(i -> i instanceof Scalar).allMatch(i -> OmlRead.isStandardScalar((Scalar)i));
        if (!hasAllStandardSupers) {
            return this.report(4, diagnostics, object, "Standard scalar " + object.getAbbreviatedIri() + " can only specialize standard scalars", (EStructuralFeature)OmlPackage.Literals.SPECIALIZABLE_TERM__OWNED_SPECIALIZATIONS);
        }
        return true;
    }

    protected boolean validateScalarEnumeration(Scalar object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getOwnedEnumeration() != null) {
            for (Term superTerm : OmlRead.getSuperTerms(object)) {
                Scalar superScalar = (Scalar)superTerm;
                for (Literal literal : object.getOwnedEnumeration().getLiterals()) {
                    if (OmlSearch.findIsKindOf(literal, superScalar)) continue;
                    return this.report(4, diagnostics, object, literal.getLexicalValue() + " is not a literal of scalar " + superScalar.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.SCALAR__OWNED_ENUMERATION);
                }
            }
        }
        return true;
    }

    protected boolean validateScalarEquivalenceAxioms(ScalarEquivalenceAxiom object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isStandardSuper = OmlRead.isStandardScalar(object.getSuperScalar());
        int facets = OmlRead.getNumberOfFacets(object);
        if (facets > 0 && !isStandardSuper) {
            return this.report(4, diagnostics, object, "Facets can only restrict standard super scalars", (EStructuralFeature)OmlPackage.Literals.SCALAR_EQUIVALENCE_AXIOM__SUPER_SCALAR);
        }
        return true;
    }

    protected boolean validateTypePredicateAsConsequent(TypePredicate object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getConsequentRule() != null) {
            if (object.getType() instanceof Structure) {
                return this.report(4, diagnostics, object, "Structure " + object.getType().getAbbreviatedIri() + " cannot be used as a consequent predicate", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            }
            if (object.getType() instanceof Scalar) {
                return this.report(4, diagnostics, object, "Scalar " + object.getType().getAbbreviatedIri() + " cannot be used as a consequent predicate", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            }
        }
        return true;
    }

    protected boolean validatePropertyPredicateAsConsequent(PropertyPredicate object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getConsequentRule() != null && object.getProperty() instanceof StructuredProperty) {
            return this.report(4, diagnostics, object, "Structured property " + object.getProperty().getAbbreviatedIri() + " cannot be used as a consequent predicate", (EStructuralFeature)OmlPackage.Literals.PROPERTY_PREDICATE__PROPERTY);
        }
        return true;
    }

    protected boolean validatePropertyPredicateArg2(Argument object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int n3;
        int n1 = object.getVariable() != null ? 1 : 0;
        int n2 = object.getLiteral() != null ? 1 : 0;
        int n = n3 = object.getInstance() != null ? 1 : 0;
        if (n1 + n2 + n3 != 1) {
            return this.report(4, diagnostics, object, "Argument must be either a variable, a literal or an instance.", (EStructuralFeature)OmlPackage.Literals.ARGUMENT__VARIABLE);
        }
        return true;
    }

    protected boolean validateTypePredicate(TypePredicate object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getType() instanceof Scalar) {
            if (object.getArgument().getInstance() != null) {
                return this.report(4, diagnostics, object, "Scalar predicate cannot have a named instance as an argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            }
        } else if (object.getArgument().getLiteral() != null) {
            return this.report(4, diagnostics, object, "Entity predicate cannot have a literal as an argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
        }
        return true;
    }

    protected boolean validatePropertyPredicate(PropertyPredicate object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (object.getArgument1().getLiteral() != null) {
            this.report(4, diagnostics, object, "Property predicate cannot have a literal as a first argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            result = false;
        }
        if (object.getProperty() instanceof ScalarProperty) {
            if (object.getArgument2().getInstance() != null) {
                this.report(4, diagnostics, object, "Scala property predicate cannot have a named instance as a second argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
                result = false;
            }
        } else if (object.getProperty() instanceof Relation && object.getArgument2().getLiteral() != null) {
            this.report(4, diagnostics, object, "Relation predicate cannot have a literal as a second argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            result = false;
        }
        return result;
    }

    protected boolean validatePropertyPredicate(RelationEntityPredicate object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (object.getArgument1().getLiteral() != null) {
            this.report(4, diagnostics, object, "Relation entity predicate cannot have a literal as a first argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            result = false;
        }
        if (object.getArgument().getLiteral() != null) {
            this.report(4, diagnostics, object, "Relation entity predicate cannot have a literal as a second argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            result = false;
        }
        if (object.getArgument().getInstance() != null && !(object.getArgument().getInstance() instanceof RelationInstance)) {
            this.report(4, diagnostics, object, "Relation entity predicate cannot have a non-relation instance as a second argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            result = false;
        }
        if (object.getArgument2().getLiteral() != null) {
            this.report(4, diagnostics, object, "Relation entity predicate cannot have a literal as a third argument", (EStructuralFeature)OmlPackage.Literals.TYPE_PREDICATE__TYPE);
            result = false;
        }
        return result;
    }

    protected boolean validateQuotedLiteral(QuotedLiteral object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Scalar scalar = object.getType();
        if (scalar != null && !OmlRead.isStandardScalar(scalar)) {
            return this.report(4, diagnostics, object, "Quoted Literal \"" + object.getValue() + "\" is not typed by a standard scalar", (EStructuralFeature)OmlPackage.Literals.QUOTED_LITERAL__TYPE);
        }
        return true;
    }

    protected boolean validatePropertyValueRestrictionAxiomSubject(PropertyValueAssertion object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List domainTypes;
        Instance theSubject = object.getSubject();
        SemanticProperty property = object.getProperty();
        List<Object> list = domainTypes = property != null ? property.getDomainList() : Collections.emptyList();
        if (domainTypes.stream().noneMatch(t -> OmlSearch.findIsKindOf(theSubject, t))) {
            return this.report(2, diagnostics, object, "Property " + property.getAbbreviatedIri() + " has a domain that does not include the asserting instance", (EStructuralFeature)OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY);
        }
        return true;
    }

    protected boolean validatePropertyValueRestrictionAxiomObject(PropertyValueAssertion object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List domainTypes;
        Element theObject = object.getObject();
        SemanticProperty property = object.getProperty();
        List<Object> list = domainTypes = property != null ? property.getRangeList() : Collections.emptyList();
        if (theObject != null) {
            boolean validInstance;
            boolean validLiteral = theObject instanceof Literal && domainTypes.stream().anyMatch(t -> OmlSearch.findIsKindOf((Literal)theObject, (Scalar)t));
            boolean bl = validInstance = theObject instanceof Instance && domainTypes.stream().anyMatch(t -> OmlSearch.findIsKindOf((Instance)theObject, (Classifier)t));
            if (property instanceof ScalarProperty && !validLiteral || property instanceof StructuredProperty && !validInstance || property instanceof Relation && !validInstance) {
                return this.report(2, diagnostics, object, "Property " + property.getAbbreviatedIri() + " has a range that does not include the asserted value", (EStructuralFeature)OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY);
            }
        }
        return true;
    }

    protected boolean validateTypeRestriction(TypeAssertion object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        NamedInstance instance = object.getSubject();
        Entity type = object.getType();
        if (type != null && (instance instanceof ConceptInstance && !(type instanceof Concept) && !(type instanceof Aspect) || instance instanceof RelationInstance && !(type instanceof RelationEntity) && !(type instanceof Aspect))) {
            return this.report(4, diagnostics, object, "Type " + type.getAbbreviatedIri() + " cannot be a type for instance " + instance.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.TYPE_ASSERTION__TYPE);
        }
        return true;
    }

    protected boolean validateMemberCardinalities(Member object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (object.getName() == null && !object.isRef() || object.getName() != null && object.isRef()) {
            this.report(4, diagnostics, object, "Member needs to either have a name or a ref to another member", (EStructuralFeature)OmlPackage.Literals.MEMBER__NAME);
            result = false;
        }
        return result;
    }

    protected boolean validateReverseRelation(ReverseRelation object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getRelationBase().isRef()) {
            return this.report(4, diagnostics, object, "Cannot name a reverse relation on a ref to " + object.getRelationBase().getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.MEMBER__NAME);
        }
        return true;
    }

    protected boolean validateForwardRelation(ForwardRelation object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getRelationEntity().isRef()) {
            return this.report(4, diagnostics, object, "Cannot name a forward relation on a ref to " + object.getRelationEntity().getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.MEMBER__NAME);
        }
        return true;
    }

    protected boolean validateRelationEntityCardinalities(RelationEntity object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!object.isRef() && object.getForwardRelation() == null) {
            return this.report(4, diagnostics, object, "Must name a forward relation on " + object.getAbbreviatedIri(), (EStructuralFeature)OmlPackage.Literals.RELATION_ENTITY__FORWARD_RELATION);
        }
        return true;
    }

    protected boolean validateRuleCardinalities(Rule object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getName() != null) {
            if (object.getAntecedent().isEmpty()) {
                return this.report(4, diagnostics, object, "Rule " + object.getAbbreviatedIri() + " needs to specify some predicates as antecedent", (EStructuralFeature)OmlPackage.Literals.MEMBER__NAME);
            }
            if (object.getConsequent().isEmpty()) {
                return this.report(4, diagnostics, object, "Rule " + object.getAbbreviatedIri() + " needs to specify some predicates as consequent", (EStructuralFeature)OmlPackage.Literals.MEMBER__NAME);
            }
        } else {
            boolean result = true;
            if (!object.getAntecedent().isEmpty()) {
                this.report(4, diagnostics, object, "Rule " + object.getAbbreviatedIri() + " cannot respecify a predeicate as antecedent", (EStructuralFeature)OmlPackage.Literals.RULE__ANTECEDENT);
                result = false;
            }
            if (!object.getConsequent().isEmpty()) {
                this.report(4, diagnostics, object, "Rule " + object.getAbbreviatedIri() + " cannot respecify a predicate as consequent", (EStructuralFeature)OmlPackage.Literals.RULE__CONSEQUENT);
                result = false;
            }
            return result;
        }
        return true;
    }

    protected boolean validateRelationInstanceCardinalities(RelationInstance object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (object.getName() != null) {
            if (object.getSources().isEmpty()) {
                return this.report(4, diagnostics, object, "Relation instance " + object.getAbbreviatedIri() + " needs to specify at least one source", (EStructuralFeature)OmlPackage.Literals.MEMBER__NAME);
            }
            if (object.getTargets().isEmpty()) {
                return this.report(4, diagnostics, object, "Relation instance " + object.getAbbreviatedIri() + " needs to specify at least one target", (EStructuralFeature)OmlPackage.Literals.MEMBER__NAME);
            }
        }
        return true;
    }

    protected boolean instersect(Collection<?> col1, Collection<?> col2) {
        return col1.stream().anyMatch(i -> col2.contains(i));
    }
}

