/*
 * Decompiled with CFR 0.152.
 */
package io.opencaesar.oml.util;

import io.opencaesar.oml.Annotation;
import io.opencaesar.oml.AnnotationProperty;
import io.opencaesar.oml.Argument;
import io.opencaesar.oml.Aspect;
import io.opencaesar.oml.BooleanLiteral;
import io.opencaesar.oml.BuiltIn;
import io.opencaesar.oml.BuiltInPredicate;
import io.opencaesar.oml.CardinalityRestrictionKind;
import io.opencaesar.oml.Classifier;
import io.opencaesar.oml.ClassifierEquivalenceAxiom;
import io.opencaesar.oml.Concept;
import io.opencaesar.oml.ConceptInstance;
import io.opencaesar.oml.DecimalLiteral;
import io.opencaesar.oml.Description;
import io.opencaesar.oml.DescriptionBundle;
import io.opencaesar.oml.DescriptionStatement;
import io.opencaesar.oml.DifferentFromPredicate;
import io.opencaesar.oml.DoubleLiteral;
import io.opencaesar.oml.Element;
import io.opencaesar.oml.Entity;
import io.opencaesar.oml.ForwardRelation;
import io.opencaesar.oml.IdentifiedElement;
import io.opencaesar.oml.Import;
import io.opencaesar.oml.ImportKind;
import io.opencaesar.oml.Instance;
import io.opencaesar.oml.InstanceEnumerationAxiom;
import io.opencaesar.oml.IntegerLiteral;
import io.opencaesar.oml.KeyAxiom;
import io.opencaesar.oml.Literal;
import io.opencaesar.oml.LiteralEnumerationAxiom;
import io.opencaesar.oml.Member;
import io.opencaesar.oml.NamedInstance;
import io.opencaesar.oml.OmlPackage;
import io.opencaesar.oml.Ontology;
import io.opencaesar.oml.Predicate;
import io.opencaesar.oml.Property;
import io.opencaesar.oml.PropertyCardinalityRestrictionAxiom;
import io.opencaesar.oml.PropertyEquivalenceAxiom;
import io.opencaesar.oml.PropertyPredicate;
import io.opencaesar.oml.PropertyRangeRestrictionAxiom;
import io.opencaesar.oml.PropertySelfRestrictionAxiom;
import io.opencaesar.oml.PropertyValueAssertion;
import io.opencaesar.oml.PropertyValueRestrictionAxiom;
import io.opencaesar.oml.QuotedLiteral;
import io.opencaesar.oml.RangeRestrictionKind;
import io.opencaesar.oml.Relation;
import io.opencaesar.oml.RelationBase;
import io.opencaesar.oml.RelationEntity;
import io.opencaesar.oml.RelationEntityPredicate;
import io.opencaesar.oml.RelationInstance;
import io.opencaesar.oml.ReverseRelation;
import io.opencaesar.oml.Rule;
import io.opencaesar.oml.SameAsPredicate;
import io.opencaesar.oml.Scalar;
import io.opencaesar.oml.ScalarEquivalenceAxiom;
import io.opencaesar.oml.ScalarProperty;
import io.opencaesar.oml.SemanticProperty;
import io.opencaesar.oml.SpecializableProperty;
import io.opencaesar.oml.SpecializableTerm;
import io.opencaesar.oml.SpecializationAxiom;
import io.opencaesar.oml.Structure;
import io.opencaesar.oml.StructureInstance;
import io.opencaesar.oml.StructuredProperty;
import io.opencaesar.oml.Type;
import io.opencaesar.oml.TypeAssertion;
import io.opencaesar.oml.TypePredicate;
import io.opencaesar.oml.UnreifiedRelation;
import io.opencaesar.oml.Vocabulary;
import io.opencaesar.oml.VocabularyBundle;
import io.opencaesar.oml.VocabularyStatement;
import io.opencaesar.oml.util.OmlFactory2;
import io.opencaesar.oml.util.OmlRead;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OmlWrite {
    protected static void setCrossReference(Ontology ontology, Element subject, EReference eRef, IdentifiedElement object) {
        Class objectClass = eRef.getEType().getInstanceClass();
        assert (!eRef.isContainment()) : eRef.getName() + " is a containment reference";
        assert (!eRef.isMany()) : eRef.getName() + " is a List reference";
        assert (IdentifiedElement.class.isAssignableFrom(objectClass)) : eRef.getName() + " is not typed by an identified element";
        subject.eSet((EStructuralFeature)eRef, object);
    }

    protected static void setCrossReferences(Ontology ontology, Element subject, EReference eRef, List<? extends Element> objects) {
        Class objectClass = eRef.getEType().getInstanceClass();
        assert (!eRef.isContainment()) : eRef.getName() + " is a containment reference";
        assert (eRef.isMany()) : eRef.getName() + " is a singular reference";
        assert (Element.class.isAssignableFrom(objectClass)) : eRef.getName() + " is not typed by an Oml element";
        subject.eSet((EStructuralFeature)eRef, objects);
    }

    protected static void setContainmentReference(Ontology ontology, Element subject, EReference elementERef, Element object) {
        Class objectClass = elementERef.getEType().getInstanceClass();
        assert (elementERef.isContainment()) : elementERef.getName() + " is not a containment reference";
        assert (objectClass.isInstance(object)) : object + " is not an instance of " + objectClass.getName();
        assert (elementERef.getEType() == elementERef.getEType()) : elementERef.getName() + " does not have the same type as " + elementERef.getName();
        if (object != null && subject != null) {
            if (subject.getOntology() == ontology) {
                ((List)subject.eGet((EStructuralFeature)elementERef)).add(object);
            } else if (subject instanceof Member) {
                ((List)OmlWrite.getOrAddRef(ontology, (Member)subject).eGet((EStructuralFeature)elementERef)).add(object);
            }
        }
    }

    protected static <T extends Element> T create(Class<T> type) {
        return OmlFactory2.INSTANCE.create(type);
    }

    protected static Member getOrAddRef(Ontology ontology, Member member) {
        Member ref = OmlRead.getRefs(ontology).stream().filter(i -> i.getRef() == member).findFirst().orElse(null);
        if (ref == null) {
            ref = OmlWrite.createRef(member);
            if (ontology instanceof Vocabulary) {
                ((Vocabulary)ontology).getOwnedStatements().add((Object)((VocabularyStatement)ref));
            } else if (ontology instanceof Description) {
                ((Description)ontology).getOwnedStatements().add((Object)((DescriptionStatement)ref));
            }
        }
        return ref;
    }

    public static Annotation addAnnotation(Ontology ontology, AnnotationProperty property, Literal literalValue, Member referencedValue) {
        Annotation annotation = OmlWrite.create(Annotation.class);
        if (literalValue != null) {
            annotation.setLiteralValue(literalValue);
        } else if (referencedValue != null) {
            annotation.setReferencedValue(referencedValue);
        }
        OmlWrite.setCrossReference(ontology, annotation, OmlPackage.Literals.ANNOTATION__PROPERTY, property);
        ontology.getOwnedAnnotations().add((Object)annotation);
        return annotation;
    }

    public static Annotation addAnnotation(Ontology ontology, IdentifiedElement element, AnnotationProperty property, Literal literalValue, Member referencedValue) {
        Annotation annotation = OmlWrite.create(Annotation.class);
        if (literalValue != null) {
            annotation.setLiteralValue(literalValue);
        } else if (referencedValue != null) {
            annotation.setReferencedValue(referencedValue);
        }
        OmlWrite.setCrossReference(ontology, annotation, OmlPackage.Literals.ANNOTATION__PROPERTY, property);
        OmlWrite.setContainmentReference(ontology, element, OmlPackage.Literals.IDENTIFIED_ELEMENT__OWNED_ANNOTATIONS, annotation);
        return annotation;
    }

    protected static <T extends Ontology> T createOntology(Class<T> type, String namespace, String prefix) {
        Ontology ontology = (Ontology)OmlWrite.create(type);
        ontology.setNamespace(namespace);
        ontology.setPrefix(prefix);
        return (T)ontology;
    }

    public static Vocabulary createVocabulary(String namespace, String prefix) {
        return OmlWrite.createOntology(Vocabulary.class, namespace, prefix);
    }

    public static VocabularyBundle createVocabularyBundle(String namespace, String prefix) {
        return OmlWrite.createOntology(VocabularyBundle.class, namespace, prefix);
    }

    public static Description createDescription(String namespace, String prefix) {
        return OmlWrite.createOntology(Description.class, namespace, prefix);
    }

    public static DescriptionBundle createDescriptionBundle(String namespace, String prefix) {
        return OmlWrite.createOntology(DescriptionBundle.class, namespace, prefix);
    }

    public static Aspect addAspect(Vocabulary vocabulary, String name) {
        Aspect aspect = OmlWrite.create(Aspect.class);
        aspect.setName(name);
        vocabulary.getOwnedStatements().add((Object)aspect);
        return aspect;
    }

    public static Concept addConcept(Vocabulary vocabulary, String name) {
        Concept concept = OmlWrite.create(Concept.class);
        concept.setName(name);
        vocabulary.getOwnedStatements().add((Object)concept);
        return concept;
    }

    public static RelationEntity addRelationEntity(Vocabulary vocabulary, String name, List<Entity> sources, List<Entity> targets, boolean functional, boolean inverseFunctional, boolean symmetric, boolean asymmetric, boolean reflexive, boolean irreflexive, boolean transitive) {
        RelationEntity relation = OmlWrite.create(RelationEntity.class);
        relation.setName(name);
        relation.setFunctional(functional);
        relation.setInverseFunctional(inverseFunctional);
        relation.setSymmetric(symmetric);
        relation.setAsymmetric(asymmetric);
        relation.setReflexive(reflexive);
        relation.setIrreflexive(irreflexive);
        relation.setTransitive(transitive);
        OmlWrite.setCrossReferences(vocabulary, relation, OmlPackage.Literals.RELATION_BASE__SOURCES, sources);
        OmlWrite.setCrossReferences(vocabulary, relation, OmlPackage.Literals.RELATION_BASE__TARGETS, targets);
        vocabulary.getOwnedStatements().add((Object)relation);
        return relation;
    }

    public static Structure addStructure(Vocabulary vocabulary, String name) {
        Structure structure = OmlWrite.create(Structure.class);
        structure.setName(name);
        vocabulary.getOwnedStatements().add((Object)structure);
        return structure;
    }

    public static AnnotationProperty addAnnotationProperty(Vocabulary vocabulary, String name) {
        AnnotationProperty property = OmlWrite.create(AnnotationProperty.class);
        property.setName(name);
        vocabulary.getOwnedStatements().add((Object)property);
        return property;
    }

    public static ScalarProperty addScalarProperty(Vocabulary vocabulary, String name, List<Classifier> domains, List<Scalar> ranges, boolean functional) {
        ScalarProperty property = OmlWrite.create(ScalarProperty.class);
        property.setName(name);
        property.setFunctional(functional);
        OmlWrite.setCrossReferences(vocabulary, property, OmlPackage.Literals.SCALAR_PROPERTY__DOMAINS, domains);
        OmlWrite.setCrossReferences(vocabulary, property, OmlPackage.Literals.SCALAR_PROPERTY__RANGES, ranges);
        vocabulary.getOwnedStatements().add((Object)property);
        return property;
    }

    public static StructuredProperty addStructuredProperty(Vocabulary vocabulary, String name, List<Classifier> domains, List<Structure> ranges, boolean functional) {
        StructuredProperty property = OmlWrite.create(StructuredProperty.class);
        property.setName(name);
        property.setFunctional(functional);
        OmlWrite.setCrossReferences(vocabulary, property, OmlPackage.Literals.STRUCTURED_PROPERTY__DOMAINS, domains);
        OmlWrite.setCrossReferences(vocabulary, property, OmlPackage.Literals.STRUCTURED_PROPERTY__RANGES, ranges);
        vocabulary.getOwnedStatements().add((Object)property);
        return property;
    }

    public static Scalar addScalar(Vocabulary vocabulary, String name) {
        Scalar scalar = OmlWrite.create(Scalar.class);
        scalar.setName(name);
        vocabulary.getOwnedStatements().add((Object)scalar);
        return scalar;
    }

    public static ForwardRelation addForwardRelation(RelationEntity entity, String name) {
        ForwardRelation forward = OmlWrite.create(ForwardRelation.class);
        forward.setName(name);
        entity.setForwardRelation(forward);
        return forward;
    }

    public static ReverseRelation addReverseRelation(RelationBase base, String name) {
        ReverseRelation reverse = OmlWrite.create(ReverseRelation.class);
        reverse.setName(name);
        base.setReverseRelation(reverse);
        return reverse;
    }

    public static UnreifiedRelation addUnreifiedRelation(Vocabulary vocabulary, String name, List<Entity> sources, List<Entity> targets, boolean functional, boolean inverseFunctional, boolean symmetric, boolean asymmetric, boolean reflexive, boolean irreflexive, boolean transitive) {
        UnreifiedRelation relation = OmlWrite.create(UnreifiedRelation.class);
        relation.setName(name);
        relation.setFunctional(functional);
        relation.setInverseFunctional(inverseFunctional);
        relation.setSymmetric(symmetric);
        relation.setAsymmetric(asymmetric);
        relation.setReflexive(reflexive);
        relation.setIrreflexive(irreflexive);
        relation.setTransitive(transitive);
        OmlWrite.setCrossReferences(vocabulary, relation, OmlPackage.Literals.RELATION_BASE__SOURCES, sources);
        OmlWrite.setCrossReferences(vocabulary, relation, OmlPackage.Literals.RELATION_BASE__TARGETS, targets);
        vocabulary.getOwnedStatements().add((Object)relation);
        return relation;
    }

    public static Rule addRule(Vocabulary vocabulary, String name, Predicate[] consequent, Predicate[] antecedent) {
        Rule rule = OmlWrite.create(Rule.class);
        rule.setName(name);
        rule.getConsequent().addAll(Arrays.asList(consequent));
        rule.getAntecedent().addAll(Arrays.asList(antecedent));
        vocabulary.getOwnedStatements().add((Object)rule);
        return rule;
    }

    public static BuiltIn addBuiltIn(Vocabulary vocabulary, String name) {
        BuiltIn builtIn = OmlWrite.create(BuiltIn.class);
        builtIn.setName(name);
        vocabulary.getOwnedStatements().add((Object)builtIn);
        return builtIn;
    }

    public static StructureInstance createStructureInstance(Ontology ontology, Structure structure) {
        StructureInstance instance = OmlWrite.create(StructureInstance.class);
        OmlWrite.setCrossReference(ontology, instance, OmlPackage.Literals.STRUCTURE_INSTANCE__TYPE, structure);
        return instance;
    }

    public static ConceptInstance addConceptInstance(Description description, String name) {
        ConceptInstance instance = OmlWrite.create(ConceptInstance.class);
        instance.setName(name);
        description.getOwnedStatements().add((Object)instance);
        return instance;
    }

    public static RelationInstance addRelationInstance(Description description, String name, List<NamedInstance> sources, List<NamedInstance> targets) {
        RelationInstance instance = OmlWrite.create(RelationInstance.class);
        instance.setName(name);
        OmlWrite.setCrossReferences(description, instance, OmlPackage.Literals.RELATION_INSTANCE__SOURCES, new ArrayList<NamedInstance>(sources));
        OmlWrite.setCrossReferences(description, instance, OmlPackage.Literals.RELATION_INSTANCE__TARGETS, new ArrayList<NamedInstance>(targets));
        description.getOwnedStatements().add((Object)instance);
        return instance;
    }

    protected static <T extends Member> T createRef(T member) {
        if (member instanceof Aspect) {
            Aspect ref = OmlWrite.create(Aspect.class);
            ref.setRef((Aspect)member);
            return (T)ref;
        }
        if (member instanceof Concept) {
            Concept ref = OmlWrite.create(Concept.class);
            ref.setRef((Concept)member);
            return (T)ref;
        }
        if (member instanceof RelationEntity) {
            RelationEntity ref = OmlWrite.create(RelationEntity.class);
            ref.setRef((RelationEntity)member);
            return (T)ref;
        }
        if (member instanceof Structure) {
            Structure ref = OmlWrite.create(Structure.class);
            ref.setRef((Structure)member);
            return (T)ref;
        }
        if (member instanceof Scalar) {
            Scalar ref = OmlWrite.create(Scalar.class);
            ref.setRef((Scalar)member);
            return (T)ref;
        }
        if (member instanceof AnnotationProperty) {
            AnnotationProperty ref = OmlWrite.create(AnnotationProperty.class);
            ref.setRef((AnnotationProperty)member);
            return (T)ref;
        }
        if (member instanceof ScalarProperty) {
            ScalarProperty ref = OmlWrite.create(ScalarProperty.class);
            ref.setRef((ScalarProperty)member);
            return (T)ref;
        }
        if (member instanceof StructuredProperty) {
            StructuredProperty ref = OmlWrite.create(StructuredProperty.class);
            ref.setRef((StructuredProperty)member);
            return (T)ref;
        }
        if (member instanceof Relation) {
            UnreifiedRelation ref = OmlWrite.create(UnreifiedRelation.class);
            ref.setRef((Relation)member);
            return (T)ref;
        }
        if (member instanceof Rule) {
            Rule ref = OmlWrite.create(Rule.class);
            ref.setRef((Rule)member);
            return (T)ref;
        }
        if (member instanceof ConceptInstance) {
            ConceptInstance ref = OmlWrite.create(ConceptInstance.class);
            ref.setRef((ConceptInstance)member);
            return (T)ref;
        }
        if (member instanceof RelationInstance) {
            RelationInstance ref = OmlWrite.create(RelationInstance.class);
            ref.setRef((RelationInstance)member);
            return (T)ref;
        }
        return null;
    }

    public static Import addImport(Ontology ontology, ImportKind kind, String namespace, String prefix) {
        Import import_ = OmlWrite.create(Import.class);
        import_.setKind(kind);
        import_.setNamespace(namespace);
        import_.setPrefix(prefix);
        ontology.getOwnedImports().add((Object)import_);
        return import_;
    }

    public static SpecializationAxiom addSpecializationAxiom(Vocabulary vocabulary, SpecializableTerm subTerm, SpecializableTerm superTerm) {
        SpecializationAxiom axiom = OmlWrite.create(SpecializationAxiom.class);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.SPECIALIZATION_AXIOM__SUPER_TERM, superTerm);
        OmlWrite.setContainmentReference(vocabulary, subTerm, OmlPackage.Literals.SPECIALIZABLE_TERM__OWNED_SPECIALIZATIONS, axiom);
        return axiom;
    }

    public static ClassifierEquivalenceAxiom addClassifierEquivalenceAxiom(Vocabulary vocabulary, Classifier subClassifier, List<Classifier> superClassifiers) {
        ClassifierEquivalenceAxiom axiom = OmlWrite.create(ClassifierEquivalenceAxiom.class);
        OmlWrite.setCrossReferences(vocabulary, axiom, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__SUPER_CLASSIFIERS, superClassifiers);
        OmlWrite.setContainmentReference(vocabulary, subClassifier, OmlPackage.Literals.CLASSIFIER__OWNED_EQUIVALENCES, axiom);
        return axiom;
    }

    public static ScalarEquivalenceAxiom addScalarEquivalenceAxiom(Vocabulary vocabulary, Scalar subScalar, Scalar superScalar, Long length, Long minLength, Long maxLength, String pattern, String language, Literal minInclusive, Literal minExclusive, Literal maxInclusive, Literal maxExclusive) {
        ScalarEquivalenceAxiom axiom = OmlWrite.create(ScalarEquivalenceAxiom.class);
        axiom.setLength(length);
        axiom.setMinLength(minLength);
        axiom.setMaxLength(maxLength);
        axiom.setPattern(pattern);
        axiom.setLanguage(language);
        axiom.setMinInclusive(minInclusive);
        axiom.setMinExclusive(minExclusive);
        axiom.setMaxInclusive(maxInclusive);
        axiom.setMaxExclusive(maxExclusive);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.SCALAR_EQUIVALENCE_AXIOM__SUPER_SCALAR, superScalar);
        OmlWrite.setContainmentReference(vocabulary, subScalar, OmlPackage.Literals.SCALAR__OWNED_EQUIVALENCES, axiom);
        return axiom;
    }

    public static PropertyEquivalenceAxiom addPropertyEquivalenceAxiom(Vocabulary vocabulary, SpecializableProperty subProperty, Property superProperty) {
        PropertyEquivalenceAxiom axiom = OmlWrite.create(PropertyEquivalenceAxiom.class);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_EQUIVALENCE_AXIOM__SUPER_PROPERTY, superProperty);
        OmlWrite.setContainmentReference(vocabulary, subProperty, OmlPackage.Literals.SPECIALIZABLE_PROPERTY__OWNED_EQUIVALENCES, axiom);
        return axiom;
    }

    public static PropertyRangeRestrictionAxiom addPropertyRangeRestrictionAxiom(Vocabulary vocabulary, Element owner, SemanticProperty property, Type range, RangeRestrictionKind restrictionKind) {
        PropertyRangeRestrictionAxiom axiom = OmlWrite.create(PropertyRangeRestrictionAxiom.class);
        axiom.setKind(restrictionKind);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, property);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RANGE_RESTRICTION_AXIOM__RANGE, range);
        if (owner instanceof Classifier) {
            OmlWrite.setContainmentReference(vocabulary, (Classifier)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            OmlWrite.setContainmentReference(vocabulary, (ClassifierEquivalenceAxiom)owner, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__OWNED_PROPERTY_RESTRICTIONS, axiom);
        }
        return axiom;
    }

    public static PropertyCardinalityRestrictionAxiom addPropertyCardinalityRestrictionAxiom(Vocabulary vocabulary, Element owner, SemanticProperty property, CardinalityRestrictionKind restrictionKind, long cardinality, Type range) {
        PropertyCardinalityRestrictionAxiom axiom = OmlWrite.create(PropertyCardinalityRestrictionAxiom.class);
        axiom.setKind(restrictionKind);
        axiom.setCardinality(cardinality);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, property);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_CARDINALITY_RESTRICTION_AXIOM__RANGE, range);
        if (owner instanceof Classifier) {
            OmlWrite.setContainmentReference(vocabulary, (Classifier)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            OmlWrite.setContainmentReference(vocabulary, (ClassifierEquivalenceAxiom)owner, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__OWNED_PROPERTY_RESTRICTIONS, axiom);
        }
        return axiom;
    }

    public static PropertyValueRestrictionAxiom addPropertyValueRestrictionAxiom(Vocabulary vocabulary, Element owner, ScalarProperty property, Literal value) {
        PropertyValueRestrictionAxiom axiom = OmlWrite.create(PropertyValueRestrictionAxiom.class);
        axiom.setLiteralValue(value);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, property);
        if (owner instanceof Classifier) {
            OmlWrite.setContainmentReference(vocabulary, (Classifier)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            OmlWrite.setContainmentReference(vocabulary, (ClassifierEquivalenceAxiom)owner, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__OWNED_PROPERTY_RESTRICTIONS, axiom);
        }
        return axiom;
    }

    public static PropertyValueRestrictionAxiom addPropertyValueRestrictionAxiom(Vocabulary vocabulary, Element owner, StructuredProperty property, StructureInstance value) {
        PropertyValueRestrictionAxiom axiom = OmlWrite.create(PropertyValueRestrictionAxiom.class);
        axiom.setContainedValue(value);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, property);
        if (owner instanceof Classifier) {
            OmlWrite.setContainmentReference(vocabulary, (Classifier)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            OmlWrite.setContainmentReference(vocabulary, (ClassifierEquivalenceAxiom)owner, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__OWNED_PROPERTY_RESTRICTIONS, axiom);
        }
        return axiom;
    }

    public static PropertyValueRestrictionAxiom addPropertyValueRestrictionAxiom(Vocabulary vocabulary, Element owner, Relation relation, NamedInstance value) {
        PropertyValueRestrictionAxiom axiom = OmlWrite.create(PropertyValueRestrictionAxiom.class);
        axiom.setReferencedValue(value);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, relation);
        if (owner instanceof Classifier) {
            OmlWrite.setContainmentReference(vocabulary, (Classifier)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            OmlWrite.setContainmentReference(vocabulary, (ClassifierEquivalenceAxiom)owner, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__OWNED_PROPERTY_RESTRICTIONS, axiom);
        }
        return axiom;
    }

    public static PropertySelfRestrictionAxiom addPropertySelfRestrictionAxiom(Vocabulary vocabulary, Element owner, Relation relation) {
        PropertySelfRestrictionAxiom axiom = OmlWrite.create(PropertySelfRestrictionAxiom.class);
        OmlWrite.setCrossReference(vocabulary, axiom, OmlPackage.Literals.PROPERTY_RESTRICTION_AXIOM__PROPERTY, relation);
        if (owner instanceof Classifier) {
            OmlWrite.setContainmentReference(vocabulary, (Classifier)owner, OmlPackage.Literals.CLASSIFIER__OWNED_PROPERTY_RESTRICTIONS, axiom);
        } else if (owner instanceof ClassifierEquivalenceAxiom) {
            OmlWrite.setContainmentReference(vocabulary, (ClassifierEquivalenceAxiom)owner, OmlPackage.Literals.CLASSIFIER_EQUIVALENCE_AXIOM__OWNED_PROPERTY_RESTRICTIONS, axiom);
        }
        return axiom;
    }

    public static KeyAxiom addKeyAxiom(Vocabulary vocabulary, Entity domain, List<Property> keyProperties) {
        KeyAxiom axiom = OmlWrite.create(KeyAxiom.class);
        OmlWrite.setCrossReferences(vocabulary, axiom, OmlPackage.Literals.KEY_AXIOM__PROPERTIES, new ArrayList<Property>(keyProperties));
        OmlWrite.setContainmentReference(vocabulary, domain, OmlPackage.Literals.ENTITY__OWNED_KEYS, axiom);
        return axiom;
    }

    public static InstanceEnumerationAxiom addInstanceEnumerationAxiom(Vocabulary vocabulary, Concept domain, List<ConceptInstance> instances) {
        InstanceEnumerationAxiom axiom = OmlWrite.create(InstanceEnumerationAxiom.class);
        OmlWrite.setCrossReferences(vocabulary, axiom, OmlPackage.Literals.INSTANCE_ENUMERATION_AXIOM__INSTANCES, new ArrayList<ConceptInstance>(instances));
        OmlWrite.setContainmentReference(vocabulary, domain, OmlPackage.Literals.CONCEPT__OWNED_ENUMERATION, axiom);
        return axiom;
    }

    public static LiteralEnumerationAxiom addLiteralEnumerationAxiom(Vocabulary vocabulary, Scalar domain, Literal ... literals) {
        LiteralEnumerationAxiom axiom = OmlWrite.create(LiteralEnumerationAxiom.class);
        axiom.getLiterals().addAll(Arrays.asList(literals));
        OmlWrite.setContainmentReference(vocabulary, domain, OmlPackage.Literals.SCALAR__OWNED_ENUMERATION, axiom);
        return axiom;
    }

    public static TypeAssertion addTypeAssertion(Description description, NamedInstance instance, Entity type) {
        TypeAssertion assertion = OmlWrite.create(TypeAssertion.class);
        OmlWrite.setCrossReference(description, assertion, OmlPackage.Literals.TYPE_ASSERTION__TYPE, type);
        OmlWrite.setContainmentReference(description, instance, OmlPackage.Literals.NAMED_INSTANCE__OWNED_TYPES, assertion);
        return assertion;
    }

    public static PropertyValueAssertion addPropertyValueAssertion(Ontology ontology, Instance instance, ScalarProperty property, Literal literalValue) {
        PropertyValueAssertion assertion = OmlWrite.create(PropertyValueAssertion.class);
        assertion.setLiteralValue(literalValue);
        OmlWrite.setCrossReference(ontology, assertion, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY, property);
        OmlWrite.setContainmentReference(ontology, instance, OmlPackage.Literals.INSTANCE__OWNED_PROPERTY_VALUES, assertion);
        return assertion;
    }

    public static PropertyValueAssertion addPropertyValueAssertion(Ontology ontology, Instance instance, StructuredProperty property, StructureInstance containedeValue) {
        PropertyValueAssertion assertion = OmlWrite.create(PropertyValueAssertion.class);
        assertion.setContainedValue(containedeValue);
        OmlWrite.setCrossReference(ontology, assertion, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY, property);
        OmlWrite.setContainmentReference(ontology, instance, OmlPackage.Literals.INSTANCE__OWNED_PROPERTY_VALUES, assertion);
        return assertion;
    }

    public static PropertyValueAssertion addPropertyValueAssertion(Ontology ontology, Instance instance, Relation relation, NamedInstance referencedValue) {
        PropertyValueAssertion assertion = OmlWrite.create(PropertyValueAssertion.class);
        assertion.setReferencedValue(referencedValue);
        OmlWrite.setCrossReference(ontology, assertion, OmlPackage.Literals.PROPERTY_VALUE_ASSERTION__PROPERTY, relation);
        OmlWrite.setContainmentReference(ontology, instance, OmlPackage.Literals.INSTANCE__OWNED_PROPERTY_VALUES, assertion);
        return assertion;
    }

    public static Argument createArgument(Vocabulary vocabulary, String variable, Literal literal, NamedInstance instance) {
        Argument argument = OmlWrite.create(Argument.class);
        argument.setVariable(variable);
        argument.setLiteral(literal);
        OmlWrite.setCrossReference(vocabulary, argument, OmlPackage.Literals.ARGUMENT__INSTANCE, instance);
        return argument;
    }

    public static TypePredicate createTypePredicate(Vocabulary vocabulary, Type type, Argument argument) {
        TypePredicate predicate = OmlWrite.create(TypePredicate.class);
        predicate.setArgument(argument);
        OmlWrite.setCrossReference(vocabulary, predicate, OmlPackage.Literals.TYPE_PREDICATE__TYPE, type);
        return predicate;
    }

    public static RelationEntityPredicate createRelationEntityPredicate(Vocabulary vocabulary, RelationEntity type, Argument argument1, Argument argument, Argument argument2) {
        RelationEntityPredicate predicate = OmlWrite.create(RelationEntityPredicate.class);
        predicate.setArgument1(argument1);
        predicate.setArgument(argument);
        predicate.setArgument2(argument2);
        OmlWrite.setCrossReference(vocabulary, predicate, OmlPackage.Literals.RELATION_ENTITY_PREDICATE__TYPE, type);
        return predicate;
    }

    public static PropertyPredicate createPropertyPredicate(Vocabulary vocabulary, Property property, Argument argument1, Argument argument2) {
        PropertyPredicate predicate = OmlWrite.create(PropertyPredicate.class);
        predicate.setArgument1(argument1);
        predicate.setArgument2(argument2);
        OmlWrite.setCrossReference(vocabulary, predicate, OmlPackage.Literals.PROPERTY_PREDICATE__PROPERTY, property);
        return predicate;
    }

    public static SameAsPredicate createSameAsPredicate(Vocabulary vocabulary, Argument argument1, Argument argument2) {
        SameAsPredicate predicate = OmlWrite.create(SameAsPredicate.class);
        predicate.setArgument1(argument1);
        predicate.setArgument2(argument2);
        return predicate;
    }

    public static DifferentFromPredicate createDifferentFromPredicate(Vocabulary vocabulary, Argument argument1, Argument argument2) {
        DifferentFromPredicate predicate = OmlWrite.create(DifferentFromPredicate.class);
        predicate.setArgument1(argument1);
        predicate.setArgument2(argument2);
        return predicate;
    }

    public static BuiltInPredicate createBuiltInPredicate(Vocabulary vocabulary, BuiltIn builtIn, Argument ... arguments) {
        BuiltInPredicate predicate = OmlWrite.create(BuiltInPredicate.class);
        predicate.setBuiltIn(builtIn);
        predicate.getArguments().addAll(Arrays.asList(arguments));
        return predicate;
    }

    public static Literal createLiteral(Object value) {
        if (value instanceof Boolean) {
            return OmlWrite.createBooleanLiteral((Boolean)value);
        }
        if (value instanceof Double) {
            return OmlWrite.createDoubleLiteral((Double)value);
        }
        if (value instanceof BigDecimal) {
            return OmlWrite.createDecimalLiteral((BigDecimal)value);
        }
        if (value instanceof Integer) {
            return OmlWrite.createIntegerLiteral((Integer)value);
        }
        return OmlWrite.createQuotedLiteral(null, value.toString(), null, null);
    }

    public static QuotedLiteral createQuotedLiteral(Ontology ontology, String value, Scalar type, String langTag) {
        QuotedLiteral literal = OmlWrite.create(QuotedLiteral.class);
        literal.setValue(value);
        if (type != null) {
            OmlWrite.setCrossReference(ontology, literal, OmlPackage.Literals.QUOTED_LITERAL__TYPE, type);
        } else if (langTag != null) {
            literal.setLangTag(langTag);
        }
        return literal;
    }

    public static IntegerLiteral createIntegerLiteral(int value) {
        IntegerLiteral literal = OmlWrite.create(IntegerLiteral.class);
        literal.setValue(value);
        return literal;
    }

    public static DecimalLiteral createDecimalLiteral(BigDecimal value) {
        DecimalLiteral literal = OmlWrite.create(DecimalLiteral.class);
        literal.setValue(value);
        return literal;
    }

    public static DoubleLiteral createDoubleLiteral(double value) {
        DoubleLiteral literal = OmlWrite.create(DoubleLiteral.class);
        literal.setValue(value);
        return literal;
    }

    public static BooleanLiteral createBooleanLiteral(boolean value) {
        BooleanLiteral literal = OmlWrite.create(BooleanLiteral.class);
        literal.setValue(value);
        return literal;
    }
}

