/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.base.Preconditions;
import io.opencensus.common.Clock;
import io.opencensus.implcore.internal.EventQueue;
import io.opencensus.implcore.stats.CurrentStatsState;
import io.opencensus.implcore.stats.StatsManager;
import io.opencensus.implcore.stats.StatsRecorderImpl;
import io.opencensus.implcore.stats.ViewManagerImpl;
import io.opencensus.stats.StatsCollectionState;
import io.opencensus.stats.StatsComponent;

public class StatsComponentImplBase
extends StatsComponent {
    private final CurrentStatsState state = new CurrentStatsState();
    private final ViewManagerImpl viewManager;
    private final StatsRecorderImpl statsRecorder;

    public StatsComponentImplBase(EventQueue queue, Clock clock) {
        StatsManager statsManager = new StatsManager(queue, clock, this.state);
        this.viewManager = new ViewManagerImpl(statsManager);
        this.statsRecorder = new StatsRecorderImpl(statsManager);
    }

    public ViewManagerImpl getViewManager() {
        return this.viewManager;
    }

    public StatsRecorderImpl getStatsRecorder() {
        return this.statsRecorder;
    }

    public StatsCollectionState getState() {
        return this.state.get();
    }

    public void setState(StatsCollectionState newState) {
        boolean stateChanged = this.state.set((StatsCollectionState)Preconditions.checkNotNull((Object)newState, (Object)"newState"));
        if (stateChanged) {
            if (newState == StatsCollectionState.DISABLED) {
                this.viewManager.clearStats();
            } else {
                this.viewManager.resumeStatsCollection();
            }
        }
    }
}

