/*
 * Decompiled with CFR 0.152.
 */
package io.openepcis.epc.eventhash;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.openepcis.epc.eventhash.ConstantEventHashInfo;
import io.openepcis.epc.eventhash.HashNodeComparator;
import io.openepcis.epc.eventhash.TemplateNodeMap;
import io.openepcis.epc.translator.ConverterUtil;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ContextNode {
    protected String name;
    protected String value;
    protected ArrayList<ContextNode> children = new ArrayList();
    protected ContextNode parent;
    protected Map<String, String> namespaces;

    public ContextNode(ContextNode parent, String name, String value) {
        this.parent = parent;
        this.name = name;
        this.value = value;
        this.namespaces = parent.namespaces;
    }

    public ContextNode(ContextNode parent, String name, Iterator<Map.Entry<String, JsonNode>> fields) {
        this(fields, parent.namespaces);
        this.parent = parent;
        this.name = name;
    }

    public ContextNode(ContextNode parent, Iterator<Map.Entry<String, JsonNode>> fields) {
        this(fields, parent.namespaces);
        this.parent = parent;
        this.namespaces = parent.namespaces;
    }

    public ContextNode(ContextNode parent, String name, ArrayNode node) {
        this.parent = parent;
        this.name = name;
        this.namespaces = parent.namespaces;
        Iterator iter = node.elements();
        while (iter.hasNext()) {
            JsonNode n = (JsonNode)iter.next();
            if (n.isValueNode() && !n.isArray()) {
                if (ConstantEventHashInfo.EPC_LISTS.stream().anyMatch(name::equals)) {
                    this.children.add(new ContextNode(this, "epc", n.textValue()));
                    continue;
                }
            }
            if (n.isValueNode() && !n.isArray()) {
                this.children.add(new ContextNode(this, name, n.textValue()));
                continue;
            }
            if (n.isArray()) {
                ArrayNode arrayNode = (ArrayNode)n;
                this.children.add(new ContextNode(this, name, arrayNode));
                continue;
            }
            if (n.isObject() && ConstantEventHashInfo.LIST_OF_OBJECTS.containsKey(name)) {
                this.children.add(new ContextNode(this, ConstantEventHashInfo.LIST_OF_OBJECTS.get(name), n.fields()));
                continue;
            }
            if (n.isObject()) {
                this.children.add(new ContextNode(this, n.fields()));
                continue;
            }
            this.children.add(new ContextNode(this, name, n.fields()));
        }
    }

    public ContextNode(Iterator<Map.Entry<String, JsonNode>> fields, Map<String, String> namespaces) {
        this.namespaces = namespaces;
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> n = fields.next();
            if (n.getValue().isValueNode() && !n.getValue().isArray()) {
                this.children.add(new ContextNode(this, n.getKey(), n.getValue().asText()));
                continue;
            }
            if (n.getValue().isArray()) {
                ArrayNode arrayNode = (ArrayNode)n.getValue();
                this.children.add(new ContextNode(this, n.getKey(), arrayNode));
                continue;
            }
            this.children.add(new ContextNode(this, n.getKey(), n.getValue().fields()));
        }
    }

    public ContextNode(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    private void sort() {
        HashNodeComparator comparator = new HashNodeComparator(this);
        if (!this.children.isEmpty()) {
            this.children.sort(comparator);
        }
    }

    public String toShortenedString() {
        return (this.epcisFieldsPreHashBuilder() + String.join((CharSequence)"", this.userExtensionsPreHashBuilder())).trim();
    }

    private String epcisFieldsPreHashBuilder() {
        if (this.children.isEmpty() && this.getName() != null && this.getValue() != null && TemplateNodeMap.isEpcisField(this)) {
            StringBuilder preHashBuilder = new StringBuilder();
            if (Boolean.TRUE.equals(this.isIlmdPath(this))) {
                preHashBuilder.append(this.userExtensionsFormatter(this.name, this.value)).append("\n");
            } else {
                preHashBuilder.append(this.epcisFieldFormatter(this.getName(), this.getValue(), this.findParent(this))).append("\n");
            }
            return preHashBuilder.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.fieldName(this));
        this.sort();
        for (ContextNode node : this.children) {
            String s = node.epcisFieldsPreHashBuilder();
            if (s.isEmpty()) continue;
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    private String fieldName(ContextNode node) {
        if (Boolean.TRUE.equals(this.isIlmdPath(node))) {
            return this.userExtensionsFormatter(node.getName(), node.getValue()) + "\n";
        }
        if (node.getName() != null && TemplateNodeMap.isEpcisField(node)) {
            if (ConstantEventHashInfo.DUPLICATE_ENTRY_CHECK.stream().noneMatch(node.getName()::equals) && node.getChildren() != null && !node.getChildren().isEmpty() && node.getChildren().get(0).getName() != null && !node.getChildren().get(0).getName().equalsIgnoreCase("sensorReport")) {
                return node.getName() + "\n";
            }
        }
        if (node.getName() != null && TemplateNodeMap.isEpcisField(node) && node.getChildren() != null && !node.getChildren().isEmpty() && node.getChildren().get(0).getName() == null) {
            if (ConstantEventHashInfo.IGNORE_FIELDS.stream().noneMatch(this.getName()::equals)) {
                return node.getName() + "\n";
            }
        }
        return "";
    }

    private Boolean isIlmdPath(ContextNode node) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        path.push(node.getName() != null ? node.getName() : "");
        for (ContextNode fieldParent = node.getParent(); fieldParent != null && fieldParent.getName() != null; fieldParent = fieldParent.getParent()) {
            path.push(fieldParent.getName());
        }
        return path.contains("ilmd");
    }

    private String findParent(ContextNode node) {
        String parentFieldName = node.getName();
        for (ContextNode parentNode = node.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
            parentFieldName = parentNode.getName() != null && !parentNode.getName().equals("") ? parentNode.getName() : parentFieldName;
        }
        return parentFieldName;
    }

    private String userExtensionsPreHashBuilder() {
        if (this.children.isEmpty() && this.getName() != null && this.getValue() != null && (!TemplateNodeMap.isEpcisField(this) || TemplateNodeMap.addExtensionWrapperTag(this)) && !ConstantEventHashInfo.IGNORE_FIELDS.contains(this.getName())) {
            return this.userExtensionsFormatter(this.name, this.value) + "\n";
        }
        StringBuilder sb = new StringBuilder();
        if (!(this.getName() == null || TemplateNodeMap.isEpcisField(this) && !TemplateNodeMap.addExtensionWrapperTag(this) || ConstantEventHashInfo.IGNORE_FIELDS.contains(this.getName()))) {
            sb.append(this.userExtensionsFormatter(this.getName(), this.getValue())).append("\n");
        }
        this.sort();
        for (ContextNode node : this.children) {
            String childExtension = node.userExtensionsPreHashBuilder();
            if (childExtension.isEmpty()) continue;
            sb.append(childExtension).append("\n");
        }
        return sb.toString();
    }

    private String epcisFieldFormatter(String name, String value, String parentFieldName) {
        block17: {
            block16: {
                if (ConstantEventHashInfo.IGNORE_FIELDS.stream().anyMatch(name::startsWith)) {
                    return null;
                }
                if (ConstantEventHashInfo.EPC_LISTS.contains(name)) {
                    if (value.startsWith("urn:epc:id:")) {
                        return "epc=" + ConverterUtil.toURI((String)value);
                    }
                    return "epc=" + value;
                }
                if (ConstantEventHashInfo.CLASS_IDENTIFIER_URN_FORMAT.stream().anyMatch(value::startsWith)) {
                    return name + "=" + ConverterUtil.toURIForClassLevelIdentifier((String)value);
                }
                if (ConstantEventHashInfo.EVENT_TIME.contains(name)) {
                    return name + "=" + ConstantEventHashInfo.DATE_FORMATTER.format(Instant.parse(value));
                }
                if (ConstantEventHashInfo.CBV_STRING_TYPE.stream().anyMatch(value::startsWith)) {
                    return name + "=" + ConverterUtil.toWebURIVocabulary((String)value);
                }
                if (ConstantEventHashInfo.BARE_STRING_FIELD_PARENT_CHILD.containsKey((Object)parentFieldName)) {
                    if (ConstantEventHashInfo.BARE_STRING_FIELD_PARENT_CHILD.get((Object)parentFieldName).stream().anyMatch(name::equals)) {
                        return name + "=" + ConverterUtil.toCbvVocabulary((String)value, (String)parentFieldName, (String)"WebURI");
                    }
                }
                if (name.startsWith("correctiveEventIDs")) {
                    return "correctiveEventID=" + value;
                }
                if (ConstantEventHashInfo.SOURCE_DESTINATION_URN_FORMAT.stream().anyMatch(value::startsWith)) {
                    return name + "=" + ConverterUtil.toURI((String)value);
                }
                if (value.startsWith("urn:epc:id:")) break block16;
                if (!ConstantEventHashInfo.CLASS_IDENTIFIER_URN_FORMAT.stream().anyMatch(value::startsWith)) break block17;
            }
            return name + "=" + ConverterUtil.toURI((String)value);
        }
        if (value.startsWith("gs1:")) {
            return name + "=" + value.substring(value.indexOf("gs1:") + 4);
        }
        if (ConstantEventHashInfo.EPCIS_EVENT_TYPES.stream().anyMatch(value::equals)) {
            return "eventType=" + value;
        }
        if (value.equals("")) {
            return name;
        }
        return name + "=" + value;
    }

    private String userExtensionsFormatter(String name, String value) {
        String nameSpace;
        String string = nameSpace = name.contains(":") ? this.namespaces.get(name.substring(0, name.indexOf(":"))) : null;
        if (nameSpace != null && value != null && !value.equals("")) {
            return "{" + nameSpace + "}" + name.substring(name.indexOf(":") + 1) + "=" + value;
        }
        if (nameSpace != null) {
            return "{" + nameSpace + "}" + name.substring(name.indexOf(":") + 1);
        }
        if (value != null && !value.equals("")) {
            return name + "=" + value;
        }
        return name;
    }

    public String toString() {
        return this.name + ":" + Objects.requireNonNullElseGet(this.value, () -> this.children.stream().map(e -> e.getValue() + " " + String.join((CharSequence)",", new CharSequence[0])).collect(Collectors.toList()));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public ArrayList<ContextNode> getChildren() {
        return this.children;
    }

    public ContextNode getParent() {
        return this.parent;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setChildren(ArrayList<ContextNode> children) {
        this.children = children;
    }

    public void setParent(ContextNode parent) {
        this.parent = parent;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }
}

