/*
 * Decompiled with CFR 0.152.
 */
package io.openepcis.epc.eventhash;

import com.fasterxml.jackson.databind.JsonNode;
import io.openepcis.epc.eventhash.ContextNode;
import io.openepcis.epc.eventhash.HashIdGenerator;
import io.openepcis.epc.eventhash.SaxHandler;
import io.openepcis.epc.eventhash.publisher.ObjectNodePublisher;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class EventHashGenerator {
    private final SAXParserFactory factory = SAXParserFactory.newInstance();

    public EventHashGenerator() throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        this.factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    }

    public Multi<String> jsonDocumentHashIdGenerator(InputStream jsonStream, String hashAlgorithm) throws IOException {
        ObjectNodePublisher publisher = new ObjectNodePublisher(jsonStream);
        HashMap contextHeader = new HashMap();
        return Multi.createFrom().publisher(publisher).map(item -> {
            if (!item.get("type").asText().equalsIgnoreCase("EPCISDocument")) {
                ContextNode contextNode = new ContextNode(item.fields(), contextHeader);
                String preHashString = contextNode.toShortenedString();
                try {
                    return HashIdGenerator.generateHashId(preHashString.replaceAll("[\n\r]", ""), hashAlgorithm) + "\n";
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            } else if (item.get("@context") != null) {
                Iterator contextElements = item.get("@context").elements();
                while (contextElements.hasNext()) {
                    Iterator contextFields = ((JsonNode)contextElements.next()).fields();
                    while (contextFields.hasNext()) {
                        Map.Entry namespace = (Map.Entry)contextFields.next();
                        contextHeader.put((String)namespace.getKey(), ((JsonNode)namespace.getValue()).textValue());
                    }
                }
            }
            return "";
        }).filter(s -> !s.isEmpty());
    }

    public Multi<String> xmlDocumentHashIdGenerator(InputStream xmlStream, String hashAlgorithm) {
        SaxHandler saxHandler = new SaxHandler();
        Consumer<MultiEmitter> consumer = contextNodeMultiEmitter -> {
            saxHandler.setEmitter((MultiEmitter<? super ContextNode>)contextNodeMultiEmitter);
            try {
                this.factory.newSAXParser().parse(xmlStream, (DefaultHandler)saxHandler);
            }
            catch (Exception e) {
                contextNodeMultiEmitter.fail((Throwable)e);
            }
        };
        return Multi.createFrom().emitter(consumer).map(node -> {
            try {
                return HashIdGenerator.generateHashId(node.toShortenedString().replaceAll("[\n\r]", ""), hashAlgorithm) + "\n";
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return "";
            }
        }).filter(s -> !s.isEmpty());
    }
}

