/*
 * Decompiled with CFR 0.152.
 */
package io.openepcis.epc.eventhash;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public class HashIdGenerator {
    public static String generateHashId(String preHashString, String hashAlgorithm) throws NoSuchAlgorithmException {
        StringBuilder hashId = new StringBuilder();
        switch (hashAlgorithm.toLowerCase()) {
            case "sha-1": {
                hashId.append("ni:///sha-1;");
                byte[] digest = MessageDigest.getInstance("SHA-1").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "sha-224": {
                hashId.append("ni:///sha-224;");
                byte[] digest = MessageDigest.getInstance("SHA-224").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "sha-384": {
                hashId.append("ni:///sha-384;");
                byte[] digest = MessageDigest.getInstance("SHA-384").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "sha-512": {
                hashId.append("ni:///sha-512;");
                byte[] digest = MessageDigest.getInstance("SHA-512").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "sha3-224": {
                hashId.append("ni:///sha3-224;");
                byte[] digest = MessageDigest.getInstance("SHA3-224").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "sha3-256": {
                hashId.append("ni:///sha3-256;");
                byte[] digest = MessageDigest.getInstance("SHA3-256").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "sha3-384": {
                hashId.append("ni:///sha3-384;");
                byte[] digest = MessageDigest.getInstance("SHA3-384").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "sha3-512": {
                hashId.append("ni:///sha3-512;");
                byte[] digest = MessageDigest.getInstance("SHA3-512").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "md2": {
                hashId.append("ni:///md2;");
                byte[] digest = MessageDigest.getInstance("MD2").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            case "md5": {
                hashId.append("ni:///md5;");
                byte[] digest = MessageDigest.getInstance("MD5").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                break;
            }
            default: {
                hashId.append("ni:///sha-256;");
                byte[] digest = MessageDigest.getInstance("SHA-256").digest(preHashString.getBytes(StandardCharsets.UTF_8));
                hashId.append(DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
            }
        }
        return hashId.append("?ver=CBV2.0").toString();
    }

    private HashIdGenerator() {
    }
}

