/*
 * Decompiled with CFR 0.152.
 */
package io.openepcis.epc.eventhash;

import io.openepcis.epc.eventhash.ContextNode;
import io.openepcis.epc.eventhash.TemplateNodeMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class HashNodeComparator
implements Comparator<ContextNode> {
    private final List<String> sortMap;

    HashNodeComparator(ContextNode jsonNode) {
        this.sortMap = TemplateNodeMap.findSortList(jsonNode);
    }

    @Override
    public int compare(ContextNode o1, ContextNode o2) {
        if (o1.getName() != null && o2.getName() != null) {
            int result;
            int o1Index = Integer.MAX_VALUE;
            int o2Index = Integer.MAX_VALUE;
            if (o1.getParent() != null && o2.getParent() != null) {
                o1Index = this.sortMap.indexOf(o1.getName());
                o2Index = this.sortMap.indexOf(o2.getName());
            }
            if ((result = Integer.compare(o1Index, o2Index)) == 0 && o1Index == -1 && o2Index == -1) {
                if (o1.getName() != null && o2.getName() != null) {
                    return o1.getName().compareTo(o2.getName());
                }
            } else if (result == 0) {
                if (o1.getValue() != null && o2.getValue() != null) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                if (o1.getChildren() != null && o2.getChildren() != null) {
                    return this.findChildren(o1.getChildren()).compareTo(this.findChildren(o2.getChildren()));
                }
            } else {
                if (o1Index == -1) {
                    return 1;
                }
                if (o2Index == -1) {
                    return -1;
                }
                return result;
            }
        }
        return 0;
    }

    private String findChildren(ArrayList<ContextNode> children) {
        StringBuilder childrenString = new StringBuilder();
        if (children != null) {
            children.forEach(child -> {
                if (child != null && child.getValue() == null) {
                    childrenString.append(this.findChildren(child.getChildren()));
                } else if (child != null && child.getValue() != null) {
                    childrenString.append(child.getValue());
                }
            });
        }
        return childrenString.toString();
    }
}

