/*
 * Decompiled with CFR 0.152.
 */
package io.openepcis.epc.eventhash;

import io.openepcis.epc.eventhash.ConstantEventHashInfo;
import io.openepcis.epc.eventhash.ContextNode;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxHandler
extends DefaultHandler {
    private final Deque<String> path = new ArrayDeque<String>();
    private final StringBuilder currentValue = new StringBuilder();
    private ContextNode currentNode = null;
    private ContextNode rootNode = null;
    private Map<String, String> currentAttributes;
    private final HashMap<String, String> contextHeader = new HashMap();
    private MultiEmitter<? super ContextNode> emitter;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.path.push(qName);
        this.currentAttributes = new HashMap<String, String>();
        String p = this.path();
        if (attributes.getLength() > 0) {
            for (int att = 0; att < attributes.getLength(); ++att) {
                if (attributes.getQName(att).contains(":") && attributes.getQName(att).startsWith("xmlns:")) {
                    this.contextHeader.put(attributes.getQName(att).substring(attributes.getQName(att).indexOf(":") + 1), attributes.getValue(att));
                    continue;
                }
                this.currentAttributes.put(attributes.getQName(att), attributes.getValue(att).trim());
            }
        }
        if (this.rootNode == null && ConstantEventHashInfo.EPCIS_EVENT_TYPES.contains(qName)) {
            this.currentNode = this.rootNode = new ContextNode(this.contextHeader);
            this.rootNode.children.add(new ContextNode(this.rootNode, "type", qName));
            return;
        }
        if (this.currentNode != null) {
            if (ConstantEventHashInfo.WHY_DIMENSION_XML_PATH.stream().anyMatch(p::startsWith)) {
                ContextNode n = new ContextNode(this.currentNode, null, (String)null);
                this.currentNode.children.add(n);
                this.currentNode = n;
                return;
            }
        }
        if (this.currentNode == null) return;
        if (!ConstantEventHashInfo.WHAT_DIMENSION_XML_PATH.stream().noneMatch(p::startsWith)) return;
        ContextNode n = new ContextNode(this.currentNode, qName, (String)null);
        this.currentNode.children.add(n);
        this.currentNode = n;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.rootNode != null && !ConstantEventHashInfo.XML_IGNORE_FIELDS.contains(qName)) {
            this.xmlParser(qName);
        }
        if (ConstantEventHashInfo.EPCIS_EVENT_TYPES.contains(qName)) {
            this.emitter.emit((Object)this.rootNode);
            this.rootNode = null;
        }
        this.currentValue.setLength(0);
        this.path.pop();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void xmlParser(String qName) {
        String p = this.path();
        String value = !this.currentValue.toString().trim().equals("") ? this.currentValue.toString().trim() : null;
        if (ConstantEventHashInfo.WHAT_DIMENSION_XML_PATH.stream().anyMatch(p::startsWith)) {
            this.currentNode.children.add(new ContextNode(this.currentNode, this.path.peek(), value));
            return;
        }
        if (!ConstantEventHashInfo.WHY_DIMENSION_XML_PATH.stream().anyMatch(p::startsWith)) {
            if (!ConstantEventHashInfo.HOW_DIMENSION_XML_PATH.stream().anyMatch(p::startsWith)) {
                if (this.currentNode == null) return;
                this.currentNode.setValue(value);
                this.currentNode = this.currentNode.parent;
                return;
            }
        }
        if (this.currentAttributes.size() > 0) {
            for (Map.Entry<String, String> attribute : this.currentAttributes.entrySet()) {
                this.currentNode.children.add(new ContextNode(this.currentNode, attribute.getKey(), attribute.getValue()));
            }
            this.currentNode.children.add(new ContextNode(this.currentNode, qName, value));
        }
        this.currentNode = this.currentNode.parent;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.emitter.complete();
    }

    private String path() {
        return String.join((CharSequence)"/", this.path);
    }

    public void setEmitter(MultiEmitter<? super ContextNode> emitter) {
        this.emitter = emitter;
    }
}

