/*
 * Decompiled with CFR 0.152.
 */
package io.openepcis.epc.eventhash;

import io.openepcis.epc.eventhash.ConstantEventHashInfo;
import io.openepcis.epc.eventhash.ContextNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class TemplateNodeMap
extends LinkedHashMap<String, Object> {
    private static final TemplateNodeMap _INSTANCE = new TemplateNodeMap();

    public static TemplateNodeMap getInstance() {
        return _INSTANCE;
    }

    public static List<String> findSortList(ContextNode node) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        if (node.getName() != null) {
            path.push(node.getName());
        }
        for (ContextNode parent = node.getParent(); parent != null && parent.getName() != null; parent = parent.getParent()) {
            path.push(parent.getName());
        }
        if (path.isEmpty()) {
            return new ArrayList<String>(TemplateNodeMap.getInstance().keySet());
        }
        HashMap entry = null;
        String s = (String)path.pop();
        while (s != null) {
            if (entry == null) {
                entry = (LinkedHashMap)TemplateNodeMap.getInstance().get(s);
            } else if (((LinkedHashMap)entry).get(s) != null) {
                entry = (LinkedHashMap)((LinkedHashMap)entry).get(s);
            }
            if (!path.isEmpty()) {
                s = (String)path.pop();
                continue;
            }
            s = null;
        }
        if (entry != null && !entry.isEmpty()) {
            return new ArrayList<String>(((LinkedHashMap)entry).keySet());
        }
        return Collections.emptyList();
    }

    public static boolean isEpcisField(ContextNode node) {
        Deque<String> path = TemplateNodeMap.pathFinder(node);
        if (Boolean.TRUE.equals(TemplateNodeMap.isIlmdField(path))) {
            return true;
        }
        LinkedHashMap current = TemplateNodeMap.getInstance();
        int found = 0;
        Iterator<String> iter = path.iterator();
        while (iter.hasNext() && current != null) {
            String key = iter.next();
            if (current.containsKey(key)) {
                ++found;
                current = (LinkedHashMap)current.get(key);
                continue;
            }
            current = null;
        }
        return found == path.size() && !path.isEmpty() || node.getName() != null && ConstantEventHashInfo.LIST_OF_OBJECTS.containsValue(node.getName());
    }

    private static Deque<String> pathFinder(ContextNode node) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        path.push(node.getName() != null ? node.getName() : "");
        for (ContextNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent.getName() == null || path.contains(parent.getName()) || ConstantEventHashInfo.LIST_OF_OBJECTS.containsValue(parent.getName()) && !"sensorReport".equals(parent.getName()))) {
                path.push(parent.getName());
                continue;
            }
            if (parent.getParent() == null || parent.getParent().getName() == null || ConstantEventHashInfo.LIST_OF_OBJECTS.containsValue(parent.getParent().getName()) && !"sensorReport".equals(parent.getParent().getName())) continue;
            path.push(parent.getParent().getName());
        }
        return path;
    }

    public static boolean addExtensionWrapperTag(ContextNode node) {
        if (node.getName() != null && TemplateNodeMap.isEpcisField(node)) {
            if (ConstantEventHashInfo.USER_EXTENSION_WRAPPER.stream().anyMatch(node.getName()::equals)) {
                AtomicReference<Integer> found = new AtomicReference<Integer>(0);
                node.getChildren().forEach((? super E sensorChild) -> {
                    if (TemplateNodeMap.addExtensionWrapperTag(sensorChild)) {
                        found.set((Integer)found.get() + 1);
                    }
                });
                return found.get() > 0;
            }
            AtomicReference<Integer> found = new AtomicReference<Integer>(0);
            node.getChildren().forEach((? super E element) -> {
                if (element.getName() != null && !TemplateNodeMap.isEpcisField(element)) {
                    found.set((Integer)found.get() + 1);
                }
            });
            return found.get() > 0;
        }
        return false;
    }

    private static Boolean isIlmdField(Deque<String> key) {
        return key.contains("ilmd");
    }

    private TemplateNodeMap() {
        this.put("type", new LinkedHashMap());
        this.put("eventTime", new LinkedHashMap());
        this.put("eventTimeZoneOffset", new LinkedHashMap());
        LinkedHashMap errorCorrectiveId = new LinkedHashMap();
        errorCorrectiveId.put("correctiveEventID", new LinkedHashMap());
        LinkedHashMap errorDeclaration = new LinkedHashMap();
        errorDeclaration.put("declarationTime", new LinkedHashMap());
        errorDeclaration.put("reason", new LinkedHashMap());
        errorDeclaration.put("correctiveEventIDs", errorCorrectiveId);
        this.put("errorDeclaration", errorDeclaration);
        LinkedHashMap instanceIdentifier = new LinkedHashMap();
        instanceIdentifier.put("epc", new LinkedHashMap());
        this.put("epcList", instanceIdentifier);
        this.put("parentID", new LinkedHashMap());
        this.put("inputEPCList", instanceIdentifier);
        this.put("childEPCs", instanceIdentifier);
        LinkedHashMap classIdentifier = new LinkedHashMap();
        classIdentifier.put("epcClass", new LinkedHashMap());
        classIdentifier.put("quantity", new LinkedHashMap());
        classIdentifier.put("uom", new LinkedHashMap());
        this.put("quantityList", classIdentifier);
        this.put("childQuantityList", classIdentifier);
        this.put("inputQuantityList", classIdentifier);
        this.put("outputEPCList", instanceIdentifier);
        this.put("outputQuantityList", classIdentifier);
        this.put("action", new LinkedHashMap());
        this.put("transformationID", new LinkedHashMap());
        this.put("bizStep", new LinkedHashMap());
        this.put("disposition", new LinkedHashMap());
        LinkedHashMap persistentDisposition = new LinkedHashMap();
        persistentDisposition.put("set", new LinkedHashMap());
        persistentDisposition.put("unset", new LinkedHashMap());
        this.put("persistentDisposition", persistentDisposition);
        LinkedHashMap readPoint = new LinkedHashMap();
        readPoint.put("id", new LinkedHashMap());
        this.put("readPoint", readPoint);
        LinkedHashMap bizLocation = new LinkedHashMap();
        bizLocation.put("id", new LinkedHashMap());
        this.put("bizLocation", bizLocation);
        LinkedHashMap bizTransactionList = new LinkedHashMap();
        bizTransactionList.put("bizTransaction", new LinkedHashMap());
        bizTransactionList.put("type", new LinkedHashMap());
        this.put("bizTransactionList", bizTransactionList);
        LinkedHashMap sourceList = new LinkedHashMap();
        sourceList.put("source", new LinkedHashMap());
        sourceList.put("type", new LinkedHashMap());
        this.put("sourceList", sourceList);
        LinkedHashMap destinationList = new LinkedHashMap();
        destinationList.put("destination", new LinkedHashMap());
        destinationList.put("type", new LinkedHashMap());
        this.put("destinationList", destinationList);
        LinkedHashMap sensorMetadata = new LinkedHashMap();
        sensorMetadata.put("time", new LinkedHashMap());
        sensorMetadata.put("startTime", new LinkedHashMap());
        sensorMetadata.put("endTime", new LinkedHashMap());
        sensorMetadata.put("deviceID", new LinkedHashMap());
        sensorMetadata.put("deviceMetadata", new LinkedHashMap());
        sensorMetadata.put("rawData", new LinkedHashMap());
        sensorMetadata.put("dataProcessingMethod", new LinkedHashMap());
        sensorMetadata.put("bizRules", new LinkedHashMap());
        LinkedHashMap sensorReport = new LinkedHashMap();
        sensorReport.put("type", new LinkedHashMap());
        sensorReport.put("deviceID", new LinkedHashMap());
        sensorReport.put("deviceMetadata", new LinkedHashMap());
        sensorReport.put("rawData", new LinkedHashMap());
        sensorReport.put("dataProcessingMethod", new LinkedHashMap());
        sensorReport.put("time", new LinkedHashMap());
        sensorReport.put("microorganism", new LinkedHashMap());
        sensorReport.put("chemicalSubstance", new LinkedHashMap());
        sensorReport.put("value", new LinkedHashMap());
        sensorReport.put("component", new LinkedHashMap());
        sensorReport.put("stringValue", new LinkedHashMap());
        sensorReport.put("booleanValue", new LinkedHashMap());
        sensorReport.put("hexBinaryValue", new LinkedHashMap());
        sensorReport.put("uriValue", new LinkedHashMap());
        sensorReport.put("minValue", new LinkedHashMap());
        sensorReport.put("maxValue", new LinkedHashMap());
        sensorReport.put("meanValue", new LinkedHashMap());
        sensorReport.put("sDev", new LinkedHashMap());
        sensorReport.put("percRank", new LinkedHashMap());
        sensorReport.put("percValue", new LinkedHashMap());
        sensorReport.put("uom", new LinkedHashMap());
        LinkedHashMap sensorElementList = new LinkedHashMap();
        sensorElementList.put("sensorMetadata", sensorMetadata);
        sensorElementList.put("sensorReport", sensorReport);
        this.put("sensorElementList", sensorElementList);
        this.put("ilmd", new LinkedHashMap());
    }
}

