/*
 * Decompiled with CFR 0.152.
 */
package io.openepcis.epc.eventhash.publisher;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.openepcis.epc.eventhash.publisher.ObjectNodeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ObjectNodePublisher<T extends ObjectNode>
implements Publisher<T> {
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final ObjectNode header = mapper.createObjectNode();
    private final JsonParser jsonParser;
    private final AtomicBoolean headerSent = new AtomicBoolean(false);
    private final AtomicBoolean inEventList = new AtomicBoolean(false);
    private final AtomicBoolean ignoreEventList = new AtomicBoolean(false);
    private final AtomicLong nodeCount = new AtomicLong();
    private final AtomicReference<ObjectNodeSubscription> subscription = new AtomicReference();
    private JsonToken token;

    public ObjectNodePublisher(InputStream in) throws IOException {
        this.jsonParser = jsonFactory.createParser(in);
        this.jsonParser.setCodec((ObjectCodec)mapper);
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        this.subscription.set(new ObjectNodeSubscription(subscriber));
        Optional<Throwable> throwable = this.beginParsing();
        subscriber.onSubscribe((Subscription)this.subscription.get());
        throwable.ifPresent(arg_0 -> subscriber.onError(arg_0));
    }

    private Optional<Throwable> beginParsing() {
        try {
            this.jsonParser.setCodec((ObjectCodec)mapper);
            this.token = this.jsonParser.nextToken();
            while (this.token != null && this.token != JsonToken.END_OBJECT) {
                JsonNode o;
                String fieldName = this.jsonParser.nextFieldName();
                this.token = this.jsonParser.nextToken();
                if ("eventList".equals(fieldName)) {
                    if (this.token != JsonToken.START_ARRAY) {
                        throw new IOException("invalid eventList structure, must be an array");
                    }
                    this.token = this.jsonParser.nextToken();
                    this.inEventList.getAndSet(true);
                    return Optional.empty();
                }
                if ("epcisBody".equals(fieldName) || fieldName == null || (o = (JsonNode)this.jsonParser.readValueAsTree()) == null) continue;
                this.header.set(fieldName, o);
            }
            if (this.token == null) {
                this.jsonParser.close();
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public boolean isEventListIgnored() {
        return this.ignoreEventList.get();
    }

    public class ObjectNodeSubscription
    implements Subscription {
        private final AtomicBoolean isTerminated = new AtomicBoolean(false);
        private final AtomicLong demand = new AtomicLong();
        private final AtomicReference<Subscriber<? super T>> subscriber;

        private ObjectNodeSubscription(Subscriber<? super T> subscriber) {
            if (subscriber == null) {
                throw new NullPointerException("subscriber must not be null");
            }
            this.subscriber = new AtomicReference(subscriber);
        }

        public void request(long l) {
            block6: {
                if (l <= 0L && !this.terminate()) {
                    this.subscriber.get().onError((Throwable)new IllegalArgumentException("negative subscription request"));
                    return;
                }
                if (this.demand.get() > 0L) {
                    this.demand.getAndAdd(l);
                    return;
                }
                this.demand.getAndAdd(l);
                try {
                    while (this.demand.get() > 0L && !this.isTerminated()) {
                        long count = this.readNext(this.demand.get());
                        if (count >= 0L) {
                            this.demand.getAndAdd(-1L * count);
                            ObjectNodePublisher.this.nodeCount.getAndAdd(count);
                            continue;
                        }
                        if (this.terminate()) continue;
                        this.subscriber.get().onComplete();
                        return;
                    }
                }
                catch (Exception ex) {
                    if (this.terminate()) break block6;
                    this.subscriber.get().onError((Throwable)ex);
                }
            }
        }

        public void cancel() {
            this.terminate();
            this.subscriber.set(null);
        }

        private boolean terminate() {
            return this.isTerminated.getAndSet(true);
        }

        private boolean isTerminated() {
            return this.isTerminated.get();
        }

        private long readNext(long requested) throws IOException {
            long l = this.publishValidHeaderNode(requested);
            l += this.readEventList(requested - l);
            return (l += this.processEOF(requested - l)) > 0L || this.isTokenAvailable() ? l : -1L;
        }

        private long readEventList(long requested) throws IOException {
            if (!ObjectNodePublisher.this.inEventList.get() || requested == 0L) {
                return 0L;
            }
            while (ObjectNodePublisher.this.isEventListIgnored() && this.isTokenAvailable()) {
                if (ObjectNodePublisher.this.token == JsonToken.END_ARRAY) {
                    return 0L;
                }
                ObjectNodePublisher.this.token = ObjectNodePublisher.this.jsonParser.nextToken();
            }
            long l = 0L;
            while (!ObjectNodePublisher.this.isEventListIgnored() && this.isTokenAvailable() && ObjectNodePublisher.this.token == JsonToken.START_OBJECT && l < requested) {
                JsonNode o = (JsonNode)ObjectNodePublisher.this.jsonParser.readValueAsTree();
                if (o.has("type")) {
                    ++l;
                    this.subscriber.get().onNext((Object)((ObjectNode)o));
                }
                ObjectNodePublisher.this.token = ObjectNodePublisher.this.jsonParser.nextToken();
            }
            if (ObjectNodePublisher.this.token == JsonToken.END_ARRAY) {
                ObjectNodePublisher.this.inEventList.getAndSet(false);
                ObjectNodePublisher.this.jsonParser.nextToken();
                ObjectNodePublisher.this.token = ObjectNodePublisher.this.jsonParser.nextToken();
            }
            return l;
        }

        private long publishValidHeaderNode(long requested) {
            if (requested > 0L && !ObjectNodePublisher.this.headerSent.get() && (!this.isTokenAvailable() && ObjectNodeUtil.isValidEPCISDocumentNode(ObjectNodePublisher.this.header) || this.isTokenAvailable() && ObjectNodePublisher.this.nodeCount.get() == 0L && ObjectNodeUtil.isValidEPCISDocumentNode(ObjectNodePublisher.this.header))) {
                ObjectNodePublisher.this.headerSent.getAndSet(true);
                this.subscriber.get().onNext((Object)ObjectNodePublisher.this.header);
                return 1L;
            }
            return 0L;
        }

        private synchronized long processEOF(long requested) throws IOException {
            if (requested == 0L) {
                return 0L;
            }
            if (this.isTokenAvailable() && ObjectNodePublisher.this.token == JsonToken.END_OBJECT || ObjectNodePublisher.this.token == JsonToken.END_ARRAY || ObjectNodePublisher.this.token == JsonToken.FIELD_NAME) {
                this.appendHeaderFields();
                ObjectNodePublisher.this.token = ObjectNodePublisher.this.jsonParser.nextToken();
            }
            return this.publishValidHeaderNode(requested);
        }

        private void appendHeaderFields() throws IOException {
            while (this.isTokenAvailable() && ObjectNodePublisher.this.token != JsonToken.END_OBJECT) {
                if (!ObjectNodePublisher.this.headerSent.get()) {
                    String fieldName = ObjectNodePublisher.this.jsonParser.nextFieldName();
                    JsonNode j = (JsonNode)ObjectNodePublisher.this.jsonParser.readValueAsTree();
                    if (j != null) {
                        ObjectNodePublisher.this.header.set(fieldName != null ? fieldName : ObjectNodePublisher.this.jsonParser.getCurrentName(), j);
                    }
                }
                ObjectNodePublisher.this.token = ObjectNodePublisher.this.jsonParser.nextToken();
            }
        }

        private boolean isTokenAvailable() {
            return !ObjectNodePublisher.this.jsonParser.isClosed();
        }
    }
}

