/*
 * Decompiled with CFR 0.152.
 */
package io.opengemini.client.jdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.opengemini.client.api.AuthConfig;
import io.opengemini.client.api.AuthType;
import io.opengemini.client.api.BaseConfiguration;
import io.opengemini.client.api.OpenGeminiException;
import io.opengemini.client.api.Pong;
import io.opengemini.client.api.Query;
import io.opengemini.client.api.QueryResult;
import io.opengemini.client.api.TlsConfig;
import io.opengemini.client.common.BaseAsyncClient;
import io.opengemini.client.common.JacksonService;
import io.opengemini.client.jdk.Configuration;
import io.opengemini.client.jdk.SslContextUtil;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class OpenGeminiJdkClient
extends BaseAsyncClient {
    private final Configuration conf;
    private final HttpClient client;

    public OpenGeminiJdkClient(@NotNull Configuration conf) {
        super((BaseConfiguration)conf);
        AuthType authType;
        AuthConfig authConfig;
        this.conf = conf;
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(conf.getConnectTimeout()).version(HttpClient.Version.HTTP_1_1);
        if (conf.isTlsEnabled()) {
            TlsConfig tlsConfig = conf.getTlsConfig();
            builder = builder.sslContext(SslContextUtil.buildSSLContextFromJks(tlsConfig.keyStorePath, tlsConfig.keyStorePassword, tlsConfig.trustStorePath, tlsConfig.trustStorePassword, tlsConfig.verifyDisabled));
        }
        if ((authConfig = conf.getAuthConfig()) != null && AuthType.PASSWORD.equals((Object)(authType = authConfig.getAuthType()))) {
            builder.authenticator(this.getAuthenticator(authConfig.getUsername(), String.valueOf(authConfig.getPassword())));
        }
        this.client = builder.build();
    }

    private Authenticator getAuthenticator(final String username, final String password) {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        };
    }

    protected CompletableFuture<QueryResult> executeQuery(Query query) {
        String queryUrl = this.getQueryUrl(query);
        return this.httpExecute(queryUrl, QueryResult.class);
    }

    protected CompletableFuture<QueryResult> executePostQuery(Query query) {
        String queryUrl = this.getQueryUrl(query);
        return this.httpExecute(queryUrl, QueryResult.class, "POST");
    }

    protected CompletableFuture<Void> executeWrite(String database, String lineProtocol) {
        String writeUrl = this.getWriteUrl(database);
        return this.httpExecute(writeUrl, Void.class, "POST", HttpRequest.BodyPublishers.ofString(lineProtocol));
    }

    protected CompletableFuture<Pong> executePing() {
        String pingUrl = this.getPingUrl();
        return ((CompletableFuture)this.get(pingUrl).thenApply(response -> response.headers().firstValue("X-Geminidb-Version").orElse(null))).thenApply(Pong::new);
    }

    private <T> CompletableFuture<T> httpExecute(String url, Class<T> type) {
        return this.httpExecute(url, type, "GET");
    }

    private <T> CompletableFuture<T> httpExecute(String url, Class<T> type, String method) {
        return this.httpExecute(url, type, method, HttpRequest.BodyPublishers.noBody());
    }

    private <T> CompletableFuture<T> httpExecute(String url, Class<T> type, String method, HttpRequest.BodyPublisher bodyPublisher) {
        CompletableFuture<HttpResponse<String>> future;
        if ("GET".equals(method)) {
            future = this.get(url);
        } else if ("POST".equals(method)) {
            future = this.post(url, bodyPublisher);
        } else {
            RuntimeException e = new RuntimeException("not support method:" + method);
            return CompletableFuture.failedFuture(e);
        }
        return future.thenCompose(response -> {
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                try {
                    Object body = JacksonService.toObject((String)((String)response.body()), (Class)type);
                    return CompletableFuture.completedFuture(body);
                }
                catch (JsonProcessingException e) {
                    return CompletableFuture.failedFuture(e);
                }
            }
            return CompletableFuture.failedFuture((Throwable)new OpenGeminiException("http error: " + (String)response.body(), response.statusCode()));
        });
    }

    public CompletableFuture<HttpResponse<String>> get(String url) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.buildUri(url)).GET().timeout(this.conf.getTimeout()).build();
        return this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    public CompletableFuture<HttpResponse<String>> post(String url, HttpRequest.BodyPublisher bodyPublisher) {
        HttpRequest request = HttpRequest.newBuilder().uri(this.buildUri(url)).POST(bodyPublisher).timeout(this.conf.getTimeout()).build();
        return this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    private URI buildUri(String url) {
        return URI.create(this.nextUrlPrefix() + url);
    }

    protected String encode(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    public void close() {
    }
}

