/*
 * Decompiled with CFR 0.152.
 */
package io.opengemini.client.jdk;

import io.opengemini.client.common.InsecureTrustManager;
import io.opengemini.client.common.SslUtil;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SslContextUtil {
    public static SSLContext buildSSLContextFromJks(String keyStorePath, char[] keyStorePassword, String trustStorePath, char[] trustStorePassword, boolean disableSslVerify) {
        try {
            KeyManagerFactory keyManagerFactory = SslUtil.initKeyManagerFactory((String)keyStorePath, (char[])keyStorePassword);
            TrustManagerFactory trustManagerFactory = null;
            if (trustStorePath != null) {
                trustManagerFactory = SslUtil.initTrustManagerFactory((String)trustStorePath, (char[])trustStorePassword);
            }
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            TrustManager[] trustManagers = disableSslVerify ? new TrustManager[]{new InsecureTrustManager()} : (trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagers, new SecureRandom());
            if (disableSslVerify) {
                sslContext.getDefaultSSLParameters().setEndpointIdentificationAlgorithm(null);
            }
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

