package io.opengemini.client.okhttp;

import io.opengemini.client.api.BaseConfiguration;

public class Configuration extends BaseConfiguration {
    private ConnectionPoolConfig connectionPoolConfig;


    public static abstract class ConfigurationBuilder<C extends Configuration, B extends Configuration.ConfigurationBuilder<C, B>> extends BaseConfiguration.BaseConfigurationBuilder<C, B> {
        private ConnectionPoolConfig connectionPoolConfig;

        /**
         * @return {@code this}.
         */
        public B connectionPoolConfig(final ConnectionPoolConfig connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig;
            return self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Configuration.ConfigurationBuilder(super=" + super.toString() + ", connectionPoolConfig=" + this.connectionPoolConfig + ")";
        }
    }


    private static final class ConfigurationBuilderImpl extends Configuration.ConfigurationBuilder<Configuration, Configuration.ConfigurationBuilderImpl> {
        private ConfigurationBuilderImpl() {
        }

        @Override
        protected Configuration.ConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }
    }

    protected Configuration(final Configuration.ConfigurationBuilder<?, ?> b) {
        super(b);
        this.connectionPoolConfig = b.connectionPoolConfig;
    }

    public static Configuration.ConfigurationBuilder<?, ?> builder() {
        return new Configuration.ConfigurationBuilderImpl();
    }

    public ConnectionPoolConfig getConnectionPoolConfig() {
        return this.connectionPoolConfig;
    }

    public Configuration(final ConnectionPoolConfig connectionPoolConfig) {
        this.connectionPoolConfig = connectionPoolConfig;
    }
}
