package io.opengemini.client.okhttp;

import java.util.concurrent.TimeUnit;

public class ConnectionPoolConfig {
    private int maxIdleConnections = 5;
    private long keepAliveDuration = 5;
    private TimeUnit keepAliveTimeUnit = TimeUnit.MINUTES;

    public static ConnectionPoolConfig of(int maxIdleConnections, long keepAliveDuration, TimeUnit keepAliveTimeUnit) {
        ConnectionPoolConfig config = new ConnectionPoolConfig();
        config.setMaxIdleConnections(maxIdleConnections);
        config.setKeepAliveDuration(keepAliveDuration);
        config.setKeepAliveTimeUnit(keepAliveTimeUnit);
        return config;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public long getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public TimeUnit getKeepAliveTimeUnit() {
        return this.keepAliveTimeUnit;
    }

    public void setMaxIdleConnections(final int maxIdleConnections) {
        this.maxIdleConnections = maxIdleConnections;
    }

    public void setKeepAliveDuration(final long keepAliveDuration) {
        this.keepAliveDuration = keepAliveDuration;
    }

    public void setKeepAliveTimeUnit(final TimeUnit keepAliveTimeUnit) {
        this.keepAliveTimeUnit = keepAliveTimeUnit;
    }
}
