/*
 * Decompiled with CFR 0.152.
 */
package io.openk9.core.api.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Async {
    private static final String COMMON_NAME = "OPENK9_SINGLE_THREAD";
    private static final ExecutorService COMMON_EXECUTOR = Executors.newSingleThreadExecutor(r -> new Thread(r, COMMON_NAME));
    private static final Logger _log = LoggerFactory.getLogger((String)Async.class.getName());

    public static void run(Runnable runnable) {
        Async.run(runnable, false);
    }

    public static void await(Runnable runnable) {
        Async.run(runnable, true);
    }

    public static void run(Runnable runnable, boolean await) {
        block3: {
            CompletableFuture<Void> future = CompletableFuture.runAsync(runnable, COMMON_EXECUTOR);
            if (await) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    if (!_log.isErrorEnabled()) break block3;
                    _log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static <T> CompletableFuture<T> future(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, COMMON_EXECUTOR);
    }

    public static <T> T await(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, COMMON_EXECUTOR).join();
    }
}

