/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.java;

import io.openmanufacturing.sds.aspectmodel.java.ImportTracker;
import io.openmanufacturing.sds.aspectmodel.java.JavaCodeGenerationConfig;
import java.io.File;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class JavaCodeGenerationConfigBuilder {
    private boolean enableJacksonAnnotations;
    private String packageName;
    private ImportTracker importTracker;
    private boolean executeLibraryMacros;
    private File templateLibFile;

    private JavaCodeGenerationConfigBuilder() {
    }

    private JavaCodeGenerationConfigBuilder(boolean enableJacksonAnnotations, String packageName, ImportTracker importTracker, boolean executeLibraryMacros, File templateLibFile) {
        this.enableJacksonAnnotations = enableJacksonAnnotations;
        this.packageName = packageName;
        this.importTracker = importTracker;
        this.executeLibraryMacros = executeLibraryMacros;
        this.templateLibFile = templateLibFile;
    }

    public static JavaCodeGenerationConfig JavaCodeGenerationConfig(boolean enableJacksonAnnotations, String packageName, ImportTracker importTracker, boolean executeLibraryMacros, File templateLibFile) {
        return new JavaCodeGenerationConfig(enableJacksonAnnotations, packageName, importTracker, executeLibraryMacros, templateLibFile);
    }

    public static JavaCodeGenerationConfigBuilder builder() {
        return new JavaCodeGenerationConfigBuilder();
    }

    public static JavaCodeGenerationConfigBuilder builder(JavaCodeGenerationConfig from) {
        return new JavaCodeGenerationConfigBuilder(from.enableJacksonAnnotations(), from.packageName(), from.importTracker(), from.executeLibraryMacros(), from.templateLibFile());
    }

    public static With from(JavaCodeGenerationConfig from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(JavaCodeGenerationConfig record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, Boolean>("enableJacksonAnnotations", record.enableJacksonAnnotations()), new AbstractMap.SimpleImmutableEntry<String, String>("packageName", record.packageName()), new AbstractMap.SimpleImmutableEntry<String, ImportTracker>("importTracker", record.importTracker()), new AbstractMap.SimpleImmutableEntry<String, Boolean>("executeLibraryMacros", record.executeLibraryMacros()), new AbstractMap.SimpleImmutableEntry<String, File>("templateLibFile", record.templateLibFile()));
    }

    public JavaCodeGenerationConfig build() {
        return new JavaCodeGenerationConfig(this.enableJacksonAnnotations, this.packageName, this.importTracker, this.executeLibraryMacros, this.templateLibFile);
    }

    public String toString() {
        return "JavaCodeGenerationConfigBuilder[enableJacksonAnnotations=" + this.enableJacksonAnnotations + ", packageName=" + this.packageName + ", importTracker=" + this.importTracker + ", executeLibraryMacros=" + this.executeLibraryMacros + ", templateLibFile=" + this.templateLibFile + "]";
    }

    public int hashCode() {
        return Objects.hash(this.enableJacksonAnnotations, this.packageName, this.importTracker, this.executeLibraryMacros, this.templateLibFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof JavaCodeGenerationConfigBuilder)) return false;
        JavaCodeGenerationConfigBuilder r = (JavaCodeGenerationConfigBuilder)o;
        if (this.enableJacksonAnnotations != r.enableJacksonAnnotations) return false;
        if (!Objects.equals(this.packageName, r.packageName)) return false;
        if (!Objects.equals(this.importTracker, r.importTracker)) return false;
        if (this.executeLibraryMacros != r.executeLibraryMacros) return false;
        if (!Objects.equals(this.templateLibFile, r.templateLibFile)) return false;
        return true;
    }

    public JavaCodeGenerationConfigBuilder enableJacksonAnnotations(boolean enableJacksonAnnotations) {
        this.enableJacksonAnnotations = enableJacksonAnnotations;
        return this;
    }

    public boolean enableJacksonAnnotations() {
        return this.enableJacksonAnnotations;
    }

    public JavaCodeGenerationConfigBuilder packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String packageName() {
        return this.packageName;
    }

    public JavaCodeGenerationConfigBuilder importTracker(ImportTracker importTracker) {
        this.importTracker = importTracker;
        return this;
    }

    public ImportTracker importTracker() {
        return this.importTracker;
    }

    public JavaCodeGenerationConfigBuilder executeLibraryMacros(boolean executeLibraryMacros) {
        this.executeLibraryMacros = executeLibraryMacros;
        return this;
    }

    public boolean executeLibraryMacros() {
        return this.executeLibraryMacros;
    }

    public JavaCodeGenerationConfigBuilder templateLibFile(File templateLibFile) {
        this.templateLibFile = templateLibFile;
        return this;
    }

    public File templateLibFile() {
        return this.templateLibFile;
    }

    private static final class _FromWith
    implements With {
        private final JavaCodeGenerationConfig from;

        private _FromWith(JavaCodeGenerationConfig from) {
            this.from = from;
        }

        @Override
        public boolean enableJacksonAnnotations() {
            return this.from.enableJacksonAnnotations();
        }

        @Override
        public String packageName() {
            return this.from.packageName();
        }

        @Override
        public ImportTracker importTracker() {
            return this.from.importTracker();
        }

        @Override
        public boolean executeLibraryMacros() {
            return this.from.executeLibraryMacros();
        }

        @Override
        public File templateLibFile() {
            return this.from.templateLibFile();
        }
    }

    public static interface With {
        public boolean enableJacksonAnnotations();

        public String packageName();

        public ImportTracker importTracker();

        public boolean executeLibraryMacros();

        public File templateLibFile();

        default public JavaCodeGenerationConfigBuilder with() {
            return new JavaCodeGenerationConfigBuilder(this.enableJacksonAnnotations(), this.packageName(), this.importTracker(), this.executeLibraryMacros(), this.templateLibFile());
        }

        default public JavaCodeGenerationConfig with(Consumer<JavaCodeGenerationConfigBuilder> consumer) {
            JavaCodeGenerationConfigBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public JavaCodeGenerationConfig withEnableJacksonAnnotations(boolean enableJacksonAnnotations) {
            return new JavaCodeGenerationConfig(enableJacksonAnnotations, this.packageName(), this.importTracker(), this.executeLibraryMacros(), this.templateLibFile());
        }

        default public JavaCodeGenerationConfig withPackageName(String packageName) {
            return new JavaCodeGenerationConfig(this.enableJacksonAnnotations(), packageName, this.importTracker(), this.executeLibraryMacros(), this.templateLibFile());
        }

        default public JavaCodeGenerationConfig withImportTracker(ImportTracker importTracker) {
            return new JavaCodeGenerationConfig(this.enableJacksonAnnotations(), this.packageName(), importTracker, this.executeLibraryMacros(), this.templateLibFile());
        }

        default public JavaCodeGenerationConfig withExecuteLibraryMacros(boolean executeLibraryMacros) {
            return new JavaCodeGenerationConfig(this.enableJacksonAnnotations(), this.packageName(), this.importTracker(), executeLibraryMacros, this.templateLibFile());
        }

        default public JavaCodeGenerationConfig withTemplateLibFile(File templateLibFile) {
            return new JavaCodeGenerationConfig(this.enableJacksonAnnotations(), this.packageName(), this.importTracker(), this.executeLibraryMacros(), templateLibFile);
        }
    }
}

