/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.java;

import io.openmanufacturing.sds.aspectmodel.generator.Artifact;
import io.openmanufacturing.sds.aspectmodel.generator.Generator;
import io.openmanufacturing.sds.aspectmodel.java.JavaCodeGenerationConfig;
import io.openmanufacturing.sds.aspectmodel.java.QualifiedName;
import io.openmanufacturing.sds.metamodel.Aspect;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaGenerator
extends Generator<QualifiedName, String> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaGenerator.class);
    protected final JavaCodeGenerationConfig config;

    public JavaGenerator(Aspect aspect, JavaCodeGenerationConfig config) {
        super(aspect);
        this.config = config;
    }

    public void write(Artifact<QualifiedName, String> artifact, Function<QualifiedName, OutputStream> nameMapper) {
        QualifiedName qualifiedName = (QualifiedName)artifact.getId();
        OutputStream outputStream = nameMapper.apply(qualifiedName);
        String content = (String)artifact.getContent();
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            for (int i = 0; i < content.length(); ++i) {
                ((Writer)writer).write(content.charAt(i));
            }
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            LOG.error("Failure during writing of generated code.", (Throwable)e);
        }
    }

    public JavaCodeGenerationConfig getConfig() {
        return this.config;
    }
}

