/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.java;

import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.java.JavaCodeGenerationConfig;
import io.openmanufacturing.sds.aspectmodel.java.ValueInitializer;
import io.openmanufacturing.sds.aspectmodel.java.exception.CodeGenerationException;
import io.openmanufacturing.sds.aspectmodel.resolver.services.DataType;
import io.openmanufacturing.sds.metamodel.CollectionValue;
import io.openmanufacturing.sds.metamodel.Entity;
import io.openmanufacturing.sds.metamodel.EntityInstance;
import io.openmanufacturing.sds.metamodel.ModelElement;
import io.openmanufacturing.sds.metamodel.Scalar;
import io.openmanufacturing.sds.metamodel.ScalarValue;
import io.openmanufacturing.sds.metamodel.Value;
import io.openmanufacturing.sds.metamodel.datatypes.LangString;
import io.openmanufacturing.sds.metamodel.visitor.AspectVisitor;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;

public class ValueExpressionVisitor
implements AspectVisitor<String, Context> {
    private final ValueInitializer valueInitializer = new ValueInitializer();

    public String visitBase(ModelElement modelElement, Context context) {
        throw new UnsupportedOperationException("Can't create value expression for model element: " + modelElement);
    }

    public String visitScalarValue(ScalarValue value, Context context) {
        String valueExpression = this.generateValueExpression(value, context);
        if (context.isOptional()) {
            return "Optional.of(" + valueExpression + ")";
        }
        return valueExpression;
    }

    private String generateValueExpression(ScalarValue value, Context context) {
        String typeUri = ((Scalar)value.getType().as(Scalar.class)).getUrn();
        if (typeUri.equals(RDF.langString.getURI())) {
            context.getCodeGenerationConfig().importTracker().importExplicit(LangString.class);
            context.getCodeGenerationConfig().importTracker().importExplicit(Locale.class);
            LangString langStringValue = (LangString)((ScalarValue)value.as(ScalarValue.class)).getValue();
            return String.format("new LangString(\"%s\", Locale.forLanguageTag(\"%s\"))", StringEscapeUtils.escapeJava((String)langStringValue.getValue()), langStringValue.getLanguageTag().toLanguageTag());
        }
        Resource typeResource = ResourceFactory.createResource((String)typeUri);
        Class javaType = DataType.getJavaTypeForMetaModelType((Resource)typeResource, (KnownVersion)value.getMetaModelVersion());
        context.getCodeGenerationConfig().importTracker().importExplicit(javaType);
        return this.valueInitializer.apply(typeResource, javaType, "\"" + StringEscapeUtils.escapeJava((String)value.getValue().toString()) + "\"", value.getMetaModelVersion());
    }

    public String visitCollectionValue(CollectionValue collection, Context context) {
        Class<?> collectionClass = collection.getValues().getClass();
        context.getCodeGenerationConfig().importTracker().importExplicit(collectionClass);
        StringBuilder result = new StringBuilder();
        result.append("new ");
        result.append(collectionClass.getSimpleName());
        result.append("<>() {{");
        collection.getValues().forEach(value -> {
            result.append("add(");
            result.append((String)value.accept((AspectVisitor)this, (Object)context));
            result.append(");");
        });
        result.append("}}");
        return result.toString();
    }

    public String visitEntityInstance(EntityInstance instance, Context context) {
        Entity entity = (Entity)instance.getType().as(Entity.class);
        return "new " + entity.getName() + ((Stream)entity.getProperties().stream().sequential()).map(property -> {
            Value value = (Value)instance.getAssertions().get(property);
            if (value == null) {
                if (property.isOptional()) {
                    return "null";
                }
                throw new CodeGenerationException("EntityInstance " + instance.getName() + " is missing value for Property " + property.getName());
            }
            Context newContext = new Context(context.codeGenerationConfig, property.isOptional());
            return (String)value.accept((AspectVisitor)this, (Object)newContext);
        }).collect(Collectors.joining(",", "(", ")"));
    }

    public static final class Context {
        private final JavaCodeGenerationConfig codeGenerationConfig;
        private final boolean isOptional;

        public Context(JavaCodeGenerationConfig codeGenerationConfig, boolean isOptional) {
            this.codeGenerationConfig = codeGenerationConfig;
            this.isOptional = isOptional;
        }

        public JavaCodeGenerationConfig getCodeGenerationConfig() {
            return this.codeGenerationConfig;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            JavaCodeGenerationConfig this$codeGenerationConfig = this.getCodeGenerationConfig();
            JavaCodeGenerationConfig other$codeGenerationConfig = other.getCodeGenerationConfig();
            return !(this$codeGenerationConfig == null ? other$codeGenerationConfig != null : !((Object)this$codeGenerationConfig).equals(other$codeGenerationConfig));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOptional() ? 79 : 97);
            JavaCodeGenerationConfig $codeGenerationConfig = this.getCodeGenerationConfig();
            result = result * 59 + ($codeGenerationConfig == null ? 43 : ((Object)$codeGenerationConfig).hashCode());
            return result;
        }

        public String toString() {
            return "ValueExpressionVisitor.Context(codeGenerationConfig=" + this.getCodeGenerationConfig() + ", isOptional=" + this.isOptional() + ")";
        }
    }
}

