/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.java;

import io.openmanufacturing.sds.aspectmodel.java.AspectModelJavaUtil;
import io.openmanufacturing.sds.metamodel.CollectionValue;
import io.openmanufacturing.sds.metamodel.EntityInstance;
import io.openmanufacturing.sds.metamodel.ModelElement;
import io.openmanufacturing.sds.metamodel.ScalarValue;
import io.openmanufacturing.sds.metamodel.visitor.AspectVisitor;
import java.util.regex.Pattern;

public class ValueToEnumKeyVisitor
implements AspectVisitor<String, Void> {
    public String visitBase(ModelElement modelElement, Void context) {
        throw new UnsupportedOperationException();
    }

    public String visitScalarValue(ScalarValue value, Void context) {
        String stringValue = value.getValue().toString();
        Pattern startsWithNumber = Pattern.compile("^[0-9]");
        if (startsWithNumber.matcher(stringValue).lookingAt()) {
            return "NUMBER_" + AspectModelJavaUtil.toConstant(stringValue.replaceAll("[^\\p{Alnum}]", "_"));
        }
        return AspectModelJavaUtil.toConstant(stringValue.replaceAll("([^\\p{Alnum}_])", "_").replaceAll("^[^\\p{Alpha}_]", "_")).replaceAll("__*", "_");
    }

    public String visitEntityInstance(EntityInstance instance, Void context) {
        return AspectModelJavaUtil.toConstant(instance.getName());
    }

    public String visitCollectionValue(CollectionValue value, Void context) {
        throw new UnsupportedOperationException("Tried to create an enumeration key for a collection value");
    }
}

