/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.java.customconstraint;

import io.openmanufacturing.sds.aspectmodel.java.customconstraint.DurationMax;
import io.openmanufacturing.sds.metamodel.impl.BoundDefinition;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationMaxValidator
implements ConstraintValidator<DurationMax, Duration> {
    private static final Logger LOG = LoggerFactory.getLogger(DurationMaxValidator.class);
    private Duration durationMax;
    private BoundDefinition boundDefinition;

    public void initialize(DurationMax durationMax) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            this.durationMax = datatypeFactory.newDuration(durationMax.value());
            this.boundDefinition = durationMax.boundDefinition();
        }
        catch (DatatypeConfigurationException exception) {
            LOG.error("Could not instantiate DatatypeFactory", (Throwable)exception);
        }
    }

    public boolean isValid(Duration durationValue, ConstraintValidatorContext context) {
        if (durationValue == null) {
            return true;
        }
        return this.boundDefinition.isValid(durationValue, this.durationMax);
    }
}

