/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.java.metamodel;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.generator.TemplateEngine;
import io.openmanufacturing.sds.aspectmodel.java.AspectModelJavaUtil;
import io.openmanufacturing.sds.aspectmodel.java.ImportTracker;
import io.openmanufacturing.sds.aspectmodel.java.JavaArtifact;
import io.openmanufacturing.sds.aspectmodel.java.JavaCodeGenerationConfig;
import io.openmanufacturing.sds.aspectmodel.java.StructuredValuePropertiesDeconstructor;
import io.openmanufacturing.sds.aspectmodel.java.ValueInitializer;
import io.openmanufacturing.sds.aspectmodel.java.exception.CodeGenerationException;
import io.openmanufacturing.sds.aspectmodel.java.metamodel.StaticCodeGenerationContext;
import io.openmanufacturing.sds.aspectmodel.java.metamodel.StaticMetaModelVisitor;
import io.openmanufacturing.sds.aspectmodel.java.pojo.JavaArtifactGenerator;
import io.openmanufacturing.sds.aspectmodel.urn.AspectModelUrn;
import io.openmanufacturing.sds.aspectmodel.vocabulary.BAMMC;
import io.openmanufacturing.sds.characteristic.Code;
import io.openmanufacturing.sds.characteristic.Collection;
import io.openmanufacturing.sds.characteristic.Duration;
import io.openmanufacturing.sds.characteristic.Either;
import io.openmanufacturing.sds.characteristic.Enumeration;
import io.openmanufacturing.sds.characteristic.List;
import io.openmanufacturing.sds.characteristic.Measurement;
import io.openmanufacturing.sds.characteristic.Quantifiable;
import io.openmanufacturing.sds.characteristic.Set;
import io.openmanufacturing.sds.characteristic.SingleEntity;
import io.openmanufacturing.sds.characteristic.SortedSet;
import io.openmanufacturing.sds.characteristic.State;
import io.openmanufacturing.sds.characteristic.StructuredValue;
import io.openmanufacturing.sds.characteristic.Trait;
import io.openmanufacturing.sds.characteristic.impl.DefaultCode;
import io.openmanufacturing.sds.characteristic.impl.DefaultCollection;
import io.openmanufacturing.sds.characteristic.impl.DefaultDuration;
import io.openmanufacturing.sds.characteristic.impl.DefaultEnumeration;
import io.openmanufacturing.sds.characteristic.impl.DefaultList;
import io.openmanufacturing.sds.characteristic.impl.DefaultMeasurement;
import io.openmanufacturing.sds.characteristic.impl.DefaultQuantifiable;
import io.openmanufacturing.sds.characteristic.impl.DefaultSet;
import io.openmanufacturing.sds.characteristic.impl.DefaultSingleEntity;
import io.openmanufacturing.sds.characteristic.impl.DefaultSortedSet;
import io.openmanufacturing.sds.characteristic.impl.DefaultState;
import io.openmanufacturing.sds.characteristic.impl.DefaultStructuredValue;
import io.openmanufacturing.sds.characteristic.impl.DefaultTrait;
import io.openmanufacturing.sds.constraint.EncodingConstraint;
import io.openmanufacturing.sds.constraint.FixedPointConstraint;
import io.openmanufacturing.sds.constraint.LanguageConstraint;
import io.openmanufacturing.sds.constraint.LengthConstraint;
import io.openmanufacturing.sds.constraint.RangeConstraint;
import io.openmanufacturing.sds.constraint.RegularExpressionConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultEncodingConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultFixedPointConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultLanguageConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultLengthConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultRangeConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultRegularExpressionConstraint;
import io.openmanufacturing.sds.metamodel.AbstractEntity;
import io.openmanufacturing.sds.metamodel.Constraint;
import io.openmanufacturing.sds.metamodel.Entity;
import io.openmanufacturing.sds.metamodel.HasProperties;
import io.openmanufacturing.sds.metamodel.Scalar;
import io.openmanufacturing.sds.metamodel.StructureElement;
import io.openmanufacturing.sds.metamodel.Unit;
import io.openmanufacturing.sds.metamodel.Units;
import io.openmanufacturing.sds.metamodel.datatypes.LangString;
import io.openmanufacturing.sds.metamodel.impl.BoundDefinition;
import io.openmanufacturing.sds.metamodel.impl.DefaultAbstractEntity;
import io.openmanufacturing.sds.metamodel.impl.DefaultCharacteristic;
import io.openmanufacturing.sds.metamodel.impl.DefaultComplexType;
import io.openmanufacturing.sds.metamodel.impl.DefaultEntity;
import io.openmanufacturing.sds.metamodel.impl.DefaultScalar;
import io.openmanufacturing.sds.metamodel.loader.MetaModelBaseAttributes;
import io.openmanufacturing.sds.staticmetamodel.PropertyContainer;
import io.openmanufacturing.sds.staticmetamodel.StaticContainerProperty;
import io.openmanufacturing.sds.staticmetamodel.StaticMetaClass;
import io.openmanufacturing.sds.staticmetamodel.StaticProperty;
import io.openmanufacturing.sds.staticmetamodel.StaticUnitProperty;
import io.openmanufacturing.sds.staticmetamodel.constraint.StaticConstraintContainerProperty;
import io.openmanufacturing.sds.staticmetamodel.constraint.StaticConstraintProperty;
import io.openmanufacturing.sds.staticmetamodel.constraint.StaticConstraintUnitProperty;
import java.nio.charset.Charset;
import java.time.Year;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.XSD;
import org.jboss.forge.roaster.Roaster;

public class StaticMetaModelJavaArtifactGenerator<E extends StructureElement>
implements JavaArtifactGenerator<E> {
    public JavaArtifact apply(E element, JavaCodeGenerationConfig config) {
        ImportTracker importTracker = config.importTracker();
        importTracker.importExplicit(Optional.class);
        importTracker.importExplicit(java.util.List.class);
        importTracker.importExplicit(PropertyContainer.class);
        importTracker.importExplicit(StaticMetaClass.class);
        importTracker.importExplicit(StaticProperty.class);
        importTracker.importExplicit(MetaModelBaseAttributes.class);
        importTracker.importExplicit(KnownVersion.class);
        importTracker.importExplicit(AspectModelUrn.class);
        importTracker.importExplicit(Constraint.class);
        importTracker.importExplicit(Trait.class);
        importTracker.importExplicit(Arrays.class);
        importTracker.importExplicit(Locale.class);
        CharMatcher matchHash = CharMatcher.is((char)'#');
        String modelUrnPrefix = element.getAspectModelUrn().map(AspectModelUrn::getUrnPrefix).orElseThrow(() -> {
            throw new CodeGenerationException("Aspect or Entity may not be declared as an anonymous node");
        });
        String characteristicBaseUrn = matchHash.trimTrailingFrom((CharSequence)new BAMMC(element.getMetaModelVersion()).getNamespace());
        ImmutableMap context = ImmutableMap.builder().put((Object)"Arrays", Arrays.class).put((Object)"BoundDefinition", BoundDefinition.class).put((Object)"characteristicBaseUrn", (Object)characteristicBaseUrn).put((Object)"Charset", Charset.class).put((Object)"Code", Code.class).put((Object)"codeGenerationConfig", (Object)config).put((Object)"Collection", Collection.class).put((Object)"Collections", Collections.class).put((Object)"Constraint", Constraint.class).put((Object)"context", (Object)new StaticCodeGenerationContext(config, modelUrnPrefix, characteristicBaseUrn, null)).put((Object)"currentYear", (Object)Year.now()).put((Object)"DatatypeConfigurationException", DatatypeConfigurationException.class).put((Object)"DatatypeConstants", DatatypeConstants.class).put((Object)"DatatypeFactory", DatatypeFactory.class).put((Object)"deconstructor", (Object)new StructuredValuePropertiesDeconstructor((HasProperties)element)).put((Object)"DefaultCharacteristic", DefaultCharacteristic.class).put((Object)"DefaultCode", DefaultCode.class).put((Object)"DefaultCollection", DefaultCollection.class).put((Object)"DefaultDuration", DefaultDuration.class).put((Object)"DefaultEncodingConstraint", DefaultEncodingConstraint.class).put((Object)"DefaultEntity", DefaultEntity.class).put((Object)"DefaultAbstractEntity", DefaultAbstractEntity.class).put((Object)"DefaultComplexType", DefaultComplexType.class).put((Object)"DefaultEnumeration", DefaultEnumeration.class).put((Object)"DefaultFixedPointConstraint", DefaultFixedPointConstraint.class).put((Object)"DefaultLanguageConstraint", DefaultLanguageConstraint.class).put((Object)"DefaultLengthConstraint", DefaultLengthConstraint.class).put((Object)"DefaultList", DefaultList.class).put((Object)"DefaultMeasurement", DefaultMeasurement.class).put((Object)"DefaultQuantifiable", DefaultQuantifiable.class).put((Object)"DefaultRangeConstraint", DefaultRangeConstraint.class).put((Object)"DefaultRegularExpressionConstraint", DefaultRegularExpressionConstraint.class).put((Object)"DefaultScalar", DefaultScalar.class).put((Object)"DefaultSet", DefaultSet.class).put((Object)"DefaultSingleEntity", DefaultSingleEntity.class).put((Object)"DefaultSortedSet", DefaultSortedSet.class).put((Object)"DefaultState", DefaultState.class).put((Object)"DefaultStructuredValue", DefaultStructuredValue.class).put((Object)"DefaultTrait", DefaultTrait.class).put((Object)"Duration", Duration.class).put((Object)"element", element).put((Object)"Either", Either.class).put((Object)"EncodingConstraint", EncodingConstraint.class).put((Object)"Entity", Entity.class).put((Object)"AbstractEntity", AbstractEntity.class).put((Object)"Enumeration", Enumeration.class).put((Object)"FixedPointConstraint", FixedPointConstraint.class).put((Object)"HashSet", HashSet.class).put((Object)"LangString", LangString.class).put((Object)"LanguageConstraint", LanguageConstraint.class).put((Object)"LengthConstraint", LengthConstraint.class).put((Object)"List", List.class).put((Object)"Locale", Locale.class).put((Object)"localeEn", (Object)Locale.ENGLISH).put((Object)"Map", Map.class).put((Object)"Measurement", Measurement.class).put((Object)"modelUrnPrefix", (Object)modelUrnPrefix).put((Object)"modelVisitor", (Object)new StaticMetaModelVisitor()).put((Object)"nonNegativeInteger", (Object)new DefaultScalar(XSD.nonNegativeInteger.getURI(), element.getMetaModelVersion())).put((Object)"Quantifiable", Quantifiable.class).put((Object)"RangeConstraint", RangeConstraint.class).put((Object)"RegularExpressionConstraint", RegularExpressionConstraint.class).put((Object)"ResourceFactory", ResourceFactory.class).put((Object)"Scalar", Scalar.class).put((Object)"Set", Set.class).put((Object)"SingleEntity", SingleEntity.class).put((Object)"SortedSet", SortedSet.class).put((Object)"State", State.class).put((Object)"StaticConstraintContainerProperty", StaticConstraintContainerProperty.class).put((Object)"StaticConstraintProperty", StaticConstraintProperty.class).put((Object)"StaticConstraintUnitProperty", StaticConstraintUnitProperty.class).put((Object)"StaticContainerProperty", StaticContainerProperty.class).put((Object)"StaticUnitProperty", StaticUnitProperty.class).put((Object)"StringEscapeUtils", StringEscapeUtils.class).put((Object)"StructuredValue", StructuredValue.class).put((Object)"Trait", Trait.class).put((Object)"Unit", Unit.class).put((Object)"Units", Units.class).put((Object)"util", AspectModelJavaUtil.class).put((Object)"valueInitializer", (Object)new ValueInitializer()).build();
        Properties engineConfiguration = new Properties();
        if (config.executeLibraryMacros()) {
            engineConfiguration.put("velocimacro.library", config.templateLibFile().getName());
            engineConfiguration.put("file.resource.loader.path", config.templateLibFile().getParent());
        }
        String generatedSource = new TemplateEngine((Map)context, engineConfiguration).apply("java-static-class");
        try {
            return new JavaArtifact(Roaster.format((String)generatedSource), "Meta" + element.getName(), config.packageName());
        }
        catch (Exception exception) {
            throw new CodeGenerationException(generatedSource, exception);
        }
    }
}

