/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.java.metamodel;

import io.openmanufacturing.sds.aspectmetamodel.KnownVersion;
import io.openmanufacturing.sds.aspectmodel.java.AspectModelJavaUtil;
import io.openmanufacturing.sds.aspectmodel.java.ValueExpressionVisitor;
import io.openmanufacturing.sds.aspectmodel.java.ValueInitializer;
import io.openmanufacturing.sds.aspectmodel.java.exception.CodeGenerationException;
import io.openmanufacturing.sds.aspectmodel.java.metamodel.StaticCodeGenerationContext;
import io.openmanufacturing.sds.aspectmodel.urn.AspectModelUrn;
import io.openmanufacturing.sds.characteristic.Code;
import io.openmanufacturing.sds.characteristic.Collection;
import io.openmanufacturing.sds.characteristic.Duration;
import io.openmanufacturing.sds.characteristic.Enumeration;
import io.openmanufacturing.sds.characteristic.Measurement;
import io.openmanufacturing.sds.characteristic.Quantifiable;
import io.openmanufacturing.sds.characteristic.SingleEntity;
import io.openmanufacturing.sds.characteristic.State;
import io.openmanufacturing.sds.characteristic.StructuredValue;
import io.openmanufacturing.sds.characteristic.Trait;
import io.openmanufacturing.sds.characteristic.impl.DefaultCode;
import io.openmanufacturing.sds.characteristic.impl.DefaultCollection;
import io.openmanufacturing.sds.characteristic.impl.DefaultEnumeration;
import io.openmanufacturing.sds.characteristic.impl.DefaultList;
import io.openmanufacturing.sds.characteristic.impl.DefaultSet;
import io.openmanufacturing.sds.characteristic.impl.DefaultSingleEntity;
import io.openmanufacturing.sds.characteristic.impl.DefaultSortedSet;
import io.openmanufacturing.sds.characteristic.impl.DefaultState;
import io.openmanufacturing.sds.characteristic.impl.DefaultStructuredValue;
import io.openmanufacturing.sds.characteristic.impl.DefaultTrait;
import io.openmanufacturing.sds.constraint.EncodingConstraint;
import io.openmanufacturing.sds.constraint.FixedPointConstraint;
import io.openmanufacturing.sds.constraint.LanguageConstraint;
import io.openmanufacturing.sds.constraint.LengthConstraint;
import io.openmanufacturing.sds.constraint.LocaleConstraint;
import io.openmanufacturing.sds.constraint.RangeConstraint;
import io.openmanufacturing.sds.constraint.RegularExpressionConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultEncodingConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultFixedPointConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultLanguageConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultLengthConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultLocaleConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultRangeConstraint;
import io.openmanufacturing.sds.constraint.impl.DefaultRegularExpressionConstraint;
import io.openmanufacturing.sds.metamodel.AbstractEntity;
import io.openmanufacturing.sds.metamodel.Characteristic;
import io.openmanufacturing.sds.metamodel.CollectionValue;
import io.openmanufacturing.sds.metamodel.ComplexType;
import io.openmanufacturing.sds.metamodel.Constraint;
import io.openmanufacturing.sds.metamodel.Entity;
import io.openmanufacturing.sds.metamodel.EntityInstance;
import io.openmanufacturing.sds.metamodel.ModelElement;
import io.openmanufacturing.sds.metamodel.NamedElement;
import io.openmanufacturing.sds.metamodel.Property;
import io.openmanufacturing.sds.metamodel.QuantityKind;
import io.openmanufacturing.sds.metamodel.QuantityKinds;
import io.openmanufacturing.sds.metamodel.Scalar;
import io.openmanufacturing.sds.metamodel.ScalarValue;
import io.openmanufacturing.sds.metamodel.Type;
import io.openmanufacturing.sds.metamodel.Unit;
import io.openmanufacturing.sds.metamodel.Units;
import io.openmanufacturing.sds.metamodel.Value;
import io.openmanufacturing.sds.metamodel.impl.BoundDefinition;
import io.openmanufacturing.sds.metamodel.impl.DefaultAbstractEntity;
import io.openmanufacturing.sds.metamodel.impl.DefaultCharacteristic;
import io.openmanufacturing.sds.metamodel.impl.DefaultCollectionValue;
import io.openmanufacturing.sds.metamodel.impl.DefaultEntity;
import io.openmanufacturing.sds.metamodel.impl.DefaultEntityInstance;
import io.openmanufacturing.sds.metamodel.impl.DefaultScalar;
import io.openmanufacturing.sds.metamodel.impl.DefaultScalarValue;
import io.openmanufacturing.sds.metamodel.impl.DefaultUnit;
import io.openmanufacturing.sds.metamodel.visitor.AspectVisitor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.XSD;

public class StaticMetaModelVisitor
implements AspectVisitor<String, StaticCodeGenerationContext> {
    private final ValueExpressionVisitor valueExpressionVisitor = new ValueExpressionVisitor();
    private final ValueInitializer valueInitializer = new ValueInitializer();
    private final Supplier<CodeGenerationException> noTypeException = () -> new CodeGenerationException("Characteristic is missing its dataType");

    public String visitBase(ModelElement modelElement, StaticCodeGenerationContext context) {
        throw new UnsupportedOperationException();
    }

    public String visitScalarValue(ScalarValue value, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultScalarValue.class);
        ValueExpressionVisitor.Context valueContext = new ValueExpressionVisitor.Context(context.getCodeGenerationConfig(), false);
        return "new DefaultScalarValue(" + (String)value.accept((AspectVisitor)this.valueExpressionVisitor, (Object)valueContext) + "," + (String)value.getType().accept((AspectVisitor)this, (Object)context) + ")";
    }

    public String visitCollectionValue(CollectionValue collection, StaticCodeGenerationContext context) {
        Class<?> collectionClass = collection.getValues().getClass();
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultCollectionValue.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(collectionClass);
        StringBuilder result = new StringBuilder();
        result.append("new DefaultCollectionValue(");
        result.append("new ");
        result.append(collectionClass.getSimpleName());
        result.append("<>() {{");
        collection.getValues().forEach(value -> {
            result.append("add(");
            result.append((String)value.accept((AspectVisitor)this, (Object)context));
            result.append(");");
        });
        result.append("}}");
        result.append(",");
        result.append(CollectionValue.CollectionType.class.getName().replace("$", ".")).append(".");
        result.append(collection.getCollectionType()).append(",");
        result.append((String)collection.getType().accept((AspectVisitor)this, (Object)context));
        result.append(")");
        return result.toString();
    }

    public String visitEntityInstance(EntityInstance instance, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEntityInstance.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Map.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(HashMap.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Property.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Value.class);
        Entity entity = instance.getEntityType();
        StringBuilder builder = new StringBuilder();
        builder.append("new DefaultEntityInstance(");
        builder.append(this.getMetaModelBaseAttributes(instance, context));
        builder.append(",");
        builder.append("new HashMap<Property, Value>() {{");
        for (Property property : instance.getEntityType().getProperties()) {
            Value instancePropertyValue = (Value)instance.getAssertions().get(property);
            if (instancePropertyValue == null) continue;
            String className = "Meta" + entity.getName();
            String staticPropertyField = AspectModelJavaUtil.toConstant(property.getName());
            builder.append("put(");
            builder.append(className);
            builder.append(".");
            builder.append(staticPropertyField);
            builder.append(",");
            builder.append((String)instancePropertyValue.accept((AspectVisitor)this, (Object)context));
            builder.append(");");
        }
        builder.append("}},");
        builder.append((String)instance.getEntityType().accept((AspectVisitor)this, (Object)context));
        builder.append(")");
        return builder.toString();
    }

    public String visitSingleEntity(SingleEntity singleEntity, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultSingleEntity.class);
        return "new DefaultSingleEntity(" + this.getMetaModelBaseAttributes(singleEntity, context) + ", " + (String)((Type)singleEntity.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ")";
    }

    public String visitCollection(Collection collection, StaticCodeGenerationContext context) {
        Class<DefaultList> implementationClass = switch (collection.getCollectionType()) {
            case CollectionValue.CollectionType.LIST -> DefaultList.class;
            case CollectionValue.CollectionType.SET -> DefaultSet.class;
            case CollectionValue.CollectionType.SORTEDSET -> DefaultSortedSet.class;
            default -> DefaultCollection.class;
        };
        context.getCodeGenerationConfig().importTracker().importExplicit(implementationClass);
        String optionalType = collection.getDataType().map(type -> (String)type.accept((AspectVisitor)this, (Object)context)).map(type -> "Optional.of(" + type + ")").orElse("Optional.empty()");
        String optionalElementCharacteristic = collection.getElementCharacteristic().map(characteristic -> (String)characteristic.accept((AspectVisitor)this, (Object)context)).map(characteristic -> "Optional.of(" + characteristic + ")").orElse("Optional.empty()");
        return "new " + implementationClass.getSimpleName() + "(" + this.getMetaModelBaseAttributes(collection, context) + "," + optionalType + "," + optionalElementCharacteristic + ")";
    }

    public String visitCode(Code code, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultCode.class);
        return "new DefaultCode(" + this.getMetaModelBaseAttributes(code, context) + "," + (String)((Type)code.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ")";
    }

    public String visitDuration(Duration duration, StaticCodeGenerationContext context) {
        return this.generateForQuantifiable(duration, context);
    }

    public String visitMeasurement(Measurement measurement, StaticCodeGenerationContext context) {
        return this.generateForQuantifiable(measurement, context);
    }

    public String visitQuantifiable(Quantifiable quantifiable, StaticCodeGenerationContext context) {
        return this.generateForQuantifiable(quantifiable, context);
    }

    private <T extends Quantifiable> String generateForQuantifiable(T quantifiable, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(quantifiable.getClass());
        context.getCodeGenerationConfig().importTracker().importExplicit(Units.class);
        return "new " + quantifiable.getClass().getSimpleName() + "(" + this.getMetaModelBaseAttributes(quantifiable, context) + "," + (String)((Type)quantifiable.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + "," + quantifiable.getUnit().map(unit -> (String)unit.accept((AspectVisitor)this, (Object)context)).orElse("Optional.empty()") + ")";
    }

    private String optionalString(Optional<String> optionalString) {
        return optionalString.map(value -> "Optional.of(\"" + value + "\")").orElse("Optional.empty()");
    }

    public String visitUnit(Unit unit, StaticCodeGenerationContext context) {
        Optional unitFromCatalog = Units.fromName((String)unit.getName(), (KnownVersion)unit.getMetaModelVersion());
        if (unitFromCatalog.isPresent()) {
            context.getCodeGenerationConfig().importTracker().importExplicit(Units.class);
            return "Units.fromName(\"" + unit.getName() + "\", KnownVersion." + unit.getMetaModelVersion() + ")";
        }
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultUnit.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(HashSet.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Optional.class);
        return "Optional.of(new DefaultUnit(" + this.getMetaModelBaseAttributes(unit, context) + "," + this.optionalString(unit.getSymbol()) + "," + this.optionalString(unit.getCode()) + "," + this.optionalString(unit.getReferenceUnit()) + "," + this.optionalString(unit.getConversionFactor()) + ",new HashSet<>(){{" + unit.getQuantityKinds().stream().map(quantityKind -> (String)quantityKind.accept((AspectVisitor)this, (Object)context)).map(quantityKindInitializer -> String.format("add(%s);", quantityKindInitializer)).collect(Collectors.joining()) + "}}))";
    }

    public String visitQuantityKind(QuantityKind quantityKind, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(QuantityKinds.class);
        return "QuantityKinds." + AspectModelJavaUtil.toConstant(quantityKind.getName());
    }

    public String visitState(State state, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultState.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(ArrayList.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Value.class);
        return "new DefaultState(" + this.getMetaModelBaseAttributes(state, context) + "," + (String)((Type)state.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ",new ArrayList<Value>(){{" + state.getValues().stream().sorted().map(value -> String.format("add(%s);", value.accept((AspectVisitor)this, (Object)context))).collect(Collectors.joining()) + "}}," + (String)state.getDefaultValue().accept((AspectVisitor)this, (Object)context) + ")";
    }

    public String visitEnumeration(Enumeration enumeration, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEnumeration.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(ArrayList.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Value.class);
        return "new DefaultEnumeration(" + this.getMetaModelBaseAttributes(enumeration, context) + "," + (String)((Type)enumeration.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ",new ArrayList<Value>(){{" + enumeration.getValues().stream().sorted().map(value -> String.format("add(%s);", value.accept((AspectVisitor)this, (Object)context))).collect(Collectors.joining()) + "}})";
    }

    public String visitStructuredValue(StructuredValue structuredValue, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultStructuredValue.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(ArrayList.class);
        return "new DefaultStructuredValue(" + this.getMetaModelBaseAttributes(structuredValue, context) + "," + (String)((Type)structuredValue.getDataType().orElseThrow(this.noTypeException)).accept((AspectVisitor)this, (Object)context) + ",\"" + StringEscapeUtils.escapeJava((String)structuredValue.getDeconstructionRule()) + "\",new ArrayList<Object>(){{" + ((Stream)structuredValue.getElements().stream().sequential()).map(element -> String.format("add(%s);", AspectModelJavaUtil.printStructuredValueElement(element))).collect(Collectors.joining()) + "}})";
    }

    public String visitTrait(Trait trait, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultTrait.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(ArrayList.class);
        return "new DefaultTrait(" + this.getMetaModelBaseAttributes(trait, context) + "," + (String)trait.getBaseCharacteristic().accept((AspectVisitor)this, (Object)context) + ",new ArrayList<Constraint>(){{" + trait.getConstraints().stream().sorted().map(constraint -> String.format("add(%s);", constraint.accept((AspectVisitor)this, (Object)context.withCurrentCharacteristic((Characteristic)trait)))).collect(Collectors.joining()) + "}})";
    }

    public String visitCharacteristic(Characteristic characteristic, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultCharacteristic.class);
        return "new DefaultCharacteristic(" + this.getMetaModelBaseAttributes(characteristic, context) + "," + characteristic.getDataType().map(type -> "Optional.of(" + (String)type.accept((AspectVisitor)this, (Object)context) + ")").orElse("Optional.empty()") + ")";
    }

    public String visitLengthConstraint(LengthConstraint lengthConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultLengthConstraint.class);
        DefaultScalar nonNegativeInteger = new DefaultScalar(XSD.nonNegativeInteger.getURI(), lengthConstraint.getMetaModelVersion());
        return "new DefaultLengthConstraint(" + this.getMetaModelBaseAttributes(lengthConstraint, context) + "," + this.getOptionalStaticDeclarationValue((Type)nonNegativeInteger, lengthConstraint.getMinValue(), lengthConstraint.getMetaModelVersion(), context) + "," + this.getOptionalStaticDeclarationValue((Type)nonNegativeInteger, lengthConstraint.getMaxValue(), lengthConstraint.getMetaModelVersion(), context) + ")";
    }

    public String visitRangeConstraint(RangeConstraint rangeConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultRangeConstraint.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(BoundDefinition.class);
        Type characteristicType = (Type)context.getCurrentCharacteristic().getDataType().orElseThrow(this.noTypeException);
        return "new DefaultRangeConstraint(" + this.getMetaModelBaseAttributes(rangeConstraint, context) + "," + this.getOptionalStaticDeclarationValue(characteristicType, rangeConstraint.getMinValue(), rangeConstraint.getMetaModelVersion(), context) + "," + this.getOptionalStaticDeclarationValue(characteristicType, rangeConstraint.getMaxValue(), rangeConstraint.getMetaModelVersion(), context) + ",BoundDefinition." + rangeConstraint.getLowerBoundDefinition().name() + ",BoundDefinition." + rangeConstraint.getUpperBoundDefinition().name() + ")";
    }

    public String visitRegularExpressionConstraint(RegularExpressionConstraint regularExpressionConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultRegularExpressionConstraint.class);
        return "new DefaultRegularExpressionConstraint(" + this.getMetaModelBaseAttributes(regularExpressionConstraint, context) + ",\"" + StringEscapeUtils.escapeJava((String)regularExpressionConstraint.getValue()) + "\")";
    }

    public String visitEncodingConstraint(EncodingConstraint encodingConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEncodingConstraint.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Charset.class);
        return "new DefaultEncodingConstraint(" + this.getMetaModelBaseAttributes(encodingConstraint, context) + ",Charset.forName(\"" + encodingConstraint.getValue() + "\"))";
    }

    public String visitLanguageConstraint(LanguageConstraint languageConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultLanguageConstraint.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Locale.class);
        return "new DefaultLanguageConstraint(" + this.getMetaModelBaseAttributes(languageConstraint, context) + ",Locale.forLanguageTag(\"" + languageConstraint.getLanguageCode().toLanguageTag() + "\"))";
    }

    public String visitLocaleConstraint(LocaleConstraint localeConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultLocaleConstraint.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(Locale.class);
        return "new DefaultLanguageConstraint(" + this.getMetaModelBaseAttributes(localeConstraint, context) + ",Locale.forLanguageTag(\"" + localeConstraint.getLocaleCode().toLanguageTag() + "\"))";
    }

    public String visitFixedPointConstraint(FixedPointConstraint fixedPointConstraint, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultFixedPointConstraint.class);
        return "new DefaultFixedPointConstraint(" + this.getMetaModelBaseAttributes(fixedPointConstraint, context) + "," + fixedPointConstraint.getScale() + "," + fixedPointConstraint.getInteger() + ")";
    }

    public String visitConstraint(Constraint constraint, StaticCodeGenerationContext context) {
        throw new UnsupportedOperationException("Could not generate code for unknown constraint: " + constraint.getName());
    }

    public String visitEntity(Entity entity, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEntity.class);
        return "DefaultEntity.createDefaultEntity(" + this.getMetaModelBaseAttributes(entity, context) + ",Meta" + entity.getName() + ".INSTANCE.getProperties()," + this.extendsComplexType((ComplexType)entity, context) + ")";
    }

    public String visitAbstractEntity(AbstractEntity abstractEntity, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultAbstractEntity.class);
        return "DefaultAbstractEntity.createDefaultAbstractEntity(" + this.getMetaModelBaseAttributes(abstractEntity, context) + ",Meta" + abstractEntity.getName() + ".INSTANCE.getProperties()," + this.extendsComplexType((ComplexType)abstractEntity, context) + ",List.of(" + abstractEntity.getExtendingElements().stream().sorted().map(extendingElement -> "AspectModelUrn.fromUrn(\"" + extendingElement.getUrn() + "\")").collect(Collectors.joining(",")) + "))";
    }

    public String visitScalar(Scalar scalar, StaticCodeGenerationContext context) {
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultScalar.class);
        return "new DefaultScalar(\"" + scalar.getUrn() + "\", KnownVersion." + scalar.getMetaModelVersion() + ")";
    }

    private String extendsComplexType(ComplexType complexType, StaticCodeGenerationContext context) {
        if (complexType.getExtends().isEmpty()) {
            return "Optional.empty()";
        }
        ComplexType type = (ComplexType)complexType.getExtends().get();
        if (type.is(Entity.class)) {
            Entity entity = (Entity)type.as(Entity.class);
            context.getCodeGenerationConfig().importTracker().importExplicit(DefaultEntity.class);
            return "Optional.of(DefaultEntity.createDefaultEntity(" + this.getMetaModelBaseAttributes(complexType, context) + ",Meta" + entity.getName() + ".INSTANCE.getProperties()," + this.extendsComplexType((ComplexType)entity, context) + "))";
        }
        AbstractEntity abstractEntity = (AbstractEntity)type.as(AbstractEntity.class);
        context.getCodeGenerationConfig().importTracker().importExplicit(DefaultAbstractEntity.class);
        return "Optional.of(DefaultAbstractEntity.createDefaultAbstractEntity(" + this.getMetaModelBaseAttributes(abstractEntity, context) + ",Meta" + abstractEntity.getName() + ".INSTANCE.getProperties()," + this.extendsComplexType((ComplexType)abstractEntity, context) + ",List.of(" + abstractEntity.getExtendingElements().stream().sorted().map(extendingElement -> "AspectModelUrn.fromUrn( \"" + extendingElement.getUrn() + "\" )").collect(Collectors.joining(",")) + ")))";
    }

    private <T> String getOptionalStaticDeclarationValue(Type type, Optional<T> optionalValue, KnownVersion metaModelVersion, StaticCodeGenerationContext context) {
        if (optionalValue.isEmpty()) {
            return "Optional.empty()";
        }
        if (optionalValue.get() instanceof ScalarValue) {
            return "Optional.of(" + (String)((ScalarValue)optionalValue.get()).accept((AspectVisitor)this, (Object)context) + ")";
        }
        context.getCodeGenerationConfig().importTracker().importExplicit(AspectModelJavaUtil.getDataTypeClass(type));
        Resource xsdType = ResourceFactory.createResource((String)type.getUrn());
        Object valueExpression = optionalValue.get().toString();
        if (type.getUrn().endsWith("#float")) {
            valueExpression = (String)valueExpression + "f";
        }
        valueExpression = AspectModelJavaUtil.doesValueNeedsToBeQuoted(type.getUrn()) ? "\"" + (String)valueExpression + "\"" : StringEscapeUtils.escapeJava((String)valueExpression);
        return "Optional.of(" + this.valueInitializer.apply(xsdType, (String)valueExpression, metaModelVersion) + ")";
    }

    public String metaModelBaseAttributes(Property property, StaticCodeGenerationContext context) {
        return this.getMetaModelBaseAttributes(property, context);
    }

    public <T extends NamedElement & ModelElement> String getMetaModelBaseAttributes(T element, StaticCodeGenerationContext context) {
        if (element.getPreferredNames().isEmpty() && element.getDescriptions().isEmpty() && element.getSee().isEmpty()) {
            return "MetaModelBaseAttributes.from(KnownVersion." + element.getMetaModelVersion().toString() + ", " + this.elementUrn(element, context) + ", \"" + element.getName() + "\" )";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("MetaModelBaseAttributes.builderFor( \"").append(element.getName()).append("\" )");
        builder.append(".withMetaModelVersion(KnownVersion.").append(element.getMetaModelVersion().toString()).append(")");
        builder.append(".withUrn(").append(this.elementUrn(element, context)).append(")");
        element.getPreferredNames().stream().sorted().forEach(preferredName -> {
            builder.append(".withPreferredName(Locale.forLanguageTag(\"").append(preferredName.getLanguageTag().toLanguageTag()).append("\"),");
            builder.append("\"").append(StringEscapeUtils.escapeJava((String)preferredName.getValue())).append("\")");
        });
        element.getDescriptions().stream().sorted().forEach(description -> {
            builder.append(".withDescription(Locale.forLanguageTag(\"").append(description.getLanguageTag().toLanguageTag()).append("\"),");
            builder.append("\"").append(StringEscapeUtils.escapeJava((String)description.getValue())).append("\")");
        });
        element.getSee().stream().sorted().forEach(see -> builder.append(".withSee(\"").append(StringEscapeUtils.escapeJava((String)see)).append("\")"));
        builder.append(".build()");
        return builder.toString();
    }

    public String elementUrn(NamedElement element, StaticCodeGenerationContext context) {
        if (element.getAspectModelUrn().isEmpty()) {
            return "null";
        }
        if (((AspectModelUrn)element.getAspectModelUrn().get()).toString().startsWith(context.getModelUrnPrefix())) {
            return "AspectModelUrn.fromUrn( NAMESPACE + \"" + element.getName() + "\" )";
        }
        if (((AspectModelUrn)element.getAspectModelUrn().get()).toString().startsWith(context.getCharacteristicBaseUrn())) {
            return "AspectModelUrn.fromUrn( CHARACTERISTIC_NAMESPACE + \"#" + element.getName() + "\" )";
        }
        return "AspectModelUrn.fromUrn( \"" + element.getAspectModelUrn().get() + "\" )";
    }
}

