/*
 * Decompiled with CFR 0.152.
 */
package io.openmanufacturing.sds.aspectmodel.java.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import io.openmanufacturing.sds.aspectmodel.generator.TemplateEngine;
import io.openmanufacturing.sds.aspectmodel.java.AspectModelJavaUtil;
import io.openmanufacturing.sds.aspectmodel.java.ImportTracker;
import io.openmanufacturing.sds.aspectmodel.java.JavaArtifact;
import io.openmanufacturing.sds.aspectmodel.java.JavaCodeGenerationConfig;
import io.openmanufacturing.sds.aspectmodel.java.exception.CodeGenerationException;
import io.openmanufacturing.sds.aspectmodel.java.exception.EnumAttributeNotFoundException;
import io.openmanufacturing.sds.aspectmodel.java.pojo.JavaArtifactGenerator;
import io.openmanufacturing.sds.characteristic.Enumeration;
import io.openmanufacturing.sds.characteristic.State;
import io.openmanufacturing.sds.metamodel.Entity;
import io.openmanufacturing.sds.metamodel.Scalar;
import java.time.Year;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.jboss.forge.roaster.Roaster;

public class EnumerationJavaArtifactGenerator<E extends Enumeration>
implements JavaArtifactGenerator<E> {
    public JavaArtifact apply(E element, JavaCodeGenerationConfig config) {
        ImportTracker importTracker = config.importTracker();
        importTracker.importExplicit(EnumAttributeNotFoundException.class);
        ImmutableMap context = ImmutableMap.builder().put((Object)"Arrays", Arrays.class).put((Object)"className", (Object)element.getName()).put((Object)"codeGenerationConfig", (Object)config).put((Object)"currentYear", (Object)Year.now()).put((Object)"dataType", (Object)AspectModelJavaUtil.getDataType(element.getDataType(), config.importTracker())).put((Object)"Entity", Entity.class).put((Object)"enumeration", element).put((Object)"importTracker", (Object)importTracker).put((Object)"JsonValue", JsonValue.class).put((Object)"JsonCreator", JsonCreator.class).put((Object)"JsonFormat", JsonFormat.class).put((Object)"Optional", Optional.class).put((Object)"Scalar", Scalar.class).put((Object)"State", State.class).put((Object)"util", AspectModelJavaUtil.class).build();
        try {
            Properties engineConfiguration = new Properties();
            if (config.executeLibraryMacros()) {
                engineConfiguration.put("velocimacro.library", config.templateLibFile().getName());
                engineConfiguration.put("file.resource.loader.path", config.templateLibFile().getParent());
            }
            String generatedSource = new TemplateEngine((Map)context, engineConfiguration).apply("java-enumeration");
            return new JavaArtifact(Roaster.format((String)generatedSource), element.getName(), config.packageName());
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }
}

