// AUTOGENERATED FILE - DO NOT MODIFY!
// This file generated by Djinni from coordinate_system.djinni

package io.openmobilemaps.mapscore.shared.map.coordinates

import java.util.concurrent.atomic.AtomicBoolean

abstract class CoordinateConversionHelperInterface {

    abstract fun registerConverter(converter: CoordinateConverterInterface)

    abstract fun convert(to: String, coordinate: Coord): Coord

    abstract fun convertRect(to: String, rect: RectCoord): RectCoord

    abstract fun convertRectToRenderSystem(rect: RectCoord): RectCoord

    abstract fun convertQuad(to: String, quad: QuadCoord): QuadCoord

    abstract fun convertQuadToRenderSystem(quad: QuadCoord): QuadCoord

    abstract fun convertToRenderSystem(coordinate: Coord): Coord

    companion object {
        /**
         * This instance is independent of the map and does not know about the rendering system.
         * It can not be used to convert coordinates into rendering space.
         */
        @JvmStatic
        fun independentInstance(): CoordinateConversionHelperInterface {
            return CppProxy.independentInstance()
        }
    }

    private class CppProxy : CoordinateConversionHelperInterface {
        private val nativeRef: Long
        private val destroyed: AtomicBoolean = AtomicBoolean(false)

        private constructor(nativeRef: Long) {
            if (nativeRef == 0L) error("nativeRef is zero")
            this.nativeRef = nativeRef
        }

        private external fun nativeDestroy(nativeRef: Long)
        fun _djinni_private_destroy() {
            val destroyed = this.destroyed.getAndSet(true)
            if (!destroyed) nativeDestroy(this.nativeRef)
        }
        protected fun finalize() {
            _djinni_private_destroy()
        }

        override fun registerConverter(converter: CoordinateConverterInterface) {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            native_registerConverter(this.nativeRef, converter)
        }
        private external fun native_registerConverter(_nativeRef: Long, converter: CoordinateConverterInterface)

        override fun convert(to: String, coordinate: Coord): Coord {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            return native_convert(this.nativeRef, to, coordinate)
        }
        private external fun native_convert(_nativeRef: Long, to: String, coordinate: Coord): Coord

        override fun convertRect(to: String, rect: RectCoord): RectCoord {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            return native_convertRect(this.nativeRef, to, rect)
        }
        private external fun native_convertRect(_nativeRef: Long, to: String, rect: RectCoord): RectCoord

        override fun convertRectToRenderSystem(rect: RectCoord): RectCoord {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            return native_convertRectToRenderSystem(this.nativeRef, rect)
        }
        private external fun native_convertRectToRenderSystem(_nativeRef: Long, rect: RectCoord): RectCoord

        override fun convertQuad(to: String, quad: QuadCoord): QuadCoord {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            return native_convertQuad(this.nativeRef, to, quad)
        }
        private external fun native_convertQuad(_nativeRef: Long, to: String, quad: QuadCoord): QuadCoord

        override fun convertQuadToRenderSystem(quad: QuadCoord): QuadCoord {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            return native_convertQuadToRenderSystem(this.nativeRef, quad)
        }
        private external fun native_convertQuadToRenderSystem(_nativeRef: Long, quad: QuadCoord): QuadCoord

        override fun convertToRenderSystem(coordinate: Coord): Coord {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            return native_convertToRenderSystem(this.nativeRef, coordinate)
        }
        private external fun native_convertToRenderSystem(_nativeRef: Long, coordinate: Coord): Coord

        companion object {
            @JvmStatic
            external fun independentInstance(): CoordinateConversionHelperInterface
        }
    }
}
