/*
 * Copyright 2021 Open Raven Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.openraven.magpie.plugins.policy.output.text.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Policy {
  private String id;
  private String policyId;
  private String policyName;
  private String cloudProvider;
  private String description;
  private boolean enabled = true;
  private String version;

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getPolicyId() {
    return policyId;
  }

  public void setPolicyId(String policyId) {
    this.policyId = policyId;
  }

  public String getPolicyName() {
    return policyName;
  }

  public void setPolicyName(String policyName) {
    this.policyName = policyName;
  }

  public String getCloudProvider() {
    return cloudProvider;
  }

  public void setCloudProvider(String cloudProvider) {
    this.cloudProvider = cloudProvider;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public boolean isEnabled() {
    return enabled;
  }

  public void setEnabled(boolean enabled) {
    this.enabled = enabled;
  }

  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Policy policy = (Policy) o;

    if (id != null ? !id.equals(policy.id) : policy.id != null) return false;
    if (policyId != null ? !policyId.equals(policy.policyId) : policy.policyId != null) return false;
    return policyName != null ? policyName.equals(policy.policyName) : policy.policyName == null;
  }

  @Override
  public int hashCode() {
    int result = id != null ? id.hashCode() : 0;
    result = 31 * result + (policyId != null ? policyId.hashCode() : 0);
    result = 31 * result + (policyName != null ? policyName.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "Policy{" +
      "id='" + id + '\'' +
      ", policyId='" + policyId + '\'' +
      ", policyName='" + policyName + '\'' +
      ", cloudProvider='" + cloudProvider + '\'' +
      ", description='" + description + '\'' +
      ", enabled=" + enabled +
      ", version='" + version + '\'' +
      '}';
  }
}
