/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.policy.output.text;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.openraven.magpie.api.PolicyOutputPlugin;
import io.openraven.magpie.plugins.policy.output.text.analysis.IgnoredRule;
import io.openraven.magpie.plugins.policy.output.text.analysis.ScanResults;
import io.openraven.magpie.plugins.policy.output.text.analysis.Violation;
import io.openraven.magpie.plugins.policy.output.text.model.Policy;
import io.openraven.magpie.plugins.policy.output.text.model.Rule;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class TextReportPlugin
implements PolicyOutputPlugin<Void> {
    private static final String ID = "magpie.policy.output.text";
    private static final String BOLD_SET = "\u001b[1m";
    private static final String BOLD_RESET = "\u001b[0m";
    private static final int COLUMN_WIDTH = 60;
    private static final int GUID_COLUMN_WIDTH = 50;
    private static final int FILE_NAME_COLUMN_WIDTH = 55;
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private static final BiFunction<String, Integer, String> TRIM_BY_COLUMN_FUNCTION = (value, columnWidth) -> {
        String trimmedValue = value.replace(System.lineSeparator(), "");
        trimmedValue = trimmedValue.length() >= columnWidth ? trimmedValue.substring(0, columnWidth - "...".length() - 1) + "..." : trimmedValue;
        return trimmedValue;
    };

    public void generateReport(ObjectNode data) {
        ScanResults results = this.parseData(data);
        this.processMeta(results);
        this.processDisabledPolicies(results);
        if (!results.getViolations().isEmpty() || !results.getIgnoredRules().isEmpty()) {
            System.out.println("\u001b[1mScan Per-policy Details:\u001b[0m");
            Map violationMap = results.getViolations().stream().collect(Collectors.groupingBy(Violation::getPolicy, Collectors.toList()));
            Map<Policy, List<IgnoredRule>> ignoredRulesMap = results.getIgnoredRules().stream().collect(Collectors.groupingBy(IgnoredRule::getPolicy));
            results.getPolicies().forEach(policy -> {
                Optional.ofNullable((List)violationMap.get(policy)).ifPresent(violations -> this.processViolations((Policy)policy, (List<Violation>)violations));
                Optional.ofNullable((List)ignoredRulesMap.get(policy)).ifPresent(this::processIgnoredRules);
                System.out.println("");
            });
        }
    }

    private void processIgnoredRules(List<IgnoredRule> ignoredRules) {
        System.out.printf("%-30s\n", "Ignored rules");
        System.out.printf("\u001b[1m%-2s%-60s%-55s%-60s\n\u001b[0m", "", "Rule name", "Rule file name", "Reason");
        ignoredRules.forEach(ignoredRule -> System.out.printf("%-2s%-60s%-55s%-60s\n", "", TRIM_BY_COLUMN_FUNCTION.apply(ignoredRule.getRule().getRuleName(), 60), TRIM_BY_COLUMN_FUNCTION.apply(ignoredRule.getRule().getFileName(), 55), ignoredRule.getIgnoredReason().getReason()));
    }

    private void processViolations(Policy policy, List<Violation> policyViolations) {
        System.out.printf("%-30s%-40s\n", "Policy name", policy.getPolicyName());
        System.out.printf("%-30s%-40s\n", "No. of violations", policyViolations.size());
        System.out.printf("%-30s\n", "Violations");
        System.out.printf("\u001b[1m%-2s%-60s%-55s%-60s\n\u001b[0m", "", "Resource ID", "Rule file name", "Rule name");
        policyViolations.forEach(policyViolation -> {
            String resourceID = policyViolation.getAssetId().length() >= 60 ? "..." + policyViolation.getAssetId().substring(policyViolation.getAssetId().length() - 60 + "...".length() + 2) : policyViolation.getAssetId();
            Rule violatedRule = policyViolation.getRule();
            System.out.printf("%-2s%-60s%-55s%-60s\n", "", resourceID, TRIM_BY_COLUMN_FUNCTION.apply(violatedRule.getFileName(), 55), TRIM_BY_COLUMN_FUNCTION.apply(violatedRule.getRuleName(), 60));
        });
        System.out.println("");
    }

    private void processDisabledPolicies(ScanResults results) {
        List<Policy> disabledPolicies = results.getPolicies().stream().filter(policy -> !policy.isEnabled()).collect(Collectors.toList());
        if (!disabledPolicies.isEmpty()) {
            System.out.println("\u001b[1mDisabled policies:\u001b[0m");
            System.out.printf("\u001b[1m%-2s%-50s%-60s\n\u001b[0m", "", "Policy GUID", "Policy name");
            disabledPolicies.forEach(policy -> System.out.printf("%-2s%-50s%-60s\n", "", policy.getId(), policy.getPolicyName()));
            System.out.printf("\n", new Object[0]);
        }
    }

    private void processMeta(ScanResults results) {
        System.out.println("\u001b[1mScan Summary:\u001b[0m");
        System.out.printf("%-30s%-40s\n", "Scan start time", results.getScanMetadata().getStartDateTime().toString());
        System.out.printf("%-30s%-40s\n", "Scan duration", this.humanReadableFormat(results.getScanMetadata().getDuration()));
        System.out.printf("%-30s%-40d\n\n", "Total violations found", results.getViolations().size());
    }

    private ScanResults parseData(ObjectNode data) {
        try {
            return (ScanResults)MAPPER.treeToValue((TreeNode)data, ScanResults.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to parse data for plugin: " + this.id(), e);
        }
    }

    private String humanReadableFormat(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    public String id() {
        return ID;
    }

    public void init(Void config, Logger logger) {
    }

    public void shutdown() {
        super.shutdown();
    }

    public Class<Void> configType() {
        return null;
    }
}

