/*
 * Decompiled with CFR 0.152.
 */
package org.openscore.engine.data;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class DataBaseDetector {
    private final Logger logger = Logger.getLogger(this.getClass());
    private static final String MSSQL_PRODUCT_NAME = "Microsoft SQL Server";
    private static final String ORACLE_PRODUCT_NAME = "Oracle";
    @Autowired
    private DataSource dataSource;

    public boolean isMssql() {
        return this.isDataBaseMatch(MSSQL_PRODUCT_NAME);
    }

    public boolean isOracle() {
        return this.isDataBaseMatch(ORACLE_PRODUCT_NAME);
    }

    private boolean isDataBaseMatch(String databaseName) {
        boolean match = false;
        try (Connection conn = this.dataSource.getConnection();){
            if (conn != null) {
                match = conn.getMetaData().getDatabaseProductName().equals(databaseName);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"Couldn't get database connection!", (Throwable)e);
            throw new RuntimeException("Couldn't get database connection!", e);
        }
        return match;
    }
}

