/*
 * Decompiled with CFR 0.152.
 */
package org.openscore.engine.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.springframework.util.CollectionUtils;

public class SqlInQueryReader {
    private final int DATABASE_IN_CLAUSE_LIMIT = 1000;

    public <T> List<T> read(Set<String> items, SqlInQueryCallback<T> callback) {
        Validate.notNull(callback);
        if (items == null) {
            return Collections.emptyList();
        }
        return this.readItems(items, callback);
    }

    private <T> List<T> readItems(Set<String> items, SqlInQueryCallback<T> callback) {
        HashSet<String> source = new HashSet<String>(items);
        LinkedList<T> results = new LinkedList<T>();
        do {
            Set<String> itemsToRead;
            List<T> result;
            if ((result = callback.readItems(itemsToRead = this.extractAndRemoveUpToLimit(source, 1000))) == null) continue;
            results.addAll(result);
        } while (!CollectionUtils.isEmpty(source));
        return results;
    }

    private Set<String> extractAndRemoveUpToLimit(Set<String> source, int limit) {
        HashSet<String> result = new HashSet<String>();
        Iterator<String> iterator = source.iterator();
        while (iterator.hasNext() && result.size() < limit) {
            result.add(iterator.next());
            iterator.remove();
        }
        return result;
    }

    public static interface SqlInQueryCallback<T> {
        public List<T> readItems(Set<String> var1);
    }
}

