/*
 * Decompiled with CFR 0.152.
 */
package org.openscore.engine.data;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.openscore.engine.data.DataBaseDetector;
import org.springframework.beans.factory.annotation.Autowired;

public class SqlUtils {
    public static final String ESCAPE_CHAR = "~";
    public static final String ESCAPE_EXPRESSION = "escape '~'";
    private static final String DOUBLE_ESCAPE_CHAR = "~~";
    private static final String[] NON_MSSQL_SPECIAL_CHARS = new String[]{"%", "_"};
    private static final String[] MSSQL_SPECIAL_CHARS;
    @Autowired
    private DataBaseDetector dataBaseDetector;
    private String[] currentSpecialCharsSet;

    @PostConstruct
    private void setSpecialCharsSet() {
        this.currentSpecialCharsSet = this.dataBaseDetector.isMssql() ? MSSQL_SPECIAL_CHARS : NON_MSSQL_SPECIAL_CHARS;
    }

    public String escapeLikeExpression(String likeExpression) {
        String normalizeLikeExpression = likeExpression;
        if (likeExpression != null && !likeExpression.isEmpty()) {
            normalizeLikeExpression = normalizeLikeExpression.replace(ESCAPE_CHAR, DOUBLE_ESCAPE_CHAR);
            for (String charToEscape : this.currentSpecialCharsSet) {
                normalizeLikeExpression = normalizeLikeExpression.replace(charToEscape, ESCAPE_CHAR + charToEscape);
            }
        }
        return normalizeLikeExpression;
    }

    public String normalizeStartingWithLikeExpression(String expression) {
        return expression + "%";
    }

    public String normalizeEndingWithLikeExpression(String expression) {
        return "%" + expression;
    }

    public String normalizeContainingLikeExpression(String expression) {
        return "%" + expression + "%";
    }

    static {
        ArrayList<String> mssqlSpecialCharsList = new ArrayList<String>(Arrays.asList(NON_MSSQL_SPECIAL_CHARS));
        mssqlSpecialCharsList.addAll(Arrays.asList("[", "]"));
        MSSQL_SPECIAL_CHARS = mssqlSpecialCharsList.toArray(new String[mssqlSpecialCharsList.size()]);
    }
}

