/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JdkHttpClient {
    private static final Logger logger = Logger.getLogger(JdkHttpClient.class.getName());
    private static final int TIMEOUT_MILLIS = 2000;

    JdkHttpClient() {
    }

    String fetchString(String httpMethod, String urlStr, Map<String, String> requestPropertyMap, @Nullable String certPath) {
        return this.fetchString(httpMethod, urlStr, requestPropertyMap, certPath, null);
    }

    String fetchString(String httpMethod, String urlStr, Map<String, String> requestPropertyMap, @Nullable String certPath, @Nullable byte[] requestBody) {
        try {
            int responseCode;
            HttpURLConnection connection;
            if (urlStr.startsWith("https")) {
                connection = (HttpURLConnection)new URL(urlStr).openConnection();
                KeyStore keyStore = JdkHttpClient.getKeystoreForTrustedCert(certPath);
                if (keyStore != null) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(JdkHttpClient.buildSslSocketFactory(keyStore));
                }
            } else {
                connection = (HttpURLConnection)new URL(urlStr).openConnection();
            }
            connection.setRequestMethod(httpMethod);
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            for (Map.Entry entry : requestPropertyMap.entrySet()) {
                connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            if (requestBody != null) {
                connection.setDoOutput(true);
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(requestBody);
                }
            }
            if ((responseCode = connection.getResponseCode()) != 200) {
                logger.log(Level.FINE, "Error response from " + urlStr + " code (" + responseCode + ") text " + JdkHttpClient.readResponseString(connection));
                return "";
            }
            return JdkHttpClient.readResponseString(connection).trim();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "JdkHttpClient fetch string failed.", e);
            return "";
        }
    }

    private static String readResponseString(HttpURLConnection connection) {
        InputStream is2;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            is2 = connection.getInputStream();
            try {
                JdkHttpClient.readTo(is2, os);
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        catch (IOException is2) {
            // empty catch block
        }
        try {
            is2 = connection.getErrorStream();
            try {
                if (is2 != null) {
                    JdkHttpClient.readTo(is2, os);
                }
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        catch (IOException is3) {
            // empty catch block
        }
        try {
            return os.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.WARNING, "UTF-8 not supported can't happen.", e);
            return "";
        }
    }

    private static SSLSocketFactory buildSslSocketFactory(KeyStore keyStore) {
        try {
            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            tmf.init(keyStore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, tmf.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Build SslSocketFactory for K8s restful client exception.", e);
            return null;
        }
    }

    private static KeyStore getKeystoreForTrustedCert(String certPath) {
        KeyStore keyStore;
        FileInputStream fis = new FileInputStream(certPath);
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(fis);
            int i = 0;
            for (Certificate certificate : certificates) {
                trustStore.setCertificateEntry("cert_" + i, certificate);
                ++i;
            }
            keyStore = trustStore;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Cannot load KeyStore from " + certPath);
                return null;
            }
        }
        fis.close();
        return keyStore;
    }

    private static void readTo(@Nullable InputStream is, ByteArrayOutputStream os) throws IOException {
        int read;
        if (is == null) {
            return;
        }
        byte[] buf = new byte[8192];
        while ((read = is.read(buf)) > 0) {
            os.write(buf, 0, read);
        }
    }
}

