/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.okhttp;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

final class ProtoRequestBody
extends RequestBody {
    private static final MediaType PROTOBUF_MEDIA_TYPE = MediaType.parse("application/x-protobuf");
    private final Marshaler marshaler;
    private final int contentLength;

    public ProtoRequestBody(Marshaler marshaler) {
        this.marshaler = marshaler;
        this.contentLength = marshaler.getBinarySerializedSize();
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public MediaType contentType() {
        return PROTOBUF_MEDIA_TYPE;
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        this.marshaler.writeBinaryTo(bufferedSink.outputStream());
    }
}

