/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxmetrics;

import groovy.lang.Closure;
import groovy.lang.Tuple2;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import io.opentelemetry.contrib.jmxmetrics.InstrumentDescriptor;
import io.opentelemetry.contrib.jmxmetrics.JmxConfig;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GroovyMetricEnvironment {
    private final SdkMeterProvider meterProvider;
    private final Meter meter;
    private final Map<Integer, AtomicReference<Consumer<ObservableLongMeasurement>>> longUpdaterRegistry = new ConcurrentHashMap<Integer, AtomicReference<Consumer<ObservableLongMeasurement>>>();
    private final Map<Integer, AtomicReference<Consumer<ObservableDoubleMeasurement>>> doubleUpdaterRegistry = new ConcurrentHashMap<Integer, AtomicReference<Consumer<ObservableDoubleMeasurement>>>();
    private final Map<Integer, AtomicReference<Closure<?>>> batchUpdaterRegistry = new ConcurrentHashMap();
    private final Map<Integer, Tuple2<BatchCallback, Set<ObservableMeasurement>>> batchCallbackRegistry = new ConcurrentHashMap<Integer, Tuple2<BatchCallback, Set<ObservableMeasurement>>>();
    private final Map<Integer, ObservableMeasurement> instrumentOnceRegistry = new ConcurrentHashMap<Integer, ObservableMeasurement>();

    public GroovyMetricEnvironment(JmxConfig config, String instrumentationName, String instrumentationVersion) {
        switch (config.metricsExporterType.toLowerCase()) {
            case "otlp": 
            case "prometheus": 
            case "logging": {
                this.meterProvider = ((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("otel.traces.exporter", "none");
                    config.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, value) -> {
                        String key = k.toString();
                        if (key.startsWith("otel.") && !key.startsWith("otel.jmx")) {
                            properties.put(key, value.toString());
                        }
                    }));
                    return properties;
                })).build().getOpenTelemetrySdk().getSdkMeterProvider();
                break;
            }
            default: {
                this.meterProvider = SdkMeterProvider.builder().build();
            }
        }
        this.meter = this.meterProvider.meterBuilder(instrumentationName).setInstrumentationVersion(instrumentationVersion).build();
    }

    GroovyMetricEnvironment(SdkMeterProvider meterProvider, String instrumentationName) {
        this.meterProvider = meterProvider;
        this.meter = meterProvider.meterBuilder(instrumentationName).build();
    }

    public GroovyMetricEnvironment(JmxConfig config) {
        this(config, "io.opentelemetry.contrib.jmxmetrics", GroovyMetricEnvironment.class.getPackage().getImplementationVersion());
    }

    public void flush() {
        this.meterProvider.forceFlush().join(10L, TimeUnit.SECONDS);
    }

    protected static Attributes mapToAttributes(@Nullable Map<String, String> labelMap) {
        if (labelMap == null) {
            return Attributes.empty();
        }
        AttributesBuilder attrs = Attributes.builder();
        for (Map.Entry<String, String> kv : labelMap.entrySet()) {
            attrs.put(kv.getKey(), kv.getValue());
        }
        return attrs.build();
    }

    public DoubleCounter getDoubleCounter(String name, String description, String unit) {
        return this.meter.counterBuilder(name).setDescription(description).setUnit(unit).ofDoubles().build();
    }

    public LongCounter getLongCounter(String name, String description, String unit) {
        return this.meter.counterBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public DoubleUpDownCounter getDoubleUpDownCounter(String name, String description, String unit) {
        return this.meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit).ofDoubles().build();
    }

    public LongUpDownCounter getLongUpDownCounter(String name, String description, String unit) {
        return this.meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public DoubleHistogram getDoubleHistogram(String name, String description, String unit) {
        return this.meter.histogramBuilder(name).setDescription(description).setUnit(unit).build();
    }

    public LongHistogram getLongHistogram(String name, String description, String unit) {
        return this.meter.histogramBuilder(name).setDescription(description).setUnit(unit).ofLongs().build();
    }

    public ObservableDoubleMeasurement registerDoubleValueCallback(String name, String description, String unit, Consumer<ObservableDoubleMeasurement> updater) {
        int descriptorHash = InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.DOUBLE).hashCode();
        return this.registerCallback(this.doubleUpdaterRegistry, () -> this.meter.gaugeBuilder(name).setDescription(description).setUnit(unit).buildObserver(), descriptorHash, updater);
    }

    public ObservableLongMeasurement registerLongValueCallback(String name, String description, String unit, Consumer<ObservableLongMeasurement> updater) {
        int descriptorHash = InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.LONG).hashCode();
        return this.registerCallback(this.longUpdaterRegistry, () -> this.meter.gaugeBuilder(name).ofLongs().setDescription(description).setUnit(unit).buildObserver(), descriptorHash, updater);
    }

    public ObservableDoubleMeasurement registerDoubleCounterCallback(String name, String description, String unit, Consumer<ObservableDoubleMeasurement> updater) {
        int descriptorHash = InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_COUNTER, InstrumentValueType.DOUBLE).hashCode();
        return this.registerCallback(this.doubleUpdaterRegistry, () -> this.meter.counterBuilder(name).setDescription(description).setUnit(unit).ofDoubles().buildObserver(), descriptorHash, updater);
    }

    public ObservableLongMeasurement registerLongCounterCallback(String name, String description, String unit, Consumer<ObservableLongMeasurement> updater) {
        int descriptorHash = InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_COUNTER, InstrumentValueType.LONG).hashCode();
        return this.registerCallback(this.longUpdaterRegistry, () -> this.meter.counterBuilder(name).setDescription(description).setUnit(unit).buildObserver(), descriptorHash, updater);
    }

    public ObservableDoubleMeasurement registerDoubleUpDownCounterCallback(String name, String description, String unit, Consumer<ObservableDoubleMeasurement> updater) {
        int descriptorHash = InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, InstrumentValueType.DOUBLE).hashCode();
        return this.registerCallback(this.doubleUpdaterRegistry, () -> this.meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit).ofDoubles().buildObserver(), descriptorHash, updater);
    }

    public ObservableLongMeasurement registerLongUpDownCounterCallback(String name, String description, String unit, Consumer<ObservableLongMeasurement> updater) {
        int descriptorHash = InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, InstrumentValueType.LONG).hashCode();
        return this.registerCallback(this.longUpdaterRegistry, () -> this.meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit).buildObserver(), descriptorHash, updater);
    }

    private <T extends ObservableMeasurement> T registerCallback(Map<Integer, AtomicReference<Consumer<T>>> registry, Supplier<T> observerBuilder, int descriptorHash, Consumer<T> updater) {
        ObservableMeasurement obs = this.instrumentOnceRegistry.get(descriptorHash);
        if (obs == null) {
            ObservableMeasurement observer = (ObservableMeasurement)observerBuilder.get();
            this.instrumentOnceRegistry.put(descriptorHash, observer);
            if (updater != null) {
                Consumer cb = this.proxiedObserver(descriptorHash, registry, updater);
                this.meter.batchCallback(() -> cb.accept(observer), observer, new ObservableMeasurement[0]);
            }
            return (T)observer;
        }
        if (updater != null) {
            registry.get(descriptorHash).set(updater);
        }
        return (T)obs;
    }

    public void registerBatchCallback(Object identifier, Closure<?> callback, ObservableMeasurement measurement, ObservableMeasurement ... additional) {
        int hash = identifier.hashCode();
        this.batchUpdaterRegistry.putIfAbsent(hash, new AtomicReference());
        this.batchUpdaterRegistry.get(hash).set(callback);
        Set instrumentSet = Arrays.stream(additional).collect(Collectors.toCollection(HashSet::new));
        instrumentSet.add(measurement);
        Tuple2<BatchCallback, Set<ObservableMeasurement>> existingCallback = this.batchCallbackRegistry.get(hash);
        if (existingCallback == null || !existingCallback.getV2().equals(instrumentSet)) {
            if (existingCallback != null) {
                existingCallback.getV1().close();
            }
            this.batchCallbackRegistry.put(hash, new Tuple2<BatchCallback, Set>(this.meter.batchCallback(() -> this.batchUpdaterRegistry.get(hash).get().call(), measurement, additional), instrumentSet));
        }
    }

    private <T extends ObservableMeasurement> Consumer<T> proxiedObserver(int descriptorHash, Map<Integer, AtomicReference<Consumer<T>>> registry, Consumer<T> updater) {
        registry.putIfAbsent(descriptorHash, new AtomicReference());
        registry.get(descriptorHash).set(updater);
        return result -> ((Consumer)((AtomicReference)registry.get(descriptorHash)).get()).accept(result);
    }
}

