/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jmxmetrics;

import io.opentelemetry.contrib.jmxmetrics.ConfigurationException;
import io.opentelemetry.contrib.jmxmetrics.GroovyMetricEnvironment;
import io.opentelemetry.contrib.jmxmetrics.GroovyRunner;
import io.opentelemetry.contrib.jmxmetrics.JmxClient;
import io.opentelemetry.contrib.jmxmetrics.JmxConfig;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class JmxMetrics {
    private static final Logger logger = Logger.getLogger(JmxMetrics.class.getName());
    private final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
    private final GroovyRunner runner;
    private final JmxConfig config;

    JmxMetrics(JmxConfig config) {
        JmxClient jmxClient;
        this.config = config;
        try {
            jmxClient = new JmxClient(config);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Malformed serviceUrl: ", e);
        }
        this.runner = new GroovyRunner(config, jmxClient, new GroovyMetricEnvironment(config));
    }

    private void start() {
        this.exec.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    JmxMetrics.this.runner.run();
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Error gathering JMX metrics", e);
                }
            }
        }, 0L, this.config.intervalMilliseconds, TimeUnit.MILLISECONDS);
        logger.info("Started GroovyRunner.");
    }

    private void shutdown() {
        logger.info("Shutting down JmxMetrics Groovy runner and exporting final metrics.");
        this.exec.shutdown();
    }

    private static JmxConfig getConfigFromArgs(String[] args2) {
        if (!(args2.length == 0 || args2.length == 2 && args2[0].equalsIgnoreCase("-config"))) {
            System.out.println("Usage: java io.opentelemetry.contrib.jmxmetrics.JmxMetrics -config <path_to_config.properties or - for stdin>");
            System.exit(1);
        }
        Properties props = new Properties();
        if (args2.length == 2) {
            String path = args2[1];
            if (path.trim().equals("-")) {
                JmxMetrics.loadPropertiesFromStdin(props);
            } else {
                JmxMetrics.loadPropertiesFromPath(props, path);
            }
        }
        return new JmxConfig(props);
    }

    private static void loadPropertiesFromStdin(Properties props) {
        try (DataInputStream is = new DataInputStream(System.in);){
            props.load(is);
        }
        catch (IOException e) {
            System.out.println("Failed to read config properties from stdin: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void loadPropertiesFromPath(Properties props, String path) {
        try (FileInputStream is = new FileInputStream(path);){
            props.load(is);
        }
        catch (IOException e) {
            System.out.println("Failed to read config properties file at '" + path + "': " + e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args2) {
        JmxConfig config = JmxMetrics.getConfigFromArgs(args2);
        config.validate();
        final JmxMetrics jmxMetrics = new JmxMetrics(config);
        jmxMetrics.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                jmxMetrics.shutdown();
            }
        });
    }
}

