/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.exporter.prometheus.AutoValue_PrometheusMetricNameMapper_ImmutableMappingKey;
import io.opentelemetry.exporter.prometheus.NameSanitizer;
import io.opentelemetry.exporter.prometheus.PrometheusType;
import io.opentelemetry.exporter.prometheus.PrometheusUnitsHelper;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.annotation.concurrent.Immutable;

class PrometheusMetricNameMapper
implements BiFunction<MetricData, PrometheusType, String> {
    private static final String TOTAL_SUFFIX = "_total";
    static final PrometheusMetricNameMapper INSTANCE = new PrometheusMetricNameMapper();
    private final Map<ImmutableMappingKey, String> cache = new ConcurrentHashMap<ImmutableMappingKey, String>();
    private final BiFunction<MetricData, PrometheusType, String> delegate;

    private PrometheusMetricNameMapper() {
        this(PrometheusMetricNameMapper::mapToPrometheusName);
    }

    PrometheusMetricNameMapper(BiFunction<MetricData, PrometheusType, String> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String apply(MetricData rawMetric, PrometheusType prometheusType) {
        return this.cache.computeIfAbsent(PrometheusMetricNameMapper.createKeyForCacheMapping(rawMetric, prometheusType), metricData -> this.delegate.apply(rawMetric, prometheusType));
    }

    private static String mapToPrometheusName(MetricData rawMetric, PrometheusType prometheusType) {
        boolean shouldAppendUnit;
        String name = NameSanitizer.INSTANCE.apply(rawMetric.getName());
        String prometheusEquivalentUnit = PrometheusUnitsHelper.getEquivalentPrometheusUnit(rawMetric.getUnit());
        boolean bl = shouldAppendUnit = !StringUtils.isNullOrEmpty(prometheusEquivalentUnit) && !name.contains(prometheusEquivalentUnit);
        if (prometheusType == PrometheusType.COUNTER && name.endsWith(TOTAL_SUFFIX)) {
            name = name.substring(0, name.length() - TOTAL_SUFFIX.length());
        }
        if (shouldAppendUnit) {
            name = name + "_" + prometheusEquivalentUnit;
        }
        if (prometheusType == PrometheusType.COUNTER) {
            name = name + TOTAL_SUFFIX;
        }
        if (rawMetric.getUnit().equals("1") && prometheusType == PrometheusType.GAUGE && !name.contains("ratio")) {
            name = name + "_ratio";
        }
        return name;
    }

    private static ImmutableMappingKey createKeyForCacheMapping(MetricData metricData, PrometheusType prometheusType) {
        return ImmutableMappingKey.create(metricData.getName(), metricData.getUnit(), prometheusType.name());
    }

    @Immutable
    @AutoValue
    static abstract class ImmutableMappingKey {
        ImmutableMappingKey() {
        }

        static ImmutableMappingKey create(String rawMetricName, String rawMetricUnit, String prometheusType) {
            return new AutoValue_PrometheusMetricNameMapper_ImmutableMappingKey(rawMetricName, rawMetricUnit, prometheusType);
        }

        abstract String rawMetricName();

        abstract String rawMetricUnit();

        abstract String prometheusType();
    }
}

