/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.DoublePointAssert;
import java.util.Arrays;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public final class DoubleSumAssert
extends AbstractAssert<DoubleSumAssert, SumData<DoublePointData>> {
    DoubleSumAssert(SumData<DoublePointData> actual) {
        super(actual, DoubleSumAssert.class);
    }

    public DoubleSumAssert isMonotonic() {
        this.isNotNull();
        if (!((SumData)this.actual).isMonotonic()) {
            this.failWithActualExpectedAndMessage(this.actual, "monotonic: true", "Expected Sum to be monotonic", new Object[]{true, ((SumData)this.actual).isMonotonic()});
        }
        return (DoubleSumAssert)this.myself;
    }

    public DoubleSumAssert isNotMonotonic() {
        this.isNotNull();
        if (((SumData)this.actual).isMonotonic()) {
            this.failWithActualExpectedAndMessage(this.actual, "monotonic: fail", "Expected Sum to be non-monotonic, found: %s", new Object[]{((SumData)this.actual).isMonotonic()});
        }
        return (DoubleSumAssert)this.myself;
    }

    public DoubleSumAssert isCumulative() {
        this.isNotNull();
        if (((SumData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Sum to have cumulative aggregation but found <%s>", new Object[]{((SumData)this.actual).getAggregationTemporality()});
        }
        return (DoubleSumAssert)this.myself;
    }

    public DoubleSumAssert isDelta() {
        this.isNotNull();
        if (((SumData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Sum to have delta aggregation but found <%s>", new Object[]{((SumData)this.actual).getAggregationTemporality()});
        }
        return (DoubleSumAssert)this.myself;
    }

    @SafeVarargs
    public final DoubleSumAssert hasPointsSatisfying(Consumer<DoublePointAssert> ... assertions) {
        return this.hasPointsSatisfying(Arrays.asList(assertions));
    }

    public DoubleSumAssert hasPointsSatisfying(Iterable<? extends Consumer<DoublePointAssert>> assertions) {
        Assertions.assertThat(((SumData)this.actual).getPoints()).satisfiesExactlyInAnyOrder((Consumer[])AssertUtil.toConsumers(assertions, DoublePointAssert::new));
        return this;
    }
}

