/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.AttributesAssert;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public final class ResourceAssert
extends AbstractAssert<ResourceAssert, Resource> {
    private final String label;

    ResourceAssert(Resource resource, String label) {
        super((Object)resource, ResourceAssert.class);
        this.label = label;
    }

    public ResourceAssert hasSchemaUrl(@Nullable String schemaUrl) {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((Resource)this.actual).getSchemaUrl()).as("resource schema URL of %s", new Object[]{this.label})).isEqualTo(schemaUrl);
        return this;
    }

    public <T> ResourceAssert hasAttribute(AttributeKey<T> key, T value) {
        return this.hasAttribute(OpenTelemetryAssertions.equalTo(key, value));
    }

    public ResourceAssert hasAttribute(AttributeAssertion attributeAssertion) {
        this.isNotNull();
        Set<AttributeKey<?>> actualKeys = ((Resource)this.actual).getAttributes().asMap().keySet();
        AttributeKey<?> key = attributeAssertion.getKey();
        ((AbstractCollectionAssert)Assertions.assertThat(actualKeys).as("resource attribute keys of %s", new Object[]{this.label})).contains((Object[])new AttributeKey[]{key});
        Object value = ((Resource)this.actual).getAttributes().get(key);
        AbstractAssert<?, ?> assertion = AttributeAssertion.attributeValueAssertion(key, value);
        attributeAssertion.getAssertion().accept(assertion);
        return this;
    }

    public ResourceAssert hasAttributes(Attributes attributes) {
        this.isNotNull();
        if (!AssertUtil.attributesAreEqual(((Resource)this.actual).getAttributes(), attributes)) {
            this.failWithActualExpectedAndMessage(((Resource)this.actual).getAttributes(), attributes, "Expected resource of <%s> to have attributes <%s> but was <%s>", new Object[]{this.label, attributes, ((Resource)this.actual).getAttributes()});
        }
        return this;
    }

    @SafeVarargs
    public final ResourceAssert hasAttributes(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<AttributeKey<?>, ?> entry : entries) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
        Attributes attributes = attributesBuilder.build();
        return this.hasAttributes(attributes);
    }

    public ResourceAssert hasAttributesSatisfying(Consumer<Attributes> attributes) {
        this.isNotNull();
        ((AttributesAssert)((Object)OpenTelemetryAssertions.assertThat(((Resource)this.actual).getAttributes()).as("resource attributes of %s", new Object[]{this.label}))).satisfies(new Consumer[]{attributes});
        return this;
    }

    public ResourceAssert hasAttributesSatisfying(AttributeAssertion ... assertions) {
        return this.hasAttributesSatisfying(Arrays.asList(assertions));
    }

    public ResourceAssert hasAttributesSatisfying(Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributes(((Resource)this.actual).getAttributes(), assertions, String.format("resource of %s attribute keys", this.label));
        return this;
    }

    public ResourceAssert hasAttributesSatisfyingExactly(AttributeAssertion ... assertions) {
        return this.hasAttributesSatisfyingExactly(Arrays.asList(assertions));
    }

    public ResourceAssert hasAttributesSatisfyingExactly(Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributesExactly(((Resource)this.actual).getAttributes(), assertions, String.format("resource of %s attribute keys", this.label));
        return this;
    }
}

