/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.junit4;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.SdkMeterProviderUtil;
import io.opentelemetry.sdk.testing.exporter.InMemoryLogRecordExporter;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.ExternalResource;

public final class OpenTelemetryRule
extends ExternalResource {
    private final OpenTelemetrySdk openTelemetry;
    private final InMemorySpanExporter spanExporter;
    private final InMemoryMetricReader metricReader;
    private final InMemoryLogRecordExporter logRecordExporter;

    public static OpenTelemetryRule create() {
        InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create(spanExporter)).build();
        InMemoryMetricReader metricReader = InMemoryMetricReader.create();
        SdkMeterProvider meterProvider = SdkMeterProvider.builder().registerMetricReader(metricReader).build();
        InMemoryLogRecordExporter logRecordExporter = InMemoryLogRecordExporter.create();
        SdkLoggerProvider loggerProvider = SdkLoggerProvider.builder().addLogRecordProcessor(SimpleLogRecordProcessor.create(logRecordExporter)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create(W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).setMeterProvider(meterProvider).setLoggerProvider(loggerProvider).build();
        return new OpenTelemetryRule(openTelemetry, spanExporter, metricReader, logRecordExporter);
    }

    private OpenTelemetryRule(OpenTelemetrySdk openTelemetry, InMemorySpanExporter spanExporter, InMemoryMetricReader metricReader, InMemoryLogRecordExporter logRecordExporter) {
        this.openTelemetry = openTelemetry;
        this.spanExporter = spanExporter;
        this.metricReader = metricReader;
        this.logRecordExporter = logRecordExporter;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public List<SpanData> getSpans() {
        return this.spanExporter.getFinishedSpanItems();
    }

    public List<MetricData> getMetrics() {
        return new ArrayList<MetricData>(this.metricReader.collectAllMetrics());
    }

    public List<LogRecordData> getLogRecords() {
        return new ArrayList<LogRecordData>(this.logRecordExporter.getFinishedLogRecordItems());
    }

    public void clearSpans() {
        this.spanExporter.reset();
    }

    public void clearMetrics() {
        SdkMeterProviderUtil.resetForTest(this.openTelemetry.getSdkMeterProvider());
    }

    public void clearLogRecords() {
        this.logRecordExporter.reset();
    }

    protected void before() {
        GlobalOpenTelemetry.resetForTest();
        GlobalOpenTelemetry.set(this.openTelemetry);
        this.clearSpans();
        this.clearMetrics();
        this.clearLogRecords();
    }

    protected void after() {
        GlobalOpenTelemetry.resetForTest();
    }
}

