/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin;

import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.vmplugin.VMPlugin;

public class VMPluginFactory {
    private static final Logger LOGGER = Logger.getLogger(VMPluginFactory.class.getName());
    private static final String JDK8_CLASSNAME_CHECK = "java.util.Optional";
    private static final String JDK9_CLASSNAME_CHECK = "java.lang.Module";
    private static final String JDK8_PLUGIN_NAME = "org.codehaus.groovy.vmplugin.v8.Java8";
    private static final String JDK9_PLUGIN_NAME = "org.codehaus.groovy.vmplugin.v9.Java9";
    private static final VMPlugin PLUGIN;

    public static VMPlugin getPlugin() {
        return PLUGIN;
    }

    private static VMPlugin createPlugin(String classNameCheck, String pluginName) {
        return AccessController.doPrivileged(() -> {
            try {
                ClassLoader loader = VMPluginFactory.class.getClassLoader();
                loader.loadClass(classNameCheck);
                return (VMPlugin)loader.loadClass(pluginName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t2) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Trying to create VM plugin `" + pluginName + "` by checking `" + classNameCheck + "`, but failed:\n" + DefaultGroovyMethods.asString(t2));
                }
                return null;
            }
        });
    }

    static {
        VMPlugin target = VMPluginFactory.createPlugin(JDK9_CLASSNAME_CHECK, JDK9_PLUGIN_NAME);
        if (target == null) {
            target = VMPluginFactory.createPlugin(JDK8_CLASSNAME_CHECK, JDK8_PLUGIN_NAME);
        }
        PLUGIN = target;
    }
}

