/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.opt.security.SASLInputStream;
import com.sun.jmx.remote.opt.security.SASLOutputStream;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.SASLMessage;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;

public class SASLServerHandler
implements ProfileServer {
    private SaslServer saslServer = null;
    private byte[] blob = null;
    private Map env = null;
    private MessageConnection mc = null;
    private Socket socket = null;
    private String mechanism = null;
    private String profile = null;
    private Subject subject = null;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SASLServerHandler");

    public SASLServerHandler(String profile, Map env) {
        this.profile = profile;
        this.env = env;
    }

    @Override
    public void initialize(MessageConnection mc, Subject s2) throws IOException {
        this.mc = mc;
        this.subject = s2;
        if (!(mc instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        this.socket = ((SocketConnectionIf)((Object)mc)).getSocket();
        this.mechanism = this.profile.substring(this.profile.indexOf("SASL/") + 5);
        String server = (String)this.env.get("jmx.remote.x.sasl.server.name");
        if (server == null) {
            server = this.socket.getLocalAddress().getHostName();
        }
        CallbackHandler cbh = (CallbackHandler)this.env.get("jmx.remote.sasl.callback.handler");
        this.saslServer = Sasl.createSaslServer(this.mechanism, "jmxmp", server, this.env, cbh);
        if (this.saslServer == null) {
            String detail = "Unable to create SASL server connection for authentication mechanism [" + this.mechanism + "]";
            throw new IOException(detail);
        }
    }

    @Override
    public ProfileMessage produceMessage() throws IOException {
        int status = this.saslServer.isComplete() ? 2 : 1;
        SASLMessage challenge = new SASLMessage(this.mechanism, status, this.blob);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> SASL server message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + challenge.getProfileName());
            logger.trace("produceMessage", "Status : " + challenge.getStatus());
        }
        return challenge;
    }

    @Override
    public void consumeMessage(ProfileMessage pm) throws IOException {
        if (!(pm instanceof SASLMessage)) {
            throw new IOException("Unexpected profile message type: " + pm.getClass().getName());
        }
        SASLMessage response = (SASLMessage)pm;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> SASL client message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + response.getProfileName());
            logger.trace("consumeMessage", "Status : " + response.getStatus());
        }
        if (response.getStatus() != 1) {
            throw new IOException("Unexpected SASL status [" + response.getStatus() + "]");
        }
        if (this.saslServer.isComplete()) {
            throw new IOException("SASL authentication complete despite the client claim for non-completion");
        }
        this.blob = this.saslServer.evaluateResponse(response.getBlob());
    }

    @Override
    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    @Override
    public Subject activate() throws IOException {
        String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        if (qop != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
            SASLInputStream saslis = new SASLInputStream(this.saslServer, this.socket.getInputStream());
            SASLOutputStream saslos = new SASLOutputStream(this.saslServer, this.socket.getOutputStream());
            ((SocketConnectionIf)((Object)this.mc)).replaceStreams(saslis, saslos);
        }
        String authorizationId = this.saslServer.getAuthorizationID();
        final JMXPrincipal principal = new JMXPrincipal(authorizationId);
        if (this.subject == null) {
            this.subject = new Subject();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SASLServerHandler.this.subject.getPrincipals().add(principal);
                return null;
            }
        });
        return this.subject;
    }

    @Override
    public void terminate() throws IOException {
        this.saslServer.dispose();
    }

    @Override
    public String getName() {
        return this.profile;
    }
}

