/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.TLSMessage;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import javax.security.cert.X509Certificate;

public class TLSServerHandler
implements ProfileServer {
    static final boolean bundledJSSE;
    static Method getProtocol;
    static Method getEnabledProtocols;
    static Method setEnabledProtocols;
    static Method getWantClientAuth;
    static Method setWantClientAuth;
    protected SSLSocket ts = null;
    private boolean completed = false;
    private Map env = null;
    private MessageConnection mc = null;
    private String profile = null;
    private Subject subject = null;
    private static final String X500_PRINCIPAL = "javax.security.auth.x500.X500Principal";
    private static final ClassLogger logger;

    static String getProtocol(SSLSession s2) throws IOException {
        try {
            return (String)getProtocol.invoke((Object)s2, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t2) {
            throw (IOException)EnvHelp.initCause(new IOException(t2.getMessage()), t2);
        }
    }

    static String[] getEnabledProtocols(SSLSocket s2) throws IOException {
        try {
            return (String[])getEnabledProtocols.invoke((Object)s2, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t2) {
            throw (IOException)EnvHelp.initCause(new IOException(t2.getMessage()), t2);
        }
    }

    static void setEnabledProtocols(SSLSocket s2, String[] p) throws IOException {
        try {
            setEnabledProtocols.invoke((Object)s2, new Object[]{p});
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t2) {
            throw (IOException)EnvHelp.initCause(new IOException(t2.getMessage()), t2);
        }
    }

    static Boolean getWantClientAuth(SSLSocket s2) throws IOException {
        try {
            return (Boolean)getWantClientAuth.invoke((Object)s2, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t2) {
            throw (IOException)EnvHelp.initCause(new IOException(t2.getMessage()), t2);
        }
    }

    static void setWantClientAuth(SSLSocket s2, Boolean b) throws IOException {
        try {
            setWantClientAuth.invoke((Object)s2, b);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
        catch (Throwable t2) {
            throw (IOException)EnvHelp.initCause(new IOException(t2.getMessage()), t2);
        }
    }

    public TLSServerHandler(String profile, Map env) {
        this.profile = profile;
        this.env = env;
    }

    @Override
    public void initialize(MessageConnection mc, Subject s2) throws IOException {
        String needClientAuth;
        String enabledCipherSuites;
        int i;
        int tokens;
        StringTokenizer st;
        this.mc = mc;
        this.subject = s2;
        Socket socket = null;
        if (!(mc instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        socket = ((SocketConnectionIf)((Object)mc)).getSocket();
        SSLSocketFactory ssf = (SSLSocketFactory)this.env.get("jmx.remote.tls.socket.factory");
        if (ssf == null) {
            ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        String hostname = socket.getInetAddress().getHostName();
        int port = socket.getPort();
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Hostname = " + hostname);
            logger.trace("initialize", "TLS: Port = " + port);
        }
        this.ts = (SSLSocket)ssf.createSocket(socket, hostname, port, true);
        this.ts.setUseClientMode(false);
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Client Mode = " + this.ts.getUseClientMode());
        }
        if (bundledJSSE) {
            String enabledProtocols = (String)this.env.get("jmx.remote.tls.enabled.protocols");
            if (enabledProtocols != null) {
                st = new StringTokenizer(enabledProtocols, " ");
                tokens = st.countTokens();
                String[] enabledProtocolsList = new String[tokens];
                for (i = 0; i < tokens; ++i) {
                    enabledProtocolsList[i] = st.nextToken();
                }
                TLSServerHandler.setEnabledProtocols(this.ts, enabledProtocolsList);
            }
            if (logger.traceOn()) {
                logger.trace("initialize", "TLS: Enabled Protocols");
                String[] enabled_p = TLSServerHandler.getEnabledProtocols(this.ts);
                if (enabled_p != null) {
                    StringBuffer str_buffer = new StringBuffer();
                    for (int i2 = 0; i2 < enabled_p.length; ++i2) {
                        str_buffer.append(enabled_p[i2]);
                        if (i2 + 1 >= enabled_p.length) continue;
                        str_buffer.append(", ");
                    }
                    logger.trace("initialize", "TLS: [" + str_buffer + "]");
                } else {
                    logger.trace("initialize", "TLS: []");
                }
            }
        }
        if ((enabledCipherSuites = (String)this.env.get("jmx.remote.tls.enabled.cipher.suites")) != null) {
            st = new StringTokenizer(enabledCipherSuites, " ");
            tokens = st.countTokens();
            String[] enabledCipherSuitesList = new String[tokens];
            for (i = 0; i < tokens; ++i) {
                enabledCipherSuitesList[i] = st.nextToken();
            }
            this.ts.setEnabledCipherSuites(enabledCipherSuitesList);
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Enabled Cipher Suites");
            String[] enabled_cs = this.ts.getEnabledCipherSuites();
            if (enabled_cs != null) {
                StringBuffer str_buffer = new StringBuffer();
                for (int i3 = 0; i3 < enabled_cs.length; ++i3) {
                    str_buffer.append(enabled_cs[i3]);
                    if (i3 + 1 >= enabled_cs.length) continue;
                    str_buffer.append(", ");
                }
                logger.trace("initialize", "TLS: [" + str_buffer + "]");
            } else {
                logger.trace("initialize", "TLS: []");
            }
        }
        if ((needClientAuth = (String)this.env.get("jmx.remote.tls.need.client.authentication")) != null) {
            this.ts.setNeedClientAuth(Boolean.valueOf(needClientAuth));
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Need Client Authentication = " + this.ts.getNeedClientAuth());
        }
        if (bundledJSSE) {
            String wantClientAuth = (String)this.env.get("jmx.remote.tls.want.client.authentication");
            if (wantClientAuth != null) {
                TLSServerHandler.setWantClientAuth(this.ts, Boolean.valueOf(wantClientAuth));
            }
            if (logger.traceOn()) {
                logger.trace("initialize", "TLS: Socket Want Client Authentication = " + TLSServerHandler.getWantClientAuth(this.ts));
            }
        }
    }

    @Override
    public ProfileMessage produceMessage() throws IOException {
        TLSMessage tlspm = new TLSMessage(2);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> TLS server message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + tlspm.getProfileName());
            logger.trace("produceMessage", "Status : " + tlspm.getStatus());
        }
        this.completed = true;
        return tlspm;
    }

    @Override
    public void consumeMessage(ProfileMessage pm) throws IOException {
        if (!(pm instanceof TLSMessage)) {
            throw new IOException("Unexpected profile message type: " + pm.getClass().getName());
        }
        TLSMessage tlspm = (TLSMessage)pm;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> TLS client message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + tlspm.getProfileName());
            logger.trace("consumeMessage", "Status : " + tlspm.getStatus());
        }
        if (tlspm.getStatus() != 1) {
            throw new IOException("Unexpected TLS status [" + tlspm.getStatus() + "]");
        }
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public Subject activate() throws IOException {
        if (logger.traceOn()) {
            logger.trace("activate", ">>>>> TLS handshake <<<<<");
            logger.trace("activate", "TLS: Start TLS Handshake");
        }
        this.ts.startHandshake();
        SSLSession session = this.ts.getSession();
        if (session != null) {
            if (logger.traceOn()) {
                logger.trace("activate", "TLS: getCipherSuite = " + session.getCipherSuite());
                logger.trace("activate", "TLS: getPeerHost = " + session.getPeerHost());
                if (bundledJSSE) {
                    logger.trace("activate", "TLS: getProtocol = " + TLSServerHandler.getProtocol(session));
                }
            }
            try {
                X509Certificate[] certificate = session.getPeerCertificateChain();
                if (certificate != null && certificate[0] != null) {
                    Principal p = certificate[0].getSubjectDN();
                    String pn = p.getName();
                    if (bundledJSSE) {
                        try {
                            Class<?> cl = Class.forName(X500_PRINCIPAL);
                            Constructor<?> co = cl.getConstructor(String.class);
                            p = (Principal)co.newInstance(pn);
                        }
                        catch (Exception e) {
                            String mh = "TLS: Client Authentication: ";
                            logger.trace("activate", "TLS: Client Authentication: " + e.getMessage());
                            logger.debug("activate", e);
                            logger.trace("activate", "TLS: Client Authentication: Got exception building the javax.security.auth.x500.X500Principal from the principal stored in the client's certificate.");
                            logger.trace("activate", "TLS: Client Authentication: Subject DN = [" + pn + "]");
                            logger.trace("activate", "TLS: Client Authentication: Default to JMXPrincipal[" + pn + "]");
                            p = new JMXPrincipal(pn);
                        }
                    } else {
                        p = new JMXPrincipal(pn);
                    }
                    final Principal principal = p;
                    if (this.subject == null) {
                        this.subject = new Subject();
                    }
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            TLSServerHandler.this.subject.getPrincipals().add(principal);
                            return null;
                        }
                    });
                    logger.trace("activate", "TLS: Client Authentication OK! SubjectDN = " + principal);
                } else {
                    logger.trace("activate", "TLS: No Client Authentication");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                logger.trace("activate", "TLS: No Client Authentication: " + e.getMessage());
            }
            logger.trace("activate", "TLS: Finish TLS Handshake");
        }
        ((SocketConnectionIf)((Object)this.mc)).setSocket(this.ts);
        return this.subject;
    }

    @Override
    public void terminate() throws IOException {
    }

    @Override
    public String getName() {
        return this.profile;
    }

    static {
        boolean error = false;
        try {
            getProtocol = SSLSession.class.getMethod("getProtocol", new Class[0]);
            getEnabledProtocols = SSLSocket.class.getMethod("getEnabledProtocols", new Class[0]);
            setEnabledProtocols = SSLSocket.class.getMethod("setEnabledProtocols", String[].class);
            getWantClientAuth = SSLSocket.class.getMethod("getWantClientAuth", new Class[0]);
            setWantClientAuth = SSLSocket.class.getMethod("setWantClientAuth", Boolean.TYPE);
        }
        catch (Throwable t2) {
            error = true;
        }
        bundledJSSE = !error;
        logger = new ClassLogger("javax.management.remote.misc", "TLSServerHandler");
    }
}

